/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jena.cmdline.ArgDecl;
import jena.cmdline.CommandLine;

abstract class DBcmd {
    protected final ArgDecl argDeclDbURL = new ArgDecl(true, "db");
    protected final ArgDecl argDeclDbType = new ArgDecl(true, "dbType");
    protected final ArgDecl argDeclDbUser = new ArgDecl(true, "dbUser", "user");
    protected final ArgDecl argDeclDbPassword = new ArgDecl(true, "dbPassword", "password", "pw");
    protected final ArgDecl argDeclModelName = new ArgDecl(true, "model");
    protected final ArgDecl argDeclDbDriver = new ArgDecl(true, "driver");
    protected final ArgDecl argDeclVerbose = new ArgDecl(false, "v", "verbose");
    protected boolean verbose = false;
    protected final ArgDecl argDeclDebug = new ArgDecl(false, "debug");
    protected boolean debug = false;
    protected final ArgDecl argDeclHelp = new ArgDecl(false, "help", "h");
    protected String argDbURL = null;
    protected String argDbType = null;
    protected String argDbUser = null;
    protected String argDbPassword = null;
    protected String argModelName = null;
    static Map drivers = new HashMap();
    boolean takesPositionalArgs = false;
    String cmdName = "DB";
    CommandLine cmdLine = new CommandLine();
    private IDBConnection jdbcConnection = null;
    private ModelRDB dbModel = null;
    private String[] usage = new String[]{"Complain to jena-dev: someone forgot the usage string"};

    DBcmd(String string, boolean bl) {
        this.cmdName = string;
        this.takesPositionalArgs = bl;
        this.cmdLine.add(this.argDeclDbURL);
        this.cmdLine.add(this.argDeclDbType);
        this.cmdLine.add(this.argDeclDbUser);
        this.cmdLine.add(this.argDeclDbPassword);
        this.cmdLine.add(this.argDeclModelName);
        this.cmdLine.add(this.argDeclVerbose);
        this.cmdLine.add(this.argDeclDebug);
        this.cmdLine.add(this.argDeclHelp);
    }

    protected void init(String[] stringArray) {
        try {
            this.cmdLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.usage();
            System.exit(1);
        }
        if (this.cmdLine.contains(this.argDeclHelp)) {
            this.usage();
            System.exit(0);
        }
        this.verbose = this.cmdLine.contains(this.argDeclVerbose);
        this.debug = this.cmdLine.contains(this.argDeclDebug);
        if (this.debug) {
            this.verbose = true;
        }
        if (this.cmdLine.contains(this.argDeclDbURL)) {
            this.argDbURL = this.cmdLine.getArg(this.argDeclDbURL).getValue();
        }
        if (this.cmdLine.contains(this.argDeclDbType)) {
            this.argDbType = this.cmdLine.getArg(this.argDeclDbType).getValue();
        }
        if (this.cmdLine.contains(this.argDeclDbUser)) {
            this.argDbUser = this.cmdLine.getArg(this.argDeclDbUser).getValue();
        }
        if (this.cmdLine.contains(this.argDeclDbPassword)) {
            this.argDbPassword = this.cmdLine.getArg(this.argDeclDbPassword).getValue();
        }
        if (this.cmdLine.contains(this.argDeclModelName)) {
            this.argModelName = this.cmdLine.getArg(this.argDeclModelName).getValue();
        }
        if (this.verbose) {
            System.out.println("URL       = " + this.argDbURL);
            System.out.println("User      = " + this.argDbUser);
            System.out.println("Password  = " + this.argDbPassword);
            System.out.println("Type      = " + this.argDbType);
            System.out.println("Name      = " + this.argModelName);
        }
        if (this.argDbURL == null || this.argDbType == null || this.argDbUser == null || this.argDbPassword == null) {
            System.err.println("Missing a required argument (need JDBC URL, user, password and DB type)");
            System.exit(9);
        }
        if (!this.takesPositionalArgs && this.cmdLine.items().size() != 0) {
            System.err.println(this.cmdName + ": No positional arguments allowed");
            this.usage();
            System.exit(9);
        }
        if (this.takesPositionalArgs && this.cmdLine.items().size() == 0) {
            System.err.println(this.cmdName + ": Positional argument required");
            this.usage();
            System.exit(9);
        }
        String string = (String)drivers.get(this.argDbType);
        if (this.cmdLine.contains(this.argDeclDbDriver)) {
            string = this.cmdLine.getArg(this.argDeclDbDriver).getValue();
        }
        if (string == null) {
            System.err.println("No driver: please say which JDBC driver to use");
            System.exit(9);
        }
        try {
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Couldn't load the driver class: " + string);
            System.err.println("" + exception);
            System.exit(9);
        }
    }

    protected ModelRDB getRDBModel() {
        if (this.dbModel == null) {
            try {
                if (this.argModelName == null) {
                    this.dbModel = ModelRDB.open(this.getConnection());
                } else {
                    try {
                        this.dbModel = ModelRDB.open(this.getConnection(), this.argModelName);
                    }
                    catch (DoesNotExistException doesNotExistException) {
                        System.out.println("No model '" + this.argModelName + "' in that database");
                        System.exit(9);
                    }
                }
            }
            catch (RDFRDBException rDFRDBException) {
                Throwable throwable = rDFRDBException.getCause();
                if (throwable == null) {
                    throwable = rDFRDBException;
                }
                System.out.println("Failed to connect to the database: " + throwable.getMessage());
                System.exit(9);
            }
        }
        return this.dbModel;
    }

    protected IDBConnection getConnection() {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = new DBConnection(this.argDbURL, this.argDbUser, this.argDbPassword, this.argDbType);
            }
            catch (Exception exception) {
                System.out.println("Exception making connection: " + exception.getMessage());
                System.exit(9);
            }
        }
        return this.jdbcConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec() {
        if (this.cmdLine.items().size() == 0) {
            this.exec0();
            return;
        }
        boolean bl = false;
        try {
            if (this.getRDBModel().supportsTransactions()) {
                bl = true;
                this.getRDBModel().begin();
            }
            Iterator iterator = this.cmdLine.items().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                boolean bl2 = false;
                try {
                    bl2 = this.exec1(string);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace(System.out);
                    if (bl) {
                        this.getRDBModel().abort();
                        bl = false;
                    }
                    this.dbModel.close();
                    this.dbModel = null;
                    System.exit(9);
                }
                if (bl2 || !bl) continue;
                this.getRDBModel().commit();
                if (!iterator.hasNext()) continue;
                bl = true;
                this.getRDBModel().begin();
            }
        }
        finally {
            if (bl) {
                this.getRDBModel().commit();
            }
        }
        this.dbModel.close();
        this.dbModel = null;
    }

    abstract void exec0();

    abstract boolean exec1(String var1);

    protected void setUsage(String string) {
        String[] stringArray = new String[]{string};
        this.setUsage(stringArray);
    }

    protected void setUsage(String[] stringArray) {
        this.usage = stringArray;
    }

    protected void usage() {
        for (int i = 0; i < this.usage.length; ++i) {
            System.err.println(this.usage[i]);
        }
    }

    static {
        drivers.put("mysql", "com.mysql.jdbc.Driver");
        drivers.put("postgresql", "org.postgresql.Driver");
        drivers.put("postgres", "org.postgresql.Driver");
        drivers.put("postgresql", "org.postgresql.Driver");
        drivers.put("PostgreSQL", "org.postgresql.Driver");
    }
}

