/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;

public class rdfcompare {
    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 4) {
            rdfcompare.usage();
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = "RDF/XML";
        if (stringArray.length > 2) {
            string3 = stringArray[2];
        }
        String string4 = "N-TRIPLE";
        if (stringArray.length == 4) {
            string4 = stringArray[3];
        }
        System.out.println(string + " " + string2 + " " + string3 + " " + string4);
        try {
            Model model = ModelFactory.createDefaultModel();
            Model model2 = ModelFactory.createDefaultModel();
            rdfcompare.read(model, string, string3);
            rdfcompare.read(model2, string2, string4);
            if (model.isIsomorphicWith(model2)) {
                System.out.println("models are equal");
                System.out.println();
                System.exit(0);
            } else {
                System.out.println("models are unequal");
                System.out.println();
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + exception.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.rdfcompare source1 source2 [lang1 [lang2]]");
        System.err.println();
        System.err.println("    source1 and source2 can be URL's or filenames");
        System.err.println("    lang1 and lang2 can take values:");
        System.err.println("      RDF/XML");
        System.err.println("      N-TRIPLE");
        System.err.println("      N3");
        System.err.println("    lang1 defaults to RDF/XML, lang2 to N-TRIPLE");
        System.err.println();
    }

    protected static void read(Model model, String string, String string2) throws FileNotFoundException {
        try {
            URL uRL = new URL(string);
            model.read(string, string2);
        }
        catch (MalformedURLException malformedURLException) {
            model.read(new FileInputStream(string), "", string2);
        }
    }
}

