/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.RuleCharacterIterator;
import com.ibm.icu.impl.SortedSetRelation;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.UPropertyAliases;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.SymbolTable;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeMatcher;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.VersionInfo;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class UnicodeSet
extends UnicodeFilter {
    private static final int LOW = 0;
    private static final int HIGH = 0x110000;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    TreeSet strings = new TreeSet();
    private String pat = null;
    private static final int START_EXTRA = 16;
    private static final int GROW_EXTRA = 16;
    private static final String ANY_ID = "ANY";
    private static final String ASCII_ID = "ASCII";
    private static UnicodeSet INCLUSIONS;
    static final VersionInfo NO_VERSION;
    public static final int IGNORE_SPACE = 1;
    public static final int CASE = 2;
    private static Map CASE_EQUIV_CLASS;
    private static final boolean DEFAULT_CASE_MAP = true;
    private static final String CASE_PAIRS = "AaBbCcDdEeFfGgHhIiJjLlMmNnOoPpQqRrTtUuVvWwXxYyZz\u00c0\u00e0\u00c1\u00e1\u00c2\u00e2\u00c3\u00e3\u00c4\u00e4\u00c6\u00e6\u00c7\u00e7\u00c8\u00e8\u00c9\u00e9\u00ca\u00ea\u00cb\u00eb\u00cc\u00ec\u00cd\u00ed\u00ce\u00ee\u00cf\u00ef\u00d0\u00f0\u00d1\u00f1\u00d2\u00f2\u00d3\u00f3\u00d4\u00f4\u00d5\u00f5\u00d6\u00f6\u00d8\u00f8\u00d9\u00f9\u00da\u00fa\u00db\u00fb\u00dc\u00fc\u00dd\u00fd\u00de\u00fe\u00ff\u0178\u0100\u0101\u0102\u0103\u0104\u0105\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d\u010e\u010f\u0110\u0111\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123\u0124\u0125\u0126\u0127\u0128\u0129\u012a\u012b\u012c\u012d\u012e\u012f\u0132\u0133\u0134\u0135\u0136\u0137\u0139\u013a\u013b\u013c\u013d\u013e\u013f\u0140\u0141\u0142\u0143\u0144\u0145\u0146\u0147\u0148\u014a\u014b\u014c\u014d\u014e\u014f\u0150\u0151\u0152\u0153\u0154\u0155\u0156\u0157\u0158\u0159\u015a\u015b\u015c\u015d\u015e\u015f\u0160\u0161\u0162\u0163\u0164\u0165\u0166\u0167\u0168\u0169\u016a\u016b\u016c\u016d\u016e\u016f\u0170\u0171\u0172\u0173\u0174\u0175\u0176\u0177\u0179\u017a\u017b\u017c\u017d\u017e\u0182\u0183\u0184\u0185\u0187\u0188\u018b\u018c\u0191\u0192\u0195\u01f6\u0198\u0199\u019e\u0220\u01a0\u01a1\u01a2\u01a3\u01a4\u01a5\u01a7\u01a8\u01ac\u01ad\u01af\u01b0\u01b3\u01b4\u01b5\u01b6\u01b8\u01b9\u01bc\u01bd\u01bf\u01f7\u01cd\u01ce\u01cf\u01d0\u01d1\u01d2\u01d3\u01d4\u01d5\u01d6\u01d7\u01d8\u01d9\u01da\u01db\u01dc\u018e\u01dd\u01de\u01df\u01e0\u01e1\u01e2\u01e3\u01e4\u01e5\u01e6\u01e7\u01e8\u01e9\u01ea\u01eb\u01ec\u01ed\u01ee\u01ef\u01f4\u01f5\u01f8\u01f9\u01fa\u01fb\u01fc\u01fd\u01fe\u01ff\u0200\u0201\u0202\u0203\u0204\u0205\u0206\u0207\u0208\u0209\u020a\u020b\u020c\u020d\u020e\u020f\u0210\u0211\u0212\u0213\u0214\u0215\u0216\u0217\u0218\u0219\u021a\u021b\u021c\u021d\u021e\u021f\u0222\u0223\u0224\u0225\u0226\u0227\u0228\u0229\u022a\u022b\u022c\u022d\u022e\u022f\u0230\u0231\u0232\u0233\u0181\u0253\u0186\u0254\u0189\u0256\u018a\u0257\u018f\u0259\u0190\u025b\u0193\u0260\u0194\u0263\u0197\u0268\u0196\u0269\u019c\u026f\u019d\u0272\u019f\u0275\u01a6\u0280\u01a9\u0283\u01ae\u0288\u01b1\u028a\u01b2\u028b\u01b7\u0292\u0386\u03ac\u0388\u03ad\u0389\u03ae\u038a\u03af\u0391\u03b1\u0393\u03b3\u0394\u03b4\u0396\u03b6\u0397\u03b7\u039b\u03bb\u039d\u03bd\u039e\u03be\u039f\u03bf\u03a4\u03c4\u03a5\u03c5\u03a7\u03c7\u03a8\u03c8\u03aa\u03ca\u03ab\u03cb\u038c\u03cc\u038e\u03cd\u038f\u03ce\u03d8\u03d9\u03da\u03db\u03dc\u03dd\u03de\u03df\u03e0\u03e1\u03e2\u03e3\u03e4\u03e5\u03e6\u03e7\u03e8\u03e9\u03ea\u03eb\u03ec\u03ed\u03ee\u03ef\u0410\u0430\u0411\u0431\u0412\u0432\u0413\u0433\u0414\u0434\u0415\u0435\u0416\u0436\u0417\u0437\u0418\u0438\u0419\u0439\u041a\u043a\u041b\u043b\u041c\u043c\u041d\u043d\u041e\u043e\u041f\u043f\u0420\u0440\u0421\u0441\u0422\u0442\u0423\u0443\u0424\u0444\u0425\u0445\u0426\u0446\u0427\u0447\u0428\u0448\u0429\u0449\u042a\u044a\u042b\u044b\u042c\u044c\u042d\u044d\u042e\u044e\u042f\u044f\u0400\u0450\u0401\u0451\u0402\u0452\u0403\u0453\u0404\u0454\u0405\u0455\u0406\u0456\u0407\u0457\u0408\u0458\u0409\u0459\u040a\u045a\u040b\u045b\u040c\u045c\u040d\u045d\u040e\u045e\u040f\u045f\u0460\u0461\u0462\u0463\u0464\u0465\u0466\u0467\u0468\u0469\u046a\u046b\u046c\u046d\u046e\u046f\u0470\u0471\u0472\u0473\u0474\u0475\u0476\u0477\u0478\u0479\u047a\u047b\u047c\u047d\u047e\u047f\u0480\u0481\u048a\u048b\u048c\u048d\u048e\u048f\u0490\u0491\u0492\u0493\u0494\u0495\u0496\u0497\u0498\u0499\u049a\u049b\u049c\u049d\u049e\u049f\u04a0\u04a1\u04a2\u04a3\u04a4\u04a5\u04a6\u04a7\u04a8\u04a9\u04aa\u04ab\u04ac\u04ad\u04ae\u04af\u04b0\u04b1\u04b2\u04b3\u04b4\u04b5\u04b6\u04b7\u04b8\u04b9\u04ba\u04bb\u04bc\u04bd\u04be\u04bf\u04c1\u04c2\u04c3\u04c4\u04c5\u04c6\u04c7\u04c8\u04c9\u04ca\u04cb\u04cc\u04cd\u04ce\u04d0\u04d1\u04d2\u04d3\u04d4\u04d5\u04d6\u04d7\u04d8\u04d9\u04da\u04db\u04dc\u04dd\u04de\u04df\u04e0\u04e1\u04e2\u04e3\u04e4\u04e5\u04e6\u04e7\u04e8\u04e9\u04ea\u04eb\u04ec\u04ed\u04ee\u04ef\u04f0\u04f1\u04f2\u04f3\u04f4\u04f5\u04f8\u04f9\u0500\u0501\u0502\u0503\u0504\u0505\u0506\u0507\u0508\u0509\u050a\u050b\u050c\u050d\u050e\u050f\u0531\u0561\u0532\u0562\u0533\u0563\u0534\u0564\u0535\u0565\u0536\u0566\u0537\u0567\u0538\u0568\u0539\u0569\u053a\u056a\u053b\u056b\u053c\u056c\u053d\u056d\u053e\u056e\u053f\u056f\u0540\u0570\u0541\u0571\u0542\u0572\u0543\u0573\u0544\u0574\u0545\u0575\u0546\u0576\u0547\u0577\u0548\u0578\u0549\u0579\u054a\u057a\u054b\u057b\u054c\u057c\u054d\u057d\u054e\u057e\u054f\u057f\u0550\u0580\u0551\u0581\u0552\u0582\u0553\u0583\u0554\u0584\u0555\u0585\u0556\u0586\u1e00\u1e01\u1e02\u1e03\u1e04\u1e05\u1e06\u1e07\u1e08\u1e09\u1e0a\u1e0b\u1e0c\u1e0d\u1e0e\u1e0f\u1e10\u1e11\u1e12\u1e13\u1e14\u1e15\u1e16\u1e17\u1e18\u1e19\u1e1a\u1e1b\u1e1c\u1e1d\u1e1e\u1e1f\u1e20\u1e21\u1e22\u1e23\u1e24\u1e25\u1e26\u1e27\u1e28\u1e29\u1e2a\u1e2b\u1e2c\u1e2d\u1e2e\u1e2f\u1e30\u1e31\u1e32\u1e33\u1e34\u1e35\u1e36\u1e37\u1e38\u1e39\u1e3a\u1e3b\u1e3c\u1e3d\u1e3e\u1e3f\u1e40\u1e41\u1e42\u1e43\u1e44\u1e45\u1e46\u1e47\u1e48\u1e49\u1e4a\u1e4b\u1e4c\u1e4d\u1e4e\u1e4f\u1e50\u1e51\u1e52\u1e53\u1e54\u1e55\u1e56\u1e57\u1e58\u1e59\u1e5a\u1e5b\u1e5c\u1e5d\u1e5e\u1e5f\u1e62\u1e63\u1e64\u1e65\u1e66\u1e67\u1e68\u1e69\u1e6a\u1e6b\u1e6c\u1e6d\u1e6e\u1e6f\u1e70\u1e71\u1e72\u1e73\u1e74\u1e75\u1e76\u1e77\u1e78\u1e79\u1e7a\u1e7b\u1e7c\u1e7d\u1e7e\u1e7f\u1e80\u1e81\u1e82\u1e83\u1e84\u1e85\u1e86\u1e87\u1e88\u1e89\u1e8a\u1e8b\u1e8c\u1e8d\u1e8e\u1e8f\u1e90\u1e91\u1e92\u1e93\u1e94\u1e95\u1ea0\u1ea1\u1ea2\u1ea3\u1ea4\u1ea5\u1ea6\u1ea7\u1ea8\u1ea9\u1eaa\u1eab\u1eac\u1ead\u1eae\u1eaf\u1eb0\u1eb1\u1eb2\u1eb3\u1eb4\u1eb5\u1eb6\u1eb7\u1eb8\u1eb9\u1eba\u1ebb\u1ebc\u1ebd\u1ebe\u1ebf\u1ec0\u1ec1\u1ec2\u1ec3\u1ec4\u1ec5\u1ec6\u1ec7\u1ec8\u1ec9\u1eca\u1ecb\u1ecc\u1ecd\u1ece\u1ecf\u1ed0\u1ed1\u1ed2\u1ed3\u1ed4\u1ed5\u1ed6\u1ed7\u1ed8\u1ed9\u1eda\u1edb\u1edc\u1edd\u1ede\u1edf\u1ee0\u1ee1\u1ee2\u1ee3\u1ee4\u1ee5\u1ee6\u1ee7\u1ee8\u1ee9\u1eea\u1eeb\u1eec\u1eed\u1eee\u1eef\u1ef0\u1ef1\u1ef2\u1ef3\u1ef4\u1ef5\u1ef6\u1ef7\u1ef8\u1ef9\u1f00\u1f08\u1f01\u1f09\u1f02\u1f0a\u1f03\u1f0b\u1f04\u1f0c\u1f05\u1f0d\u1f06\u1f0e\u1f07\u1f0f\u1f10\u1f18\u1f11\u1f19\u1f12\u1f1a\u1f13\u1f1b\u1f14\u1f1c\u1f15\u1f1d\u1f20\u1f28\u1f21\u1f29\u1f22\u1f2a\u1f23\u1f2b\u1f24\u1f2c\u1f25\u1f2d\u1f26\u1f2e\u1f27\u1f2f\u1f30\u1f38\u1f31\u1f39\u1f32\u1f3a\u1f33\u1f3b\u1f34\u1f3c\u1f35\u1f3d\u1f36\u1f3e\u1f37\u1f3f\u1f40\u1f48\u1f41\u1f49\u1f42\u1f4a\u1f43\u1f4b\u1f44\u1f4c\u1f45\u1f4d\u1f51\u1f59\u1f53\u1f5b\u1f55\u1f5d\u1f57\u1f5f\u1f60\u1f68\u1f61\u1f69\u1f62\u1f6a\u1f63\u1f6b\u1f64\u1f6c\u1f65\u1f6d\u1f66\u1f6e\u1f67\u1f6f\u1f70\u1fba\u1f71\u1fbb\u1f72\u1fc8\u1f73\u1fc9\u1f74\u1fca\u1f75\u1fcb\u1f76\u1fda\u1f77\u1fdb\u1f78\u1ff8\u1f79\u1ff9\u1f7a\u1fea\u1f7b\u1feb\u1f7c\u1ffa\u1f7d\u1ffb\u1fb0\u1fb8\u1fb1\u1fb9\u1fd0\u1fd8\u1fd1\u1fd9\u1fe0\u1fe8\u1fe1\u1fe9\u1fe5\u1fec\u2160\u2170\u2161\u2171\u2162\u2172\u2163\u2173\u2164\u2174\u2165\u2175\u2166\u2176\u2167\u2177\u2168\u2178\u2169\u2179\u216a\u217a\u216b\u217b\u216c\u217c\u216d\u217d\u216e\u217e\u216f\u217f\u24b6\u24d0\u24b7\u24d1\u24b8\u24d2\u24b9\u24d3\u24ba\u24d4\u24bb\u24d5\u24bc\u24d6\u24bd\u24d7\u24be\u24d8\u24bf\u24d9\u24c0\u24da\u24c1\u24db\u24c2\u24dc\u24c3\u24dd\u24c4\u24de\u24c5\u24df\u24c6\u24e0\u24c7\u24e1\u24c8\u24e2\u24c9\u24e3\u24ca\u24e4\u24cb\u24e5\u24cc\u24e6\u24cd\u24e7\u24ce\u24e8\u24cf\u24e9\uff21\uff41\uff22\uff42\uff23\uff43\uff24\uff44\uff25\uff45\uff26\uff46\uff27\uff47\uff28\uff48\uff29\uff49\uff2a\uff4a\uff2b\uff4b\uff2c\uff4c\uff2d\uff4d\uff2e\uff4e\uff2f\uff4f\uff30\uff50\uff31\uff51\uff32\uff52\uff33\uff53\uff34\uff54\uff35\uff55\uff36\uff56\uff37\uff57\uff38\uff58\uff39\uff59\uff3a\uff5a";
    private static final String[][] CASE_NONPAIRS;

    public UnicodeSet() {
        this.list = new int[17];
        this.list[this.len++] = 0x110000;
    }

    public UnicodeSet(UnicodeSet other) {
        this.set(other);
    }

    public UnicodeSet(int start, int end) {
        this();
        this.complement(start, end);
    }

    public UnicodeSet(String pattern) {
        this();
        this.applyPattern(pattern, null, null, 1);
    }

    public UnicodeSet(String pattern, boolean ignoreWhitespace) {
        this();
        this.applyPattern(pattern, null, null, ignoreWhitespace ? 1 : 0);
    }

    public UnicodeSet(String pattern, int options) {
        this();
        this.applyPattern(pattern, null, null, options);
    }

    public UnicodeSet(String pattern, ParsePosition pos, SymbolTable symbols) {
        this();
        this.applyPattern(pattern, pos, symbols, 1);
    }

    public UnicodeSet(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        this();
        this.applyPattern(pattern, pos, symbols, options);
    }

    public Object clone() {
        return new UnicodeSet(this);
    }

    public UnicodeSet set(int start, int end) {
        this.clear();
        this.complement(start, end);
        return this;
    }

    public UnicodeSet set(UnicodeSet other) {
        this.list = (int[])other.list.clone();
        this.len = other.len;
        this.pat = other.pat;
        this.strings = (TreeSet)other.strings.clone();
        return this;
    }

    public final UnicodeSet applyPattern(String pattern) {
        return this.applyPattern(pattern, null, null, 1);
    }

    public UnicodeSet applyPattern(String pattern, boolean ignoreWhitespace) {
        return this.applyPattern(pattern, null, null, ignoreWhitespace ? 1 : 0);
    }

    public UnicodeSet applyPattern(String pattern, int options) {
        return this.applyPattern(pattern, null, null, options);
    }

    public static boolean resemblesPattern(String pattern, int pos) {
        return pos + 1 < pattern.length() && pattern.charAt(pos) == '[' || UnicodeSet.resemblesPropertyPattern(pattern, pos);
    }

    private static void _appendToPat(StringBuffer buf, String s, boolean escapeUnprintable) {
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(i)) {
            UnicodeSet._appendToPat(buf, UTF16.charAt(s, i), escapeUnprintable);
        }
    }

    private static void _appendToPat(StringBuffer buf, int c, boolean escapeUnprintable) {
        if (escapeUnprintable && Utility.isUnprintable(c) && Utility.escapeUnprintable(buf, c)) {
            return;
        }
        switch (c) {
            case 36: 
            case 38: 
            case 45: 
            case 58: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 123: 
            case 125: {
                buf.append('\\');
                break;
            }
            default: {
                if (!UCharacterProperty.isRuleWhiteSpace(c)) break;
                buf.append('\\');
            }
        }
        UTF16.append(buf, c);
    }

    public String toPattern(boolean escapeUnprintable) {
        StringBuffer result = new StringBuffer();
        return this._toPattern(result, escapeUnprintable).toString();
    }

    private StringBuffer _toPattern(StringBuffer result, boolean escapeUnprintable) {
        if (this.pat != null) {
            int backslashCount = 0;
            int i = 0;
            while (i < this.pat.length()) {
                int c = UTF16.charAt(this.pat, i);
                i += UTF16.getCharCount(c);
                if (escapeUnprintable && Utility.isUnprintable(c)) {
                    if (backslashCount % 2 == 1) {
                        result.setLength(result.length() - 1);
                    }
                    Utility.escapeUnprintable(result, c);
                    backslashCount = 0;
                    continue;
                }
                UTF16.append(result, c);
                if (c == 92) {
                    ++backslashCount;
                    continue;
                }
                backslashCount = 0;
            }
            return result;
        }
        return this._generatePattern(result, escapeUnprintable);
    }

    public StringBuffer _generatePattern(StringBuffer result, boolean escapeUnprintable) {
        int end;
        int start;
        int i;
        result.append('[');
        int count = this.getRangeCount();
        if (count > 1 && this.getRangeStart(0) == 0 && this.getRangeEnd(count - 1) == 0x10FFFF) {
            result.append('^');
            for (i = 1; i < count; ++i) {
                start = this.getRangeEnd(i - 1) + 1;
                end = this.getRangeStart(i) - 1;
                UnicodeSet._appendToPat(result, start, escapeUnprintable);
                if (start == end) continue;
                if (start + 1 != end) {
                    result.append('-');
                }
                UnicodeSet._appendToPat(result, end, escapeUnprintable);
            }
        } else {
            for (i = 0; i < count; ++i) {
                start = this.getRangeStart(i);
                end = this.getRangeEnd(i);
                UnicodeSet._appendToPat(result, start, escapeUnprintable);
                if (start == end) continue;
                if (start + 1 != end) {
                    result.append('-');
                }
                UnicodeSet._appendToPat(result, end, escapeUnprintable);
            }
        }
        if (this.strings.size() > 0) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                result.append('{');
                UnicodeSet._appendToPat(result, (String)it.next(), escapeUnprintable);
                result.append('}');
            }
        }
        return result.append(']');
    }

    public int size() {
        int n = 0;
        int count = this.getRangeCount();
        for (int i = 0; i < count; ++i) {
            n += this.getRangeEnd(i) - this.getRangeStart(i) + 1;
        }
        return n + this.strings.size();
    }

    public boolean isEmpty() {
        return this.len == 1 && this.strings.size() == 0;
    }

    public boolean matchesIndexValue(int v) {
        for (int i = 0; i < this.getRangeCount(); ++i) {
            int high;
            int low = this.getRangeStart(i);
            if (!((low & 0xFFFFFF00) == ((high = this.getRangeEnd(i)) & 0xFFFFFF00) ? (low & 0xFF) <= v && v <= (high & 0xFF) : (low & 0xFF) <= v || v <= (high & 0xFF))) continue;
            return true;
        }
        if (this.strings.size() != 0) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                int c = UTF16.charAt(s, 0);
                if ((c & 0xFF) != v) continue;
                return true;
            }
        }
        return false;
    }

    public int matches(Replaceable text, int[] offset, int limit, boolean incremental) {
        if (offset[0] == limit) {
            if (this.contains(65535)) {
                return incremental ? 1 : 2;
            }
            return 0;
        }
        if (this.strings.size() != 0) {
            Iterator it = this.strings.iterator();
            boolean forward = offset[0] < limit;
            char firstChar = text.charAt(offset[0]);
            int highWaterLength = 0;
            while (it.hasNext()) {
                String trial = (String)it.next();
                char c = trial.charAt(forward ? 0 : trial.length() - 1);
                if (forward && c > firstChar) break;
                if (c != firstChar) continue;
                int len = UnicodeSet.matchRest(text, offset[0], limit, trial);
                if (incremental) {
                    int maxLen;
                    int n = maxLen = forward ? limit - offset[0] : offset[0] - limit;
                    if (len == maxLen) {
                        return 1;
                    }
                }
                if (len != trial.length()) continue;
                if (len > highWaterLength) {
                    highWaterLength = len;
                }
                if (!forward || len >= highWaterLength) continue;
                break;
            }
            if (highWaterLength != 0) {
                offset[0] = offset[0] + (forward ? highWaterLength : -highWaterLength);
                return 2;
            }
        }
        return super.matches(text, offset, limit, incremental);
    }

    private static int matchRest(Replaceable text, int start, int limit, String s) {
        int maxLen;
        int slen = s.length();
        if (start < limit) {
            maxLen = limit - start;
            if (maxLen > slen) {
                maxLen = slen;
            }
            for (int i = 1; i < maxLen; ++i) {
                if (text.charAt(start + i) == s.charAt(i)) continue;
                return 0;
            }
        } else {
            maxLen = start - limit;
            if (maxLen > slen) {
                maxLen = slen;
            }
            --slen;
            for (int i = 1; i < maxLen; ++i) {
                if (text.charAt(start - i) == s.charAt(slen - i)) continue;
                return 0;
            }
        }
        return maxLen;
    }

    public void addMatchSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this);
    }

    public int indexOf(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = 0;
        int n = 0;
        int start;
        while (c >= (start = this.list[i++])) {
            int limit;
            if (c < (limit = this.list[i++])) {
                return n + c - start;
            }
            n += limit - start;
        }
        return -1;
    }

    public int charAt(int index) {
        if (index >= 0) {
            int len2 = this.len & 0xFFFFFFFE;
            int i = 0;
            while (i < len2) {
                int start;
                int count;
                if (index < (count = this.list[i++] - (start = this.list[i++]))) {
                    return start + index;
                }
                index -= count;
            }
        }
        return -1;
    }

    public UnicodeSet add(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start < end) {
            this.add(this.range(start, end), 2, 0);
        } else if (start == end) {
            this.add(start);
        }
        return this;
    }

    public final UnicodeSet add(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = this.findCodePoint(c);
        if ((i & 1) != 0) {
            return this;
        }
        if (c == this.list[i] - 1) {
            this.list[i] = c;
            if (c == 0x10FFFF) {
                this.ensureCapacity(this.len + 1);
                this.list[this.len++] = 0x110000;
            }
            if (i > 0 && c == this.list[i - 1]) {
                System.arraycopy(this.list, i + 1, this.list, i - 1, this.len - i - 1);
                this.len -= 2;
            }
        } else if (i > 0 && c == this.list[i - 1]) {
            int n = i - 1;
            this.list[n] = this.list[n] + 1;
        } else {
            if (this.len + 2 > this.list.length) {
                int[] temp = new int[this.len + 2 + 16];
                if (i != 0) {
                    System.arraycopy(this.list, 0, temp, 0, i);
                }
                System.arraycopy(this.list, i, temp, i + 2, this.len - i);
                this.list = temp;
            } else {
                System.arraycopy(this.list, i, this.list, i + 2, this.len - i);
            }
            this.list[i] = c;
            this.list[i + 1] = c + 1;
            this.len += 2;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet add(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.add(s);
            this.pat = null;
        } else {
            this.add(cp, cp);
        }
        return this;
    }

    private static int getSingleCP(String s) {
        if (s.length() < 1) {
            throw new IllegalArgumentException("Can't use zero-length strings in UnicodeSet");
        }
        if (s.length() > 2) {
            return -1;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        int cp = UTF16.charAt(s, 0);
        if (cp > 65535) {
            return cp;
        }
        return -1;
    }

    public final UnicodeSet addAll(String s) {
        int cp;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s, i);
            this.add(cp, cp);
        }
        return this;
    }

    public final UnicodeSet retainAll(String s) {
        return this.retainAll(UnicodeSet.fromAll(s));
    }

    public final UnicodeSet complementAll(String s) {
        return this.complementAll(UnicodeSet.fromAll(s));
    }

    public final UnicodeSet removeAll(String s) {
        return this.removeAll(UnicodeSet.fromAll(s));
    }

    public static UnicodeSet from(String s) {
        return new UnicodeSet().add(s);
    }

    public static UnicodeSet fromAll(String s) {
        return new UnicodeSet().addAll(s);
    }

    public UnicodeSet retain(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 0);
        } else {
            this.clear();
        }
        return this;
    }

    public final UnicodeSet retain(int c) {
        return this.retain(c, c);
    }

    public final UnicodeSet retain(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            boolean isIn = this.strings.contains(s);
            if (isIn && this.size() == 1) {
                return this;
            }
            this.clear();
            this.strings.add(s);
            this.pat = null;
        } else {
            this.retain(cp, cp);
        }
        return this;
    }

    public UnicodeSet remove(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 2);
        }
        return this;
    }

    public final UnicodeSet remove(int c) {
        return this.remove(c, c);
    }

    public final UnicodeSet remove(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.remove(s);
            this.pat = null;
        } else {
            this.remove(cp, cp);
        }
        return this;
    }

    public UnicodeSet complement(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.xor(this.range(start, end), 2, 0);
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(int c) {
        return this.complement(c, c);
    }

    public UnicodeSet complement() {
        if (this.list[0] == 0) {
            System.arraycopy(this.list, 1, this.list, 0, this.len - 1);
            --this.len;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.list, 0, this.list, 1, this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    public final UnicodeSet complement(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            if (this.strings.contains(s)) {
                this.strings.remove(s);
            } else {
                this.strings.add(s);
            }
            this.pat = null;
        } else {
            this.complement(cp, cp);
        }
        return this;
    }

    public boolean contains(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = this.findCodePoint(c);
        return (i & 1) != 0;
    }

    private final int findCodePoint(int c) {
        if (c < this.list[0]) {
            return 0;
        }
        if (this.len >= 2 && c >= this.list[this.len - 2]) {
            return this.len - 1;
        }
        int lo = 0;
        int hi = this.len - 1;
        int i;
        while ((i = lo + hi >>> 1) != lo) {
            if (c < this.list[i]) {
                hi = i;
                continue;
            }
            lo = i;
        }
        return hi;
    }

    public boolean contains(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = this.findCodePoint(start);
        return (i & 1) != 0 && end < this.list[i];
    }

    public final boolean contains(String s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            return this.strings.contains(s);
        }
        return this.contains(cp);
    }

    public boolean containsAll(UnicodeSet c) {
        int n = c.getRangeCount();
        for (int i = 0; i < n; ++i) {
            if (this.contains(c.getRangeStart(i), c.getRangeEnd(i))) continue;
            return false;
        }
        return this.strings.containsAll(c.strings);
    }

    public boolean containsAll(String s) {
        int cp;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s, i);
            if (this.contains(cp)) continue;
            return false;
        }
        return true;
    }

    public boolean containsNone(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = -1;
        while (start >= this.list[++i]) {
        }
        return (i & 1) == 0 && end < this.list[i];
    }

    public boolean containsNone(UnicodeSet c) {
        int n = c.getRangeCount();
        for (int i = 0; i < n; ++i) {
            if (this.containsNone(c.getRangeStart(i), c.getRangeEnd(i))) continue;
            return false;
        }
        return SortedSetRelation.hasRelation(this.strings, 5, c.strings);
    }

    public boolean containsNone(String s) {
        int cp;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s, i);
            if (!this.contains(cp)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsSome(int start, int end) {
        return !this.containsNone(start, end);
    }

    public final boolean containsSome(UnicodeSet s) {
        return !this.containsNone(s);
    }

    public final boolean containsSome(String s) {
        return !this.containsNone(s);
    }

    public UnicodeSet addAll(UnicodeSet c) {
        this.add(c.list, c.len, 0);
        this.strings.addAll(c.strings);
        return this;
    }

    public UnicodeSet retainAll(UnicodeSet c) {
        this.retain(c.list, c.len, 0);
        this.strings.retainAll(c.strings);
        return this;
    }

    public UnicodeSet removeAll(UnicodeSet c) {
        this.retain(c.list, c.len, 2);
        this.strings.removeAll(c.strings);
        return this;
    }

    public UnicodeSet complementAll(UnicodeSet c) {
        this.xor(c.list, c.len, 0);
        SortedSetRelation.doOperation(this.strings, 5, c.strings);
        return this;
    }

    public UnicodeSet clear() {
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        this.strings.clear();
        return this;
    }

    public int getRangeCount() {
        return this.len / 2;
    }

    public int getRangeStart(int index) {
        return this.list[index * 2];
    }

    public int getRangeEnd(int index) {
        return this.list[index * 2 + 1] - 1;
    }

    public UnicodeSet compact() {
        if (this.len != this.list.length) {
            int[] temp = new int[this.len];
            System.arraycopy(this.list, 0, temp, 0, this.len);
            this.list = temp;
        }
        this.rangeList = null;
        this.buffer = null;
        return this;
    }

    public boolean equals(Object o) {
        try {
            UnicodeSet that = (UnicodeSet)o;
            if (this.len != that.len) {
                return false;
            }
            for (int i = 0; i < this.len; ++i) {
                if (this.list[i] == that.list[i]) continue;
                return false;
            }
            if (!this.strings.equals(that.strings)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.len;
        for (int i = 0; i < this.len; ++i) {
            result *= 1000003;
            result += this.list[i];
        }
        return result;
    }

    public String toString() {
        return this.toPattern(true);
    }

    UnicodeSet applyPattern(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        boolean parsePositionWasNull;
        boolean bl = parsePositionWasNull = pos == null;
        if (parsePositionWasNull) {
            pos = new ParsePosition(0);
        }
        StringBuffer rebuiltPat = new StringBuffer();
        RuleCharacterIterator chars = new RuleCharacterIterator(pattern, symbols, pos);
        this.applyPattern(chars, symbols, rebuiltPat, options);
        if (chars.inVariable()) {
            UnicodeSet.syntaxError(chars, "Extra chars in variable value");
        }
        this.pat = rebuiltPat.toString();
        if (parsePositionWasNull) {
            int i = pos.getIndex();
            if ((options & 1) != 0) {
                i = Utility.skipWhitespace(pattern, i);
            }
            if (i != pattern.length()) {
                throw new IllegalArgumentException("Parse of \"" + pattern + "\" failed at " + i);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void applyPattern(RuleCharacterIterator chars, SymbolTable symbols, StringBuffer rebuiltPat, int options) {
        int opts = 3;
        if ((options & 1) != 0) {
            opts |= 4;
        }
        StringBuffer pat = new StringBuffer();
        StringBuffer buf = null;
        boolean usePat = false;
        UnicodeSet scratch = null;
        Object backup = null;
        char lastItem = '\u0000';
        int lastChar = 0;
        int mode = 0;
        char op = '\u0000';
        boolean invert = false;
        this.clear();
        block25: while (mode != 2 && !chars.atEnd()) {
            int setMode;
            UnicodeSet nested;
            boolean literal;
            int c;
            block67: {
                UnicodeMatcher m;
                block69: {
                    block68: {
                        c = 0;
                        literal = false;
                        nested = null;
                        setMode = 0;
                        if (!UnicodeSet.resemblesPropertyPattern(chars, opts)) break block68;
                        setMode = 2;
                        break block67;
                    }
                    backup = chars.getPos(backup);
                    c = chars.next(opts);
                    literal = chars.isEscaped();
                    if (c != 91 || literal) break block69;
                    if (mode == 1) {
                        chars.setPos(backup);
                        setMode = 1;
                        break block67;
                    } else {
                        mode = 1;
                        pat.append('[');
                        backup = chars.getPos(backup);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        if (c == 94 && !literal) {
                            invert = true;
                            pat.append('^');
                            backup = chars.getPos(backup);
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                        }
                        if (c == 45) {
                            literal = true;
                            break block67;
                        } else {
                            chars.setPos(backup);
                            continue;
                        }
                    }
                }
                if (symbols != null && (m = symbols.lookupMatcher(c)) != null) {
                    try {
                        nested = (UnicodeSet)m;
                        setMode = 3;
                    }
                    catch (ClassCastException e) {
                        UnicodeSet.syntaxError(chars, "Syntax error");
                    }
                }
            }
            if (setMode != 0) {
                if (lastItem == '\u0001') {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Char expected after operator");
                    }
                    this.add(lastChar, lastChar);
                    UnicodeSet._appendToPat(pat, lastChar, false);
                    op = '\u0000';
                    lastItem = '\u0000';
                }
                if (op == '-' || op == '&') {
                    pat.append(op);
                }
                if (nested == null) {
                    if (scratch == null) {
                        scratch = new UnicodeSet();
                    }
                    nested = scratch;
                }
                switch (setMode) {
                    case 1: {
                        nested.applyPattern(chars, symbols, pat, options);
                        break;
                    }
                    case 2: {
                        chars.skipIgnored(opts);
                        nested.applyPropertyPattern(chars, pat, symbols);
                        break;
                    }
                    case 3: {
                        nested._toPattern(pat, false);
                        break;
                    }
                }
                usePat = true;
                if (mode == 0) {
                    this.set(nested);
                    mode = 2;
                    break;
                }
                switch (op) {
                    case '-': {
                        this.removeAll(nested);
                        break;
                    }
                    case '&': {
                        this.retainAll(nested);
                        break;
                    }
                    case '\u0000': {
                        this.addAll(nested);
                        break;
                    }
                }
                op = '\u0000';
                lastItem = '\u0002';
                continue;
            }
            if (mode == 0) {
                UnicodeSet.syntaxError(chars, "Missing '['");
            }
            if (!literal) {
                switch (c) {
                    case 93: {
                        if (lastItem == '\u0001') {
                            this.add(lastChar, lastChar);
                            UnicodeSet._appendToPat(pat, lastChar, false);
                        }
                        if (op == '-') {
                            this.add(op, op);
                            pat.append(op);
                        } else if (op == '&') {
                            UnicodeSet.syntaxError(chars, "Trailing '&'");
                        }
                        pat.append(']');
                        mode = 2;
                        continue block25;
                    }
                    case 45: {
                        if (op == '\u0000') {
                            if (lastItem != '\u0000') {
                                op = (char)c;
                                continue block25;
                            }
                            this.add(c, c);
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                            if (c == 93 && !literal) {
                                pat.append("-]");
                                mode = 2;
                                continue block25;
                            }
                        }
                        UnicodeSet.syntaxError(chars, "'-' not after char or set");
                    }
                    case 38: {
                        if (lastItem == '\u0002' && op == '\u0000') {
                            op = (char)c;
                            continue block25;
                        }
                        UnicodeSet.syntaxError(chars, "'&' not after set");
                    }
                    case 94: {
                        UnicodeSet.syntaxError(chars, "'^' not after '['");
                    }
                    case 123: {
                        if (op != '\u0000') {
                            UnicodeSet.syntaxError(chars, "Missing operand after operator");
                        }
                        if (lastItem == '\u0001') {
                            this.add(lastChar, lastChar);
                            UnicodeSet._appendToPat(pat, lastChar, false);
                        }
                        lastItem = '\u0000';
                        if (buf == null) {
                            buf = new StringBuffer();
                        } else {
                            buf.setLength(0);
                        }
                        boolean ok = false;
                        while (!chars.atEnd()) {
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                            if (c == 125 && !literal) {
                                ok = true;
                                break;
                            }
                            UTF16.append(buf, c);
                        }
                        if (buf.length() < 1 || !ok) {
                            UnicodeSet.syntaxError(chars, "Invalid multicharacter string");
                        }
                        this.add(buf.toString());
                        pat.append('{');
                        UnicodeSet._appendToPat(pat, buf.toString(), false);
                        pat.append('}');
                        continue block25;
                    }
                    case 36: {
                        boolean anchor;
                        backup = chars.getPos(backup);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        boolean bl = anchor = c == 93 && !literal;
                        if (symbols == null && !anchor) {
                            c = 36;
                            chars.setPos(backup);
                            break;
                        }
                        if (anchor && op == '\u0000') {
                            if (lastItem == '\u0001') {
                                this.add(lastChar, lastChar);
                                UnicodeSet._appendToPat(pat, lastChar, false);
                            }
                            this.add(65535);
                            usePat = true;
                            pat.append('$').append(']');
                            mode = 2;
                            continue block25;
                        }
                        UnicodeSet.syntaxError(chars, "Unquoted '$'");
                        break;
                    }
                }
            }
            switch (lastItem) {
                case '\u0000': {
                    lastItem = '\u0001';
                    lastChar = c;
                    break;
                }
                case '\u0001': {
                    if (op == '-') {
                        if (lastChar >= c) {
                            UnicodeSet.syntaxError(chars, "Invalid range");
                        }
                        this.add(lastChar, c);
                        UnicodeSet._appendToPat(pat, lastChar, false);
                        pat.append(op);
                        UnicodeSet._appendToPat(pat, c, false);
                        op = '\u0000';
                        lastItem = '\u0000';
                        break;
                    }
                    this.add(lastChar, lastChar);
                    UnicodeSet._appendToPat(pat, lastChar, false);
                    lastChar = c;
                    break;
                }
                case '\u0002': {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Set expected after operator");
                    }
                    lastChar = c;
                    lastItem = '\u0001';
                    continue block25;
                }
            }
        }
        if (mode != 2) {
            UnicodeSet.syntaxError(chars, "Missing ']'");
        }
        chars.skipIgnored(opts);
        if ((options & 2) != 0) {
            this.closeOver(2);
        }
        if (invert) {
            this.complement();
        }
        if (usePat) {
            rebuiltPat.append(pat.toString());
            return;
        }
        this._generatePattern(rebuiltPat, false);
    }

    private static void syntaxError(RuleCharacterIterator chars, String msg) {
        throw new IllegalArgumentException("Error: " + msg + " at \"" + Utility.escape(chars.toString()) + '\"');
    }

    public void addAllTo(Collection target) {
        UnicodeSetIterator it = new UnicodeSetIterator(this);
        while (it.next()) {
            target.add(it.getString());
        }
    }

    public void addAll(Collection source) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            this.add(it.next().toString());
        }
    }

    private void ensureCapacity(int newLen) {
        if (newLen <= this.list.length) {
            return;
        }
        int[] temp = new int[newLen + 16];
        System.arraycopy(this.list, 0, temp, 0, this.len);
        this.list = temp;
    }

    private void ensureBufferCapacity(int newLen) {
        if (this.buffer != null && newLen <= this.buffer.length) {
            return;
        }
        this.buffer = new int[newLen + 16];
    }

    private int[] range(int start, int end) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{start, end + 1, 0x110000};
        } else {
            this.rangeList[0] = start;
            this.rangeList[1] = end + 1;
        }
        return this.rangeList;
    }

    private UnicodeSet xor(int[] other, int otherLen, int polarity) {
        int b;
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        if (polarity == 1 || polarity == 2) {
            b = 0;
            if (other[j] == 0) {
                b = other[++j];
            }
        } else {
            b = other[j++];
        }
        while (true) {
            if (a < b) {
                this.buffer[k++] = a;
                a = this.list[i++];
                continue;
            }
            if (b < a) {
                this.buffer[k++] = b;
                b = other[j++];
                continue;
            }
            if (a == 0x110000) break;
            a = this.list[i++];
            b = other[j++];
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet add(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        if (k > 0 && a <= this.buffer[k - 1]) {
                            a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = a;
                            a = this.list[i];
                        }
                        ++i;
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        if (k > 0 && b <= this.buffer[k - 1]) {
                            b = UnicodeSet.max(other[j], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = b;
                            b = other[j];
                        }
                        ++j;
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    if (k > 0 && a <= this.buffer[k - 1]) {
                        a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                    } else {
                        this.buffer[k++] = a;
                        a = this.list[i];
                    }
                    ++i;
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 3: {
                    if (b <= a) {
                        if (a == 0x110000) break block6;
                        this.buffer[k++] = a;
                    } else {
                        if (b == 0x110000) break block6;
                        this.buffer[k++] = b;
                    }
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 1: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private UnicodeSet retain(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 3: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 1: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    private static final int max(int a, int b) {
        return a > b ? a : b;
    }

    private static synchronized UnicodeSet getInclusions() {
        if (INCLUSIONS == null) {
            UCharacterProperty property = UCharacterProperty.getInstance();
            INCLUSIONS = property.getInclusions();
        }
        return INCLUSIONS;
    }

    private UnicodeSet applyFilter(Filter filter) {
        this.clear();
        int startHasProperty = -1;
        UnicodeSet inclusions = UnicodeSet.getInclusions();
        int limitRange = inclusions.getRangeCount();
        for (int j = 0; j < limitRange; ++j) {
            int start = inclusions.getRangeStart(j);
            int end = inclusions.getRangeEnd(j);
            for (int ch = start; ch <= end; ++ch) {
                if (filter.contains(ch)) {
                    if (startHasProperty >= 0) continue;
                    startHasProperty = ch;
                    continue;
                }
                if (startHasProperty < 0) continue;
                this.add(startHasProperty, ch - 1);
                startHasProperty = -1;
            }
        }
        if (startHasProperty >= 0) {
            this.add(startHasProperty, 0x10FFFF);
        }
        return this;
    }

    private static String mungeCharName(String source) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            int ch = UTF16.charAt(source, i);
            i += UTF16.getCharCount(ch);
            if (UCharacterProperty.isRuleWhiteSpace(ch)) {
                if (buf.length() == 0 || buf.charAt(buf.length() - 1) == ' ') continue;
                ch = 32;
            }
            UTF16.append(buf, ch);
        }
        if (buf.length() != 0 && buf.charAt(buf.length() - 1) == ' ') {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public UnicodeSet applyIntPropertyValue(int prop, int value) {
        if (prop == 8192) {
            this.applyFilter(new GeneralCategoryMaskFilter(value));
        } else {
            this.applyFilter(new IntPropertyFilter(prop, value));
        }
        return this;
    }

    public UnicodeSet applyPropertyAlias(String propertyAlias, String valueAlias) {
        return this.applyPropertyAlias(propertyAlias, valueAlias, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UnicodeSet applyPropertyAlias(String propertyAlias, String valueAlias, SymbolTable symbols) {
        int v;
        int p;
        boolean mustNotBeEmpty;
        block25: {
            mustNotBeEmpty = false;
            if (symbols != null && symbols instanceof XSymbolTable && ((XSymbolTable)symbols).applyPropertyAlias(propertyAlias, valueAlias, this)) {
                return this;
            }
            if (valueAlias.length() > 0) {
                p = UCharacter.getPropertyEnum(propertyAlias);
                if (p == 4101) {
                    p = 8192;
                }
                if (p >= 0 && p < 42 || p >= 4096 && p < 4114 || p >= 8192 && p < 8193) {
                    try {
                        v = UCharacter.getPropertyValueEnum(p, valueAlias);
                    }
                    catch (IllegalArgumentException e) {
                        if (p != 4098 && p != 4112 && p != 4113) {
                            throw e;
                        }
                        v = Integer.parseInt(Utility.deleteRuleWhiteSpace(valueAlias));
                        mustNotBeEmpty = true;
                    }
                    break block25;
                } else {
                    switch (p) {
                        case 12288: {
                            double value = Double.parseDouble(Utility.deleteRuleWhiteSpace(valueAlias));
                            this.applyFilter(new NumericValueFilter(value));
                            return this;
                        }
                        case 16389: 
                        case 16395: {
                            int ch;
                            String buf = UnicodeSet.mungeCharName(valueAlias);
                            int n = ch = p == 16389 ? UCharacter.getCharFromExtendedName(buf) : UCharacter.getCharFromName1_0(buf);
                            if (ch == -1) {
                                throw new IllegalArgumentException("Invalid character name");
                            }
                            this.clear();
                            this.add(ch);
                            return this;
                        }
                        case 16384: {
                            VersionInfo version = VersionInfo.getInstance(UnicodeSet.mungeCharName(valueAlias));
                            this.applyFilter(new VersionFilter(version));
                            return this;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported property");
                }
            }
            try {
                p = 8192;
                v = UCharacter.getPropertyValueEnum(p, propertyAlias);
            }
            catch (IllegalArgumentException e) {
                try {
                    p = 4106;
                    v = UCharacter.getPropertyValueEnum(p, propertyAlias);
                }
                catch (IllegalArgumentException e2) {
                    try {
                        p = UCharacter.getPropertyEnum(propertyAlias);
                    }
                    catch (IllegalArgumentException e3) {
                        p = -1;
                    }
                    if (p >= 0 && p < 42) {
                        v = 1;
                        break block25;
                    }
                    if (p != -1) {
                        throw new IllegalArgumentException("Missing property value");
                    }
                    if (0 == UPropertyAliases.compare(ANY_ID, propertyAlias)) {
                        this.set(0, 0x10FFFF);
                        return this;
                    }
                    if (0 == UPropertyAliases.compare(ASCII_ID, propertyAlias)) {
                        this.set(0, 127);
                        return this;
                    }
                    throw new IllegalArgumentException("Invalid property alias: " + propertyAlias + "=" + valueAlias);
                }
            }
        }
        this.applyIntPropertyValue(p, v);
        if (mustNotBeEmpty && this.isEmpty()) {
            throw new IllegalArgumentException("Invalid property value");
        }
        return this;
    }

    private static boolean resemblesPropertyPattern(String pattern, int pos) {
        if (pos + 5 > pattern.length()) {
            return false;
        }
        return pattern.regionMatches(pos, "[:", 0, 2) || pattern.regionMatches(true, pos, "\\p", 0, 2) || pattern.regionMatches(pos, "\\N", 0, 2);
    }

    private static boolean resemblesPropertyPattern(RuleCharacterIterator chars, int iterOpts) {
        boolean result = false;
        Object pos = chars.getPos(null);
        int c = chars.next(iterOpts &= 0xFFFFFFFD);
        if (c == 91 || c == 92) {
            int d = chars.next(iterOpts & 0xFFFFFFFB);
            result = c == 91 ? d == 58 : d == 78 || d == 112 || d == 80;
        }
        chars.setPos(pos);
        return result;
    }

    private UnicodeSet applyPropertyPattern(String pattern, ParsePosition ppos, SymbolTable symbols) {
        String valueName;
        String propName;
        int close;
        int pos = ppos.getIndex();
        if (pos + 5 > pattern.length()) {
            return null;
        }
        boolean posix = false;
        boolean isName = false;
        boolean invert = false;
        if (pattern.regionMatches(pos, "[:", 0, 2)) {
            posix = true;
            if ((pos = Utility.skipWhitespace(pattern, pos + 2)) < pattern.length() && pattern.charAt(pos) == '^') {
                ++pos;
                invert = true;
            }
        } else if (pattern.regionMatches(true, pos, "\\p", 0, 2) || pattern.regionMatches(pos, "\\N", 0, 2)) {
            char c = pattern.charAt(pos + 1);
            invert = c == 'P';
            isName = c == 'N';
            pos = Utility.skipWhitespace(pattern, pos + 2);
            if (pos == pattern.length() || pattern.charAt(pos++) != '{') {
                return null;
            }
        } else {
            return null;
        }
        if ((close = pattern.indexOf(posix ? ":]" : "}", pos)) < 0) {
            return null;
        }
        int equals = pattern.indexOf(61, pos);
        if (equals >= 0 && equals < close && !isName) {
            propName = pattern.substring(pos, equals);
            valueName = pattern.substring(equals + 1, close);
        } else {
            propName = pattern.substring(pos, close);
            valueName = "";
            if (isName) {
                valueName = propName;
                propName = "na";
            }
        }
        this.applyPropertyAlias(propName, valueName, symbols);
        if (invert) {
            this.complement();
        }
        ppos.setIndex(close + (posix ? 2 : 1));
        return this;
    }

    private void applyPropertyPattern(RuleCharacterIterator chars, StringBuffer rebuiltPat, SymbolTable symbols) {
        String pat = chars.lookahead();
        ParsePosition pos = new ParsePosition(0);
        this.applyPropertyPattern(pat, pos, symbols);
        if (pos.getIndex() == 0) {
            UnicodeSet.syntaxError(chars, "Invalid property pattern");
        }
        chars.jumpahead(pos.getIndex());
        rebuiltPat.append(pat.substring(0, pos.getIndex()));
    }

    public UnicodeSet closeOver(int attribute) {
        if ((attribute & 2) != 0) {
            UnicodeSet foldSet = new UnicodeSet();
            int n = this.getRangeCount();
            for (int i = 0; i < n; ++i) {
                int start = this.getRangeStart(i);
                int end = this.getRangeEnd(i);
                for (int cp = start; cp <= end; ++cp) {
                    foldSet.caseCloseOne(UTF16.valueOf(cp));
                }
            }
            if (this.strings.size() > 0) {
                Iterator it = this.strings.iterator();
                while (it.hasNext()) {
                    foldSet.caseCloseOne(UCharacter.foldCase((String)it.next(), true));
                }
            }
            this.set(foldSet);
        }
        return this;
    }

    private void caseCloseOne(String folded) {
        String[] equiv = (String[])CASE_EQUIV_CLASS.get(folded);
        if (equiv == null) {
            this.add(folded);
        } else {
            for (int i = 0; i < equiv.length; ++i) {
                this.add(equiv[i]);
            }
        }
    }

    static {
        String[] a;
        int i;
        INCLUSIONS = null;
        NO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
        CASE_EQUIV_CLASS = null;
        CASE_NONPAIRS = new String[][]{{"a\u02be", "\u1e9a"}, {"ff", "\ufb00"}, {"ffi", "\ufb03"}, {"ffl", "\ufb04"}, {"fi", "\ufb01"}, {"fl", "\ufb02"}, {"h\u0331", "\u1e96"}, {"i\u0307", "\u0130"}, {"j\u030c", "\u01f0"}, {"K", "k", "\u212a"}, {"S", "s", "\u017f"}, {"ss", "\u00df"}, {"st", "\ufb05", "\ufb06"}, {"t\u0308", "\u1e97"}, {"w\u030a", "\u1e98"}, {"y\u030a", "\u1e99"}, {"\u00c5", "\u00e5", "\u212b"}, {"\u01c4", "\u01c5", "\u01c6"}, {"\u01c7", "\u01c8", "\u01c9"}, {"\u01ca", "\u01cb", "\u01cc"}, {"\u01f1", "\u01f2", "\u01f3"}, {"\u0149", "\u02bcn"}, {"\u03ac\u03b9", "\u1fb4"}, {"\u03ae\u03b9", "\u1fc4"}, {"\u03b1\u0342", "\u1fb6"}, {"\u03b1\u0342\u03b9", "\u1fb7"}, {"\u03b1\u03b9", "\u1fb3", "\u1fbc"}, {"\u0392", "\u03b2", "\u03d0"}, {"\u0395", "\u03b5", "\u03f5"}, {"\u03b7\u0342", "\u1fc6"}, {"\u03b7\u0342\u03b9", "\u1fc7"}, {"\u03b7\u03b9", "\u1fc3", "\u1fcc"}, {"\u0398", "\u03b8", "\u03d1", "\u03f4"}, {"\u0345", "\u0399", "\u03b9", "\u1fbe"}, {"\u03b9\u0308\u0300", "\u1fd2"}, {"\u0390", "\u03b9\u0308\u0301", "\u1fd3"}, {"\u03b9\u0308\u0342", "\u1fd7"}, {"\u03b9\u0342", "\u1fd6"}, {"\u039a", "\u03ba", "\u03f0"}, {"\u00b5", "\u039c", "\u03bc"}, {"\u03a0", "\u03c0", "\u03d6"}, {"\u03a1", "\u03c1", "\u03f1"}, {"\u03c1\u0313", "\u1fe4"}, {"\u03a3", "\u03c2", "\u03c3", "\u03f2"}, {"\u03c5\u0308\u0300", "\u1fe2"}, {"\u03b0", "\u03c5\u0308\u0301", "\u1fe3"}, {"\u03c5\u0308\u0342", "\u1fe7"}, {"\u03c5\u0313", "\u1f50"}, {"\u03c5\u0313\u0300", "\u1f52"}, {"\u03c5\u0313\u0301", "\u1f54"}, {"\u03c5\u0313\u0342", "\u1f56"}, {"\u03c5\u0342", "\u1fe6"}, {"\u03a6", "\u03c6", "\u03d5"}, {"\u03a9", "\u03c9", "\u2126"}, {"\u03c9\u0342", "\u1ff6"}, {"\u03c9\u0342\u03b9", "\u1ff7"}, {"\u03c9\u03b9", "\u1ff3", "\u1ffc"}, {"\u03ce\u03b9", "\u1ff4"}, {"\u0565\u0582", "\u0587"}, {"\u0574\u0565", "\ufb14"}, {"\u0574\u056b", "\ufb15"}, {"\u0574\u056d", "\ufb17"}, {"\u0574\u0576", "\ufb13"}, {"\u057e\u0576", "\ufb16"}, {"\u1e60", "\u1e61", "\u1e9b"}, {"\u1f00\u03b9", "\u1f80", "\u1f88"}, {"\u1f01\u03b9", "\u1f81", "\u1f89"}, {"\u1f02\u03b9", "\u1f82", "\u1f8a"}, {"\u1f03\u03b9", "\u1f83", "\u1f8b"}, {"\u1f04\u03b9", "\u1f84", "\u1f8c"}, {"\u1f05\u03b9", "\u1f85", "\u1f8d"}, {"\u1f06\u03b9", "\u1f86", "\u1f8e"}, {"\u1f07\u03b9", "\u1f87", "\u1f8f"}, {"\u1f20\u03b9", "\u1f90", "\u1f98"}, {"\u1f21\u03b9", "\u1f91", "\u1f99"}, {"\u1f22\u03b9", "\u1f92", "\u1f9a"}, {"\u1f23\u03b9", "\u1f93", "\u1f9b"}, {"\u1f24\u03b9", "\u1f94", "\u1f9c"}, {"\u1f25\u03b9", "\u1f95", "\u1f9d"}, {"\u1f26\u03b9", "\u1f96", "\u1f9e"}, {"\u1f27\u03b9", "\u1f97", "\u1f9f"}, {"\u1f60\u03b9", "\u1fa0", "\u1fa8"}, {"\u1f61\u03b9", "\u1fa1", "\u1fa9"}, {"\u1f62\u03b9", "\u1fa2", "\u1faa"}, {"\u1f63\u03b9", "\u1fa3", "\u1fab"}, {"\u1f64\u03b9", "\u1fa4", "\u1fac"}, {"\u1f65\u03b9", "\u1fa5", "\u1fad"}, {"\u1f66\u03b9", "\u1fa6", "\u1fae"}, {"\u1f67\u03b9", "\u1fa7", "\u1faf"}, {"\u1f70\u03b9", "\u1fb2"}, {"\u1f74\u03b9", "\u1fc2"}, {"\u1f7c\u03b9", "\u1ff2"}, {"\ud801\udc00", "\ud801\udc28"}, {"\ud801\udc01", "\ud801\udc29"}, {"\ud801\udc02", "\ud801\udc2a"}, {"\ud801\udc03", "\ud801\udc2b"}, {"\ud801\udc04", "\ud801\udc2c"}, {"\ud801\udc05", "\ud801\udc2d"}, {"\ud801\udc06", "\ud801\udc2e"}, {"\ud801\udc07", "\ud801\udc2f"}, {"\ud801\udc08", "\ud801\udc30"}, {"\ud801\udc09", "\ud801\udc31"}, {"\ud801\udc0a", "\ud801\udc32"}, {"\ud801\udc0b", "\ud801\udc33"}, {"\ud801\udc0c", "\ud801\udc34"}, {"\ud801\udc0d", "\ud801\udc35"}, {"\ud801\udc0e", "\ud801\udc36"}, {"\ud801\udc0f", "\ud801\udc37"}, {"\ud801\udc10", "\ud801\udc38"}, {"\ud801\udc11", "\ud801\udc39"}, {"\ud801\udc12", "\ud801\udc3a"}, {"\ud801\udc13", "\ud801\udc3b"}, {"\ud801\udc14", "\ud801\udc3c"}, {"\ud801\udc15", "\ud801\udc3d"}, {"\ud801\udc16", "\ud801\udc3e"}, {"\ud801\udc17", "\ud801\udc3f"}, {"\ud801\udc18", "\ud801\udc40"}, {"\ud801\udc19", "\ud801\udc41"}, {"\ud801\udc1a", "\ud801\udc42"}, {"\ud801\udc1b", "\ud801\udc43"}, {"\ud801\udc1c", "\ud801\udc44"}, {"\ud801\udc1d", "\ud801\udc45"}, {"\ud801\udc1e", "\ud801\udc46"}, {"\ud801\udc1f", "\ud801\udc47"}, {"\ud801\udc20", "\ud801\udc48"}, {"\ud801\udc21", "\ud801\udc49"}, {"\ud801\udc22", "\ud801\udc4a"}, {"\ud801\udc23", "\ud801\udc4b"}, {"\ud801\udc24", "\ud801\udc4c"}, {"\ud801\udc25", "\ud801\udc4d"}};
        CASE_EQUIV_CLASS = new HashMap();
        for (i = 0; i < CASE_PAIRS.length(); i += 2) {
            a = new String[]{String.valueOf(CASE_PAIRS.charAt(i)), String.valueOf(CASE_PAIRS.charAt(i + 1))};
            CASE_EQUIV_CLASS.put(a[0], a);
            CASE_EQUIV_CLASS.put(a[1], a);
        }
        for (i = 0; i < CASE_NONPAIRS.length; ++i) {
            a = CASE_NONPAIRS[i];
            for (int j = 0; j < a.length; ++j) {
                CASE_EQUIV_CLASS.put(a[j], a);
            }
        }
    }

    static abstract class XSymbolTable
    implements SymbolTable {
        XSymbolTable() {
        }

        public UnicodeMatcher lookupMatcher(int i) {
            return null;
        }

        public boolean applyPropertyAlias(String propertyName, String propertyValue, UnicodeSet result) {
            return false;
        }

        public char[] lookup(String s) {
            return null;
        }

        public String parseReference(String text, ParsePosition pos, int limit) {
            return null;
        }
    }

    private static class VersionFilter
    implements Filter {
        VersionInfo version;

        VersionFilter(VersionInfo version) {
            this.version = version;
        }

        public boolean contains(int ch) {
            VersionInfo v = UCharacter.getAge(ch);
            return v != NO_VERSION && v.compareTo(this.version) <= 0;
        }
    }

    private static class IntPropertyFilter
    implements Filter {
        int prop;
        int value;

        IntPropertyFilter(int prop, int value) {
            this.prop = prop;
            this.value = value;
        }

        public boolean contains(int ch) {
            return UCharacter.getIntPropertyValue(ch, this.prop) == this.value;
        }
    }

    private static class GeneralCategoryMaskFilter
    implements Filter {
        int mask;

        GeneralCategoryMaskFilter(int mask) {
            this.mask = mask;
        }

        public boolean contains(int ch) {
            return (1 << UCharacter.getType(ch) & this.mask) != 0;
        }
    }

    private static class NumericValueFilter
    implements Filter {
        double value;

        NumericValueFilter(double value) {
            this.value = value;
        }

        public boolean contains(int ch) {
            return UCharacter.getUnicodeNumericValue(ch) == this.value;
        }
    }

    private static interface Filter {
        public boolean contains(int var1);
    }
}

