/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;

public class TestUtils {
    static boolean hasQuerySyntax(Resource resource) {
        return resource.hasProperty(TestManifest.querySyntax);
    }

    static String getQuerySyntax(Resource resource) {
        return TestUtils.getLiteralOrURI(resource, TestManifest.querySyntax);
    }

    static String getDataSyntax(Resource resource) {
        return TestUtils.getLiteralOrURI(resource, TestManifest.dataSyntax);
    }

    static Resource getResource(Resource resource, Property property) {
        if (resource == null) {
            return null;
        }
        if (!resource.hasProperty(property)) {
            return null;
        }
        RDFNode rDFNode = resource.getProperty(property).getObject();
        if (rDFNode instanceof Resource) {
            return (Resource)rDFNode;
        }
        throw new QueryTestException("Manifest problem (not a Resource): " + QueryPrintUtils.stringForRDFNode(rDFNode) + " => " + QueryPrintUtils.stringForRDFNode((RDFNode)property));
    }

    static String getLiteral(Resource resource, Property property) {
        if (resource == null) {
            return null;
        }
        if (!resource.hasProperty(property)) {
            return null;
        }
        RDFNode rDFNode = resource.getProperty(property).getObject();
        if (rDFNode instanceof Literal) {
            return ((Literal)rDFNode).getLexicalForm();
        }
        throw new QueryTestException("Manifest problem (not a Literal): " + QueryPrintUtils.stringForRDFNode(rDFNode) + " => " + QueryPrintUtils.stringForRDFNode((RDFNode)property));
    }

    static String getLiteralOrURI(Resource resource, Property property) {
        Resource resource2;
        if (resource == null) {
            return null;
        }
        if (!resource.hasProperty(property)) {
            return null;
        }
        RDFNode rDFNode = resource.getProperty(property).getObject();
        if (rDFNode instanceof Literal) {
            return ((Literal)rDFNode).getLexicalForm();
        }
        if (rDFNode instanceof Resource && !(resource2 = (Resource)rDFNode).isAnon()) {
            return resource2.getURI();
        }
        throw new QueryTestException("Manifest problem: " + QueryPrintUtils.stringForRDFNode(rDFNode) + " => " + QueryPrintUtils.stringForRDFNode((RDFNode)property));
    }
}

