/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util.test;

import com.hp.hpl.jena.query.util.JenaURIException;
import com.hp.hpl.jena.query.util.RelURI;
import com.hp.hpl.jena.query.util.RelativeURIException;
import java.net.URI;
import junit.framework.TestCase;

public class TestURI
extends TestCase {
    public void testURI() {
        this.execTest("", "http://example.org/", "http://example.org/");
    }

    public void testURI_relX_1() {
        this.execTest("x", "http://example.org/ns", "http://example.org/x");
    }

    public void testURI_relX_2() {
        this.execTest("x", "http://example.org/", "http://example.org/x");
    }

    public void testURI2_relHashX_1() {
        this.execTest("#x", "http://example.org/ns", "http://example.org/ns#x");
    }

    public void testURI2_relHashX_2() {
        this.execTest("#x", "http://example.org/ns/", "http://example.org/ns/#x");
    }

    public void testURI_blank_1() {
        this.execTest("", "http://example.org/ns", "http://example.org/ns");
    }

    public void testURI_blank_2() {
        this.execTest("", "http://example.org/ns/", "http://example.org/ns/");
    }

    public void testURI_hash_1() {
        this.execTest("#", "http://example.org/ns", "http://example.org/ns#");
    }

    public void testURI_hash_2() {
        this.execTest("#", "http://example.org/ns/", "http://example.org/ns/#");
    }

    public void testURI_file_1() {
        this.execTest("file:x", "http://example.org/ns", "file:x");
    }

    public void testURI_file_2() {
        this.execTest("x", "file:///A/B/C", "file:///A/B/x");
    }

    public void testURI_file_3() {
        this.execTest("x", "file:///A/B/", "file:///A/B/x");
    }

    public void testURI_abs_1() {
        this.execTest("http://host/x", "http://example.org/ns", "http://host/x");
    }

    public void testURI_abs_2() {
        this.execTest("file:///x", "http://example.org/ns", "file:///x");
    }

    public void testURI_abs_3() {
        this.execTest("tag:foo", "http://example.org/ns", "tag:foo");
    }

    public void testURI_abs_4() {
        this.execTest("tag:/foo", "http://example.org/ns", "tag:/foo");
    }

    public void testURI_abs_5() {
        this.execTest("tag:/foo/", "http://example.org/ns", "tag:/foo/");
    }

    public void testFileURI_1() {
        this.execFileTest("file:///foo", "file:///foo");
    }

    public void testFileURI_2() {
        this.execFileTest("file://foo", "file://foo");
    }

    public void testFileURI_3() {
        this.execFileTest("file:/foo", "file:///foo");
    }

    public void testBaseEmpty() {
        this.execException("x", "", JenaURIException.class);
    }

    public void testBaseNull() {
        this.execException("x", null, JenaURIException.class);
    }

    public void testBaseHash() {
        this.execException("x", "http://example.org/ns#", JenaURIException.class);
    }

    public void testRelBase_1() {
        this.execException("x", "ns", RelativeURIException.class);
    }

    public void testRelBase_2() {
        this.execException("x", "/ns", RelativeURIException.class);
    }

    public void testURI_opaque_1() {
        this.execException("#x", "tag:A", RelativeURIException.class);
    }

    public void testURI_opaque_2() {
        this.execException("#x", "urn:x-jena:A", RelativeURIException.class);
    }

    public void testURI_opaque_3() {
        this.execException("#x", "urn:x-jena:A", RelativeURIException.class);
    }

    public void testURI_file_4() {
        this.execException("x", "file:A", RelativeURIException.class);
    }

    public void testURI_file_5() {
        this.execException("#x", "file:A", RelativeURIException.class);
    }

    public void testFileURI_rel_1() {
        this.execTestFileRelURI("file:foo");
    }

    public void testFileURI_rel_2() {
        this.execTestFileRelURI("file:foo/bar");
    }

    public void testFileURI_rel_3() {
        this.execTestFileRelURI("file:foo/");
    }

    public void testFileURI_rel_4() {
        this.execTestFileRelURI("file:foo/bar/");
    }

    public void testURI_global_null_1() {
        RelURI.setBaseURI(null);
        try {
            this.execTestGlobal("x", "file:///A/B/x");
            TestURI.fail((String)"Didn't get RelativeURIException");
        }
        catch (JenaURIException jenaURIException) {
            // empty catch block
        }
    }

    public void testURI_global_null_2() {
        RelURI.setBaseURI("file:///A/B/");
        this.execTestGlobal("x", "file:///A/B/x");
    }

    private void execTest(String string, String string2, String string3) {
        String string4 = RelURI.resolve(string, string2);
        if (string3 == null) {
            TestURI.assertNull((String)("(" + string + "," + string2 + ") => <null> :: Got: " + string4), (Object)string4);
            return;
        }
        TestURI.assertNotNull((String)("(" + string + "," + string2 + ") => " + string3 + " :: Got: <null>"), (Object)string4);
        TestURI.assertTrue((String)("(" + string + "," + string2 + ") => " + string3 + " :: Got: " + string4), (boolean)string4.equals(string3));
    }

    private void execFileTest(String string, String string2) {
        String string3 = RelURI.resolveFileURL(string);
        TestURI.assertEquals((String)string3, (String)string2);
    }

    private void execTestFileRelURI(String string) {
        String string2 = string.substring("file:".length());
        String string3 = RelURI.resolveFileURL(string);
        TestURI.assertTrue((String)("Lost relative name: (" + string + "=>" + string3 + ")"), (boolean)string3.endsWith(string2));
        TestURI.assertTrue((String)("Not absolute: (" + string + "=>" + string3 + ")"), (boolean)string3.startsWith("file:///"));
        URI uRI = URI.create(string3);
        TestURI.assertTrue((String)("Not absolute to Java: (" + string + "=>" + string3 + ")"), (boolean)uRI.isAbsolute());
    }

    private void execException(String string, String string2, Class clazz) {
        String string3 = clazz.getName();
        int n = string3.lastIndexOf(46);
        if (n >= 0) {
            string3 = string3.substring(n + 1);
        }
        try {
            String string4 = RelURI.resolve(string, string2);
            if (string4 == null) {
                TestURI.fail((String)("(" + string + "," + string2 + ") => <null> :: Expected exception: " + string3));
            } else {
                TestURI.fail((String)("(" + string + "," + string2 + ") => " + string4 + " :: Expected exception: " + string3));
            }
        }
        catch (Exception exception) {
            TestURI.assertEquals((Object)clazz, exception.getClass());
        }
    }

    private void execTestGlobal(String string, String string2) {
        String string3 = RelURI.resolve(string);
        if (string2 == null) {
            TestURI.assertNull((String)("(" + string + ") => <null> :: Got: " + string3), (Object)string3);
            return;
        }
        TestURI.assertNotNull((String)("(" + string + ") => " + string2 + " :: Got: <null>"), (Object)string3);
        TestURI.assertTrue((String)("(" + string + ") => " + string2 + " :: Got: " + string3), (boolean)string3.equals(string2));
    }
}

