/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.schema;

import edu.stanford.db.rdf.schema.InvalidModelException;
import edu.stanford.db.rdf.schema.RDFSchemaModelEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.rdf.implementation.model.NodeFactoryImpl;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.Model;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;
import org.w3c.rdf.model.VirtualModel;
import org.w3c.rdf.util.RDFFactory;
import org.w3c.rdf.util.RDFFactoryImpl;
import org.w3c.rdf.util.RDFUtil;
import org.w3c.rdf.util.SetOperations;
import org.w3c.rdf.vocabulary.rdf_schema_19990303.RDFS;
import org.w3c.rdf.vocabulary.rdf_syntax_19990222.RDF;

public class RDFSchemaModel
implements VirtualModel {
    static final int MAX_CLOSURE_DEPTH = 50;
    NodeFactory nodeFactory;
    Model instances;
    Model closure;

    public RDFSchemaModel() {
        this(new NodeFactoryImpl());
    }

    public RDFSchemaModel(Model model, Model model2) {
        this();
        this.instances = model;
        this.closure = model2;
    }

    public RDFSchemaModel(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public RDFSchemaModel(NodeFactory nodeFactory, Model model, Model model2) {
        this(nodeFactory);
        this.instances = model;
        this.closure = model2;
    }

    public void add(Statement statement) throws ModelException {
        this.instances.add(statement);
    }

    public static Model computeClosure(Model model, Resource resource) throws ModelException {
        return RDFSchemaModel.computeClosure(model, resource, false);
    }

    public static Model computeClosure(Model model, Resource resource, boolean bl) throws ModelException {
        Model model2 = model.create();
        Model model3 = model.find(null, resource, null);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = model3.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            if (hashtable.contains(statement.object()) || !(statement.object() instanceof Resource)) continue;
            hashtable2.clear();
            if (!RDFSchemaModel.traverseClosure(hashtable, (Resource)statement.object(), resource, hashtable2, model2, model, 0) || bl) continue;
            throw new ModelException("[RDFSchemaModel] found invalid loop in transitive closure of " + resource + ". Loop node: " + statement.object());
        }
        return model2;
    }

    public static Model computeRDFSClosure(Model model) throws ModelException {
        Model model2 = RDFSchemaModel.computeClosure(model, RDFS.subClassOf);
        SetOperations.unite(model2, RDFSchemaModel.computeClosure(model, RDFS.subPropertyOf));
        return model2;
    }

    public boolean contains(Statement statement) throws ModelException {
        return this.find(statement.subject(), statement.predicate(), statement.object()).isEmpty() ^ true;
    }

    public Model create() throws ModelException {
        return new RDFSchemaModel(this.instances.create(), this.closure);
    }

    public Model duplicate() throws ModelException {
        return new RDFSchemaModel(this.nodeFactory, this.instances.duplicate(), this.closure);
    }

    public Enumeration elements() throws ModelException {
        return new RDFSchemaModelEnumeration(this.instances, this.closure);
    }

    public Model find(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        Model model;
        block6: {
            Model model2;
            block5: {
                model = this.instances.find(resource, resource2, rDFNode);
                if (rDFNode == null || !RDF.type.equals(resource2)) break block5;
                Model model3 = this.closure.find(null, RDFS.subClassOf, rDFNode);
                if (model3.isEmpty()) break block6;
                Enumeration enumeration = model3.elements();
                while (enumeration.hasMoreElements()) {
                    SetOperations.unite(model, this.instances.find(resource, RDF.type, ((Statement)enumeration.nextElement()).subject()));
                }
                break block6;
            }
            if (RDFS.subClassOf.equals(resource2)) {
                model = this.closure.find(resource, resource2, rDFNode);
            } else if (resource2 != null && !(model2 = this.closure.find(null, RDFS.subPropertyOf, resource2)).isEmpty()) {
                Enumeration enumeration = model2.elements();
                while (enumeration.hasMoreElements()) {
                    SetOperations.unite(model, this.instances.find(resource, ((Statement)enumeration.nextElement()).subject(), rDFNode));
                }
            }
        }
        return model;
    }

    public Model getGroundModel() throws ModelException {
        return this.instances;
    }

    public String getLabel() throws ModelException {
        return this.instances.getLabel();
    }

    public String getLocalName() throws ModelException {
        return this.instances.getLocalName();
    }

    public String getNamespace() throws ModelException {
        return this.instances.getNamespace();
    }

    public NodeFactory getNodeFactory() throws ModelException {
        return this.nodeFactory;
    }

    public String getSourceURI() throws ModelException {
        return this.instances.getSourceURI();
    }

    public String getURI() throws ModelException {
        return this.instances.getURI();
    }

    static void invalid(StringBuffer stringBuffer, Statement statement, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append('\n');
        }
        if (statement != null) {
            stringBuffer.append("Invalid statement:\n\t" + statement + ".\n\t");
        }
        stringBuffer.append(string);
    }

    public boolean isEmpty() throws ModelException {
        return this.instances.isEmpty();
    }

    public boolean isMutable() throws ModelException {
        return this.instances.isMutable();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("RDFSchemaModel <instance URL> {<schema URL>}+");
            System.exit(1);
        }
        RDFFactoryImpl rDFFactoryImpl = new RDFFactoryImpl();
        Model model = rDFFactoryImpl.createModel();
        Model model2 = rDFFactoryImpl.createModel();
        RDFSchemaModel.readModelsFromArgList(rDFFactoryImpl, model, model2, stringArray);
        try {
            RDFSchemaModel.validateRawSchema(model, model2);
            System.err.println("Model is valid.");
        }
        catch (InvalidModelException invalidModelException) {
            System.err.println(invalidModelException.getMessage());
        }
    }

    static boolean noSchema(StringBuffer stringBuffer, RDFNode rDFNode) {
        return false;
    }

    public static void readModelsFromArgList(RDFFactory rDFFactory, Model model, Model model2, String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("READING INSTANCE: " + string);
        RDFUtil.parse(string, rDFFactory.createParser(), model);
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            Model model3 = rDFFactory.createModel();
            System.out.println("READING SCHEMA: " + string2);
            RDFUtil.parse(string2, rDFFactory.createParser(), model3);
            SetOperations.unite(model2, model3);
            ++n;
        }
    }

    public void remove(Statement statement) throws ModelException {
        this.instances.remove(statement);
    }

    public void setSourceURI(String string) throws ModelException {
        this.instances.setSourceURI(string);
    }

    public int size() throws ModelException {
        return -1;
    }

    public String toString() {
        try {
            return "[RDFSchemaModel " + this.getURI() + "]";
        }
        catch (ModelException modelException) {
            return "[RDFSchemaModel: " + modelException + "]";
        }
    }

    private static boolean traverseClosure(Hashtable hashtable, Resource resource, Resource resource2, Hashtable hashtable2, Model model, Model model2, int n) throws ModelException {
        Object object;
        Object object2;
        boolean bl;
        hashtable.put(resource, resource);
        boolean bl2 = bl = hashtable2.contains(resource);
        if (!bl) {
            hashtable2.put(resource, resource);
            object2 = model2.find(null, resource2, resource);
            object = object2.elements();
            while (object.hasMoreElements()) {
                Statement statement = (Statement)object.nextElement();
                bl2 |= RDFSchemaModel.traverseClosure(hashtable, statement.subject(), resource2, hashtable2, model, model2, n + 1);
            }
            if (!bl2) {
                hashtable2.remove(resource);
            }
        }
        if (!bl) {
            object2 = hashtable2.elements();
            while (object2.hasMoreElements()) {
                object = (Resource)object2.nextElement();
                model.add(model2.getNodeFactory().createStatement(resource, resource2, (RDFNode)object));
            }
        }
        return bl2;
    }

    public static void validate(Model model, Model model2) throws ModelException {
        Hashtable<Resource, Statement> hashtable = new Hashtable<Resource, Statement>();
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            Statement statement = (Statement)enumeration.nextElement();
            if (RDF.type.equals(statement.predicate())) {
                if (statement.object() instanceof Literal) {
                    RDFSchemaModel.invalid(stringBuffer, statement, "Literals cannot be used for typing");
                }
                if (!(object2 = model2.find((Resource)statement.object(), RDF.type, RDFS.Class)).isEmpty()) continue;
                if (RDFSchemaModel.noSchema(stringBuffer, statement.object())) break;
                RDFSchemaModel.invalid(stringBuffer, statement, String.valueOf(statement.object().toString()) + " must be an instance of " + RDFS.Class);
                continue;
            }
            if (RDFUtil.getOrd(statement.predicate()) > 0) {
                hashtable.put(statement.subject(), statement);
                continue;
            }
            object2 = new Vector();
            Model model3 = model2.find(statement.predicate(), RDFS.domain, null);
            if (!model3.isEmpty()) {
                boolean bl = false;
                Enumeration enumeration2 = model3.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (Resource)((Statement)enumeration2.nextElement()).object();
                    ((Vector)object2).addElement(object);
                    if (model.find(statement.subject(), RDF.type, (RDFNode)object).isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (RDFSchemaModel.noSchema(stringBuffer, statement.subject())) break;
                    RDFSchemaModel.invalid(stringBuffer, statement, "Subject must be instance of " + object2);
                }
            }
            ((Vector)object2).setSize(0);
            Model model4 = model2.find(statement.predicate(), RDFS.range, null);
            if (model4.size() == 1) {
                boolean bl = false;
                object = model4.elements();
                while (object.hasMoreElements()) {
                    Resource resource = (Resource)((Statement)object.nextElement()).object();
                    ((Vector)object2).addElement(resource);
                    if (RDFS.Literal.equals(resource)) {
                        if (statement.object() instanceof Literal) {
                            bl = true;
                            break;
                        }
                        RDFSchemaModel.invalid(stringBuffer, statement, String.valueOf(String.valueOf(statement.object())) + " must be a literal");
                        continue;
                    }
                    if (!(statement.object() instanceof Resource) || model.find((Resource)statement.object(), RDF.type, resource).isEmpty()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (RDFSchemaModel.noSchema(stringBuffer, statement.object())) break;
                RDFSchemaModel.invalid(stringBuffer, statement, "Object must be instance of " + object2);
                continue;
            }
            if (model4.size() <= 1) continue;
            RDFSchemaModel.invalid(stringBuffer, null, "Invalid schema. Multiple ranges for " + statement.predicate());
        }
        if (stringBuffer.length() > 0) {
            throw new InvalidModelException(stringBuffer.toString());
        }
    }

    public static void validateRawSchema(Model model, Model model2) throws ModelException {
        Model model3 = RDFSchemaModel.computeRDFSClosure(model2);
        RDFSchemaModel rDFSchemaModel = new RDFSchemaModel(model2, model3);
        RDFSchemaModel rDFSchemaModel2 = new RDFSchemaModel(model, model3);
        RDFSchemaModel.validate(rDFSchemaModel2, rDFSchemaModel);
    }
}

