/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.implementation.model;

import java.security.SecureRandom;
import java.util.Random;
import org.w3c.rdf.digest.DigestUtil;
import org.w3c.rdf.implementation.model.LiteralImpl;
import org.w3c.rdf.implementation.model.ResourceImpl;
import org.w3c.rdf.implementation.model.StatementImpl;
import org.w3c.rdf.model.Literal;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class NodeFactoryImpl
implements NodeFactory {
    static final int RANDOM_SEED_LEN = 8;
    private static Random rnd;
    private static Object rndLock;
    private static final int MAX_ORD = 30;
    private static Resource[] ords;

    static {
        rndLock = new String();
        ords = new Resource[31];
        int n = 1;
        while (n <= 30) {
            NodeFactoryImpl.ords[n] = new ResourceImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "_" + n);
            ++n;
        }
        Thread thread = new Thread(){

            public void run() {
                rnd = new SecureRandom(SecureRandom.getSeed(8));
                Object object = rndLock;
                synchronized (object) {
                    rndLock.notify();
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    static /* synthetic */ Random access$0() {
        return rnd;
    }

    public Literal createLiteral(byte by) throws ModelException {
        return this.createLiteral(String.valueOf(by));
    }

    public Literal createLiteral(char c) throws ModelException {
        return this.createLiteral(String.valueOf(c));
    }

    public Literal createLiteral(double d) throws ModelException {
        return this.createLiteral(String.valueOf(d));
    }

    public Literal createLiteral(float f) throws ModelException {
        return this.createLiteral(String.valueOf(f));
    }

    public Literal createLiteral(int n) throws ModelException {
        return this.createLiteral(String.valueOf(n));
    }

    public Literal createLiteral(long l) throws ModelException {
        return this.createLiteral(String.valueOf(l));
    }

    public Literal createLiteral(String string) {
        return string != null ? new LiteralImpl(string) : null;
    }

    public Literal createLiteral(short s) throws ModelException {
        return this.createLiteral(String.valueOf(s));
    }

    public Literal createLiteral(boolean bl) throws ModelException {
        return this.createLiteral(String.valueOf(bl));
    }

    public Resource createOrdinal(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Attempt to construct invalid ordinal resource");
        }
        if (n <= 30) {
            return ords[n];
        }
        return new ResourceImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + n);
    }

    public Resource createResource(String string) {
        return string != null ? new ResourceImpl(string) : null;
    }

    public Resource createResource(String string, String string2) {
        return string2 != null ? new ResourceImpl(string, string2) : null;
    }

    public Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) {
        return resource != null && resource2 != null && rDFNode != null ? new StatementImpl(resource, resource2, rDFNode) : null;
    }

    public Resource createUniqueResource() {
        Object object;
        if (rnd == null) {
            try {
                object = rndLock;
                synchronized (object) {
                    rndLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        object = new byte[16];
        rnd.nextBytes((byte[])object);
        return new ResourceImpl("urn:rdf:" + DigestUtil.toHexString((byte[])object));
    }
}

