/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.ontology.OWLSyntaxChecker;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OWLLiteProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Iterator;
import java.util.List;

public class JenaChecker
implements OWLSyntaxChecker {
    public Resource getOWLLanguageLevel(OntModel ontModel, List list) throws OntologyException {
        Profile profile = ontModel.getProfile();
        if (!(profile instanceof OWLProfile)) {
            throw new OntologyException("Cannnot perform OWL language level test on non OWL model");
        }
        Checker checker = new Checker(false);
        checker.add((Model)ontModel);
        String string = checker.getSubLanguage();
        if (profile instanceof OWLLiteProfile && !string.equals("Lite") && list != null) {
            checker = new Checker(true);
            checker.add((Model)ontModel);
            checker.getSubLanguage();
        }
        if (list != null) {
            Iterator iterator = checker.getProblems();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        }
        if (string.equals("Lite")) {
            return OWL.LITE_LANG;
        }
        if (string.equals("DL")) {
            return OWL.DL_LANG;
        }
        return OWL.FULL_LANG;
    }
}

