/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.test;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.ontology.tidy.StreamingChecker;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.ontology.tidy.impl.CheckerImpl;
import com.hp.hpl.jena.ontology.tidy.test.WGTests;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.wg.TestInputStreamFactory;
import com.hp.hpl.jena.vocabulary.OWLTest;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;

class SyntaxTest
extends TestCase {
    public static boolean HP = true;
    public static Vector cnts = new Vector();
    public static Vector files = new Vector();
    public static Vector first = new Vector();
    final DocMan dm;
    final String uri;

    static String name(String string, String string2) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(47, n - 1);
        return string.substring(n2 + 1, n) + "-" + string2;
    }

    public SyntaxTest(String string, TestInputStreamFactory testInputStreamFactory, String string2) {
        super(SyntaxTest.name(string2, string));
        this.dm = new DocMan(testInputStreamFactory);
        this.uri = string2;
    }

    void add(InputStream inputStream, Resource resource, String string) {
        this.dm.add(string, new DMEntry(string, resource, inputStream));
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    protected void runTest() {
        Iterator iterator = this.dm.table.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            CheckerImpl checkerImpl;
            Object object2;
            String string = (String)iterator.next();
            DMEntry dMEntry = (DMEntry)this.dm.table.get(string);
            Resource resource = dMEntry.lvl;
            if (HP) {
                object2 = new StreamingChecker(dMEntry.lvl.equals(OWLTest.Lite));
                ((StreamingChecker)object2).getRedirect().add("http://www.w3.org/2002/03owlt", "file:testing/wg");
                ((StreamingChecker)object2).load(string);
                checkerImpl = object2;
                cnts.add(new Integer(((StreamingChecker)object2).getTripleCount()));
                first.add(((StreamingChecker)object2).getRedirect().redirect(string));
                files.add(((StreamingChecker)object2).getLoaded());
            } else {
                checkerImpl = new Checker(dMEntry.lvl.equals(OWLTest.Lite));
                dMEntry.init();
                object2 = ModelFactory.createOntologyModel((OntModelSpec)new OntModelSpec(null, (OntDocumentManager)this.dm, null, ProfileRegistry.OWL_LANG), (Model)dMEntry.mdl);
                checkerImpl.addRaw(object2.getGraph());
            }
            object2 = checkerImpl.getSubLanguage();
            if (resource.getURI().endsWith((String)object2)) continue;
            if (resource.equals(OWLTest.Lite) || ((String)object2).equals("Full")) {
                Iterator iterator2 = checkerImpl.getProblems();
                while (iterator2.hasNext()) {
                    object = (SyntaxProblem)iterator2.next();
                    System.err.println(((SyntaxProblem)object).longDescription());
                }
            }
            int n = resource.getURI().lastIndexOf(35);
            object = this.getName() + " is found as OWL " + (String)object2 + " not " + resource.getURI().substring(n + 1);
            System.err.println((String)object);
            WGTests.logResult(this.uri, false);
            SyntaxTest.fail((String)object);
        }
        WGTests.logResult(this.uri, true);
    }

    private static class DocMan
    extends OntDocumentManager {
        final Map table = new HashMap();
        final TestInputStreamFactory fact;

        DocMan(TestInputStreamFactory testInputStreamFactory) {
            super("");
            this.fact = testInputStreamFactory;
        }

        protected boolean read(Model model, String string, boolean bl) {
            DMEntry dMEntry = (DMEntry)this.table.get(string);
            if (dMEntry == null) {
                model.read(this.fact.open(string), string);
            } else {
                dMEntry.init();
                model.add(dMEntry.mdl);
            }
            return true;
        }

        void add(String string, DMEntry dMEntry) {
            this.table.put(string, dMEntry);
        }
    }

    private static class DMEntry {
        Model mdl = null;
        final String url;
        final InputStream in;
        final Resource lvl;

        DMEntry(String string, Resource resource, InputStream inputStream) {
            this.url = string;
            this.lvl = resource;
            this.in = inputStream;
        }

        void init() {
            if (this.mdl == null) {
                this.mdl = ModelFactory.createDefaultModel();
                this.mdl.read(this.in, this.url);
            }
        }
    }
}

