/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.publish.uddi;

import java.io.IOException;

/**
 * Instances of this Interface can be used to publish web services described by
 * WSDL available through a url reference.
 * 
 * @author tilmann
 * 
 */
public interface WsdlPublisher {

	/**
	 * Publish all services defined in the WSDL identified by the given URL.
	 * Services will be published belonging to the business with the given key.
	 * 
	 * @param wsdlUrl
	 *            the URL of the WSDL file
	 * @param businessKey
	 *            the key of the business
	 * @throws IOException
	 */
	public void publishWsdl(String wsdlUrl, String businessKey)
			throws IOException;

	/**
	 * Publish all services defined in the WSDL identified by the given URL.
	 * Search for a business with the given name to publish the services for. If
	 * none can be found publish a new business with given name and description.
	 * 
	 * @param wsdlUrl
	 *            the URL of the WSDL file
	 * @param businessName
	 *            the name of the business to search for
	 * @param businessDescription
	 *            the description of the business to be published
	 * @throws IOException
	 */
	public void publishWsdl(String wsdlUrl, String businessName,
			String businessDescription) throws IOException;

}
