/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

/**
 * This class describes a single search result of ServiceProfileLocator.
 * 
 * @author tilmann
 */
public class ServiceProfileInfo extends ServiceProfileParameter {

	private String profileUri;

	private String description;

	private double relevance;

	/**
	 * @return Returns the relevance.
	 */
	public double getRelevance() {
		return relevance;
	}

	/**
	 * @param relevance
	 *            The relevance to set.
	 */
	public void setRelevance(double relevance) {
		this.relevance = relevance;
	}

	/**
	 * @return Returns the profileUri.
	 */
	public String getProfileUri() {
		return profileUri;
	}

	/**
	 * @param profileUri
	 *            The profileUri to set.
	 */
	public void setProfileUri(String profileUri) {
		this.profileUri = profileUri;
	}

	@Override
	public String toString() {
		return super.toString() + "ProfileUri: " + profileUri + "\nRelevance: "
				+ relevance + "\nDescription: " + description + "\n";
	}

	@Override
	public ServiceProfileInfo clone() {
		return (ServiceProfileInfo) super.clone();
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

}
