/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateClsCommand
extends AbstractCommand {
    private Cls createdCls;
    private FrameID id;
    private String name;
    private Collection types;
    private Collection superclasses;
    private boolean loadDefaults;

    CreateClsCommand(FrameStore frameStore, FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        super(frameStore);
        this.id = frameID;
        this.name = string;
        this.types = new ArrayList(collection);
        this.superclasses = new ArrayList(collection2);
        this.loadDefaults = bl;
    }

    public Object doIt() {
        this.createdCls = this.getDelegate().createCls(this.id, this.name, this.types, this.superclasses, this.loadDefaults);
        this.name = this.getDelegate().getFrameName(this.createdCls);
        this.id = this.createdCls.getFrameID();
        this.setDescription("Create class " + CreateClsCommand.getText(this.createdCls));
        return this.createdCls;
    }

    public void undoIt() {
        this.getDelegate().deleteCls(this.createdCls);
        this.createdCls.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createCls(this.id, this.name, this.types, this.superclasses, this.loadDefaults);
        this.createdCls.markDeleted(false);
    }
}

