/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectSuperclassCommand;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectSuperslotCommand;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectTypeCommand;
import edu.stanford.smi.protege.model.framestore.undo.Command;
import edu.stanford.smi.protege.model.framestore.undo.CreateClsCommand;
import edu.stanford.smi.protege.model.framestore.undo.CreateFacetCommand;
import edu.stanford.smi.protege.model.framestore.undo.CreateSimpleInstanceCommand;
import edu.stanford.smi.protege.model.framestore.undo.CreateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteClsCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteFacetCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteSimpleInstanceCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.MacroCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectOwnSlotValueCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectSubclassCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectSubslotCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectTypeCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectSuperclassCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectSuperslotCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectTemplateFacetOverridesCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectTypeCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetDirectOwnSlotValuesCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetDirectTemplateFacetValuesCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetFrameNameCommand;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UndoFrameStore
extends ModificationFrameStore
implements CommandManager {
    Logger log = Log.getLogger(UndoFrameStore.class);
    private static final int NO_COMMAND = -1;
    private Collection _listeners = new ArrayList();
    private List _commands = new ArrayList();
    private int _lastExecutedCommand = -1;
    private LinkedList _macroCommandList = new LinkedList();

    public void close() {
        super.close();
        this._listeners = null;
        this._commands = null;
        this._macroCommandList = null;
    }

    private void addExecutedCommand(Command command) {
        if (this._lastExecutedCommand != this._commands.size() - 1) {
            this._commands = new ArrayList(this._commands.subList(0, this._lastExecutedCommand + 1));
        }
        this._commands.add(command);
        ++this._lastExecutedCommand;
    }

    public void reinitialize() {
        this._commands.clear();
        this._macroCommandList.clear();
        this._lastExecutedCommand = -1;
    }

    private Object execute(Command command) {
        Object object = this.isInTransaction() ? this.transactionCommandExecute(command) : this.simpleCommandExecute(command);
        return object;
    }

    private Object simpleCommandExecute(Command command) {
        Object object = command.doIt();
        this.addExecutedCommand(command);
        this.notifyListeners();
        return object;
    }

    private Object transactionCommandExecute(Command command) {
        Object object = command.doIt();
        this.getCurrentMacro().add(command);
        return object;
    }

    private MacroCommand getCurrentMacro() {
        return this._macroCommandList.isEmpty() ? null : this._macroCommandList.getLast();
    }

    private boolean isInTransaction() {
        return !this._macroCommandList.isEmpty();
    }

    public boolean canUndo() {
        return this._lastExecutedCommand >= 0;
    }

    public boolean canRedo() {
        return this._lastExecutedCommand < this._commands.size() - 1;
    }

    public void undo() {
        if (this.canUndo()) {
            Command command = (Command)this._commands.get(this._lastExecutedCommand);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("undoing " + command.getDescription());
            }
            command.undoIt();
            --this._lastExecutedCommand;
            this.notifyListeners();
        } else {
            Log.getLogger().warning("Not able to undo");
        }
    }

    public Command getUndoCommand() {
        return this.canUndo() ? (Command)this._commands.get(this._lastExecutedCommand) : null;
    }

    public Command getRedoCommand() {
        return this.canRedo() ? (Command)this._commands.get(this._lastExecutedCommand + 1) : null;
    }

    public void redo() {
        if (this.canRedo()) {
            ++this._lastExecutedCommand;
            Command command = (Command)this._commands.get(this._lastExecutedCommand);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("redoing " + command.getDescription());
            }
            command.redoIt();
            this.notifyListeners();
        } else {
            Log.getLogger().warning("Not able to redo");
        }
    }

    public Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        CreateClsCommand createClsCommand = new CreateClsCommand(this.getDelegate(), frameID, string, collection, collection2, bl);
        return (Cls)this.execute(createClsCommand);
    }

    public Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        CreateSlotCommand createSlotCommand = new CreateSlotCommand(this.getDelegate(), frameID, string, collection, collection2, bl);
        return (Slot)this.execute(createSlotCommand);
    }

    public Facet createFacet(FrameID frameID, String string, Collection collection, boolean bl) {
        CreateFacetCommand createFacetCommand = new CreateFacetCommand(this.getDelegate(), frameID, string, collection, bl);
        return (Facet)this.execute(createFacetCommand);
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        CreateSimpleInstanceCommand createSimpleInstanceCommand = new CreateSimpleInstanceCommand(this.getDelegate(), frameID, string, collection, bl);
        return (SimpleInstance)this.execute(createSimpleInstanceCommand);
    }

    public void deleteCls(Cls cls) {
        this.execute(new DeleteClsCommand(this.getDelegate(), cls));
    }

    public void deleteSlot(Slot slot) {
        this.execute(new DeleteSlotCommand(this.getDelegate(), slot));
    }

    public void deleteFacet(Facet facet) {
        this.execute(new DeleteFacetCommand(this.getDelegate(), facet));
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.execute(new DeleteSimpleInstanceCommand(this.getDelegate(), simpleInstance));
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.execute(new AddDirectTemplateSlotCommand(this.getDelegate(), cls, slot));
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.execute(new RemoveDirectTemplateSlotCommand(this.getDelegate(), slot, cls));
    }

    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        this.execute(new MoveDirectTemplateSlotCommand(this.getDelegate(), slot, cls, n));
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.execute(new SetDirectTemplateSlotCommand(this.getDelegate(), cls, collection, slot));
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.execute(new SetDirectTemplateFacetValuesCommand(this.getDelegate(), slot, cls, facet, collection));
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.execute(new SetDirectOwnSlotValuesCommand(this.getDelegate(), collection, slot, frame));
    }

    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this.execute(new MoveDirectOwnSlotValueCommand(this.getDelegate(), frame, slot, n, n2));
    }

    public void setFrameName(Frame frame, String string) {
        this.execute(new SetFrameNameCommand(this.getDelegate(), string, frame));
    }

    public void addDirectSuperclass(Cls cls, Cls cls2) {
        this.execute(new AddDirectSuperclassCommand(this.getDelegate(), cls2, cls));
    }

    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        this.execute(new RemoveDirectSuperclassCommand(this.getDelegate(), cls2, cls));
    }

    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        this.execute(new MoveDirectSubclassCommand(this.getDelegate(), cls, n, cls2));
    }

    public void addDirectSuperslot(Slot slot, Slot slot2) {
        this.execute(new AddDirectSuperslotCommand(this.getDelegate(), slot2, slot));
    }

    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.execute(new RemoveDirectSuperslotCommand(this.getDelegate(), slot2, slot));
    }

    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        this.execute(new MoveDirectSubslotCommand(this.getDelegate(), slot, n, slot2));
    }

    public void addDirectType(Instance instance, Cls cls) {
        this.execute(new AddDirectTypeCommand(this.getDelegate(), cls, instance));
    }

    public void removeDirectType(Instance instance, Cls cls) {
        this.execute(new RemoveDirectTypeCommand(this.getDelegate(), cls, instance));
    }

    public void moveDirectType(Instance instance, Cls cls, int n) {
        this.execute(new MoveDirectTypeCommand(this.getDelegate(), instance, cls, n));
    }

    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.execute(new RemoveDirectTemplateFacetOverridesCommand(this.getDelegate(), cls, slot));
    }

    public boolean beginTransaction(String string) {
        boolean bl = this.getDelegate().beginTransaction(string);
        this.pushTransaction(new MacroCommand(string, this.getDelegate()));
        return bl;
    }

    private void pushTransaction(MacroCommand macroCommand) {
        MacroCommand macroCommand2 = this.getCurrentMacro();
        if (macroCommand2 == null) {
            this.addExecutedCommand(macroCommand);
        } else {
            macroCommand2.add(macroCommand);
        }
        this._macroCommandList.add(macroCommand);
    }

    private MacroCommand popTransaction() {
        return (MacroCommand)this._macroCommandList.removeLast();
    }

    public boolean commitTransaction() {
        this.popTransaction();
        boolean bl = this.getDelegate().commitTransaction();
        this.notifyListeners();
        return bl;
    }

    public boolean rollbackTransaction() {
        this.popTransaction();
        boolean bl = this.getDelegate().rollbackTransaction();
        if (!bl) {
            this.undo();
            this._commands.remove(this._lastExecutedCommand + 1);
        }
        return bl;
    }

    private void notifyListeners() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this._listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listeners.remove(changeListener);
    }

    public Collection getDoneCommands() {
        List list = this._lastExecutedCommand >= 0 ? this._commands.subList(0, this._lastExecutedCommand + 1) : Collections.EMPTY_LIST;
        return list;
    }

    public Collection getUndoneCommands() {
        List list = this._lastExecutedCommand + 1 < this._commands.size() ? this._commands.subList(this._lastExecutedCommand + 1, this._commands.size()) : Collections.EMPTY_LIST;
        return list;
    }
}

