/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadRDFSSubPropertyOfTestCase
extends AbstractJenaTestCase {
    public void testLoadSubRDFProperty() throws Exception {
        this.loadRemoteOntology("subRDFProperty.owl");
        RDFProperty superProperty = this.owlModel.getRDFProperty("superProperty");
        RDFProperty subProperty = this.owlModel.getRDFProperty("subProperty");
        LoadRDFSSubPropertyOfTestCase.assertNotNull((Object)superProperty);
        LoadRDFSSubPropertyOfTestCase.assertSize(1, subProperty.getSuperproperties(false));
        LoadRDFSSubPropertyOfTestCase.assertContains((Object)superProperty, subProperty.getSuperproperties(false));
    }

    public void testLoadSubpropertyRange() throws Exception {
        this.loadRemoteOntology("subPropertyRange.owl");
        OWLNamedClass personCls = this.owlModel.getOWLNamedClass("Person");
        OWLObjectProperty superproperty = this.owlModel.getOWLObjectProperty("hasChild");
        OWLObjectProperty subproperty = this.owlModel.getOWLObjectProperty("hasSon");
        LoadRDFSSubPropertyOfTestCase.assertSize(1, superproperty.getUnionRangeClasses());
        LoadRDFSSubPropertyOfTestCase.assertEquals((Object)personCls, (Object)superproperty.getRange());
        LoadRDFSSubPropertyOfTestCase.assertEquals((Object)personCls, (Object)subproperty.getRange(true));
        LoadRDFSSubPropertyOfTestCase.assertContains((Object)personCls, superproperty.getUnionRangeClasses());
        LoadRDFSSubPropertyOfTestCase.assertEquals(null, (Object)subproperty.getDirectOwnSlotValue(this.owlModel.getSlot(":SLOT-VALUE-TYPE")));
        LoadRDFSSubPropertyOfTestCase.assertSize(1, subproperty.getUnionRangeClasses());
        LoadRDFSSubPropertyOfTestCase.assertContains((Object)personCls, subproperty.getUnionRangeClasses().iterator());
    }
}

