/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractRDFSClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultRDFSNamedClass
extends AbstractRDFSClass
implements RDFSNamedClass {
    public DefaultRDFSNamedClass(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultRDFSNamedClass() {
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof RDFSNamedClass) {
            return this.getName().equals(((RDFSNamedClass)object).getName());
        }
        return false;
    }

    public Collection getDependingClasses() {
        ArrayList result = new ArrayList();
        this.addAnonymousClses(result, this.getDisjointClasses());
        this.addAnonymousClses(result, this.getDirectSuperclasses());
        return null;
    }

    public Icon getIcon() {
        if (this.isMetaCls()) {
            return this.isEditable() ? OWLIcons.getMetaclassIcon() : OWLIcons.getReadOnlyClsIcon(OWLIcons.getImageIcon("RDFSMetaclass"));
        }
        if (this.isEditable()) {
            return OWLIcons.getImageIcon("RDFSNamedClass");
        }
        return OWLIcons.getReadOnlyClsIcon(OWLIcons.getImageIcon("RDFSNamedClass"));
    }

    public String getIconName() {
        return "RDFSNamedClass";
    }

    public RDFResource createAnonymousInstance() {
        String name = this.getOWLModel().getNextAnonymousResourceName();
        return (RDFResource)this.createDirectInstance(name);
    }

    public RDFIndividual createRDFIndividual(String name) {
        return (RDFIndividual)this.createInstance(name);
    }

    public Set getAssociatedProperties() {
        HashSet<RDFProperty> set = new HashSet<RDFProperty>();
        HashSet domainlessProperties = new HashSet(this.getOWLModel().getDomainlessProperties());
        Collection unionDomainProperties = this.getUnionDomainProperties(true);
        for (RDFProperty property : unionDomainProperties) {
            if (domainlessProperties.contains(property) || !property.isDomainDefined()) continue;
            set.add(property);
            for (RDFProperty subproperty : property.getSubproperties(true)) {
                if (!unionDomainProperties.contains(subproperty)) continue;
                set.add(subproperty);
            }
        }
        return set;
    }

    public RDFSClass getFirstSuperclass() {
        Collection superclasses = this.getSuperclasses(false);
        if (superclasses.isEmpty()) {
            return null;
        }
        return (RDFSClass)superclasses.iterator().next();
    }

    public boolean isFunctionalProperty(RDFProperty property) {
        return property.isFunctional();
    }

    public ImageIcon getImageIcon() {
        if (this.isMetaCls()) {
            return OWLIcons.getMetaclassIcon();
        }
        return OWLIcons.getImageIcon("RDFSNamedClass");
    }

    public String getNestedBrowserText() {
        return this.getBrowserText();
    }

    public void getNestedNamedClasses(Set set) {
        set.add(this);
    }

    public Collection getUnionRangeClasses(RDFProperty property) {
        HashSet<RDFSNamedClass> reached = new HashSet<RDFSNamedClass>();
        ArrayList<RDFSClass> queue = new ArrayList<RDFSClass>();
        queue.add(this);
        while (!queue.isEmpty()) {
            RDFSNamedClass cls = (RDFSNamedClass)queue.get(0);
            queue.remove(0);
            reached.add(cls);
            for (RDFSClass superclass : cls.getSuperclasses(false)) {
                if (superclass instanceof OWLAllValuesFrom) {
                    Collection result = this.getUnionRangeClassesHelper((OWLAllValuesFrom)superclass, property);
                    if (result == null) continue;
                    return result;
                }
                if (superclass instanceof OWLIntersectionClass) {
                    for (AbstractRDFSClass operand : ((OWLIntersectionClass)superclass).getOperands()) {
                        Collection result;
                        if (!(operand instanceof OWLAllValuesFrom) || (result = this.getUnionRangeClassesHelper((OWLAllValuesFrom)((Object)operand), property)) == null) continue;
                        return result;
                    }
                    continue;
                }
                if (!(superclass instanceof RDFSNamedClass) || reached.contains(superclass)) continue;
                queue.add(superclass);
            }
        }
        return property.getUnionRangeClasses();
    }

    private Collection getUnionRangeClassesHelper(OWLAllValuesFrom allValuesFrom, RDFProperty property) {
        if (allValuesFrom.getOnProperty().equals(property)) {
            RDFResource a = allValuesFrom.getAllValuesFrom();
            if (a instanceof OWLUnionClass) {
                return ((OWLUnionClass)a).getOperands();
            }
            if (a instanceof RDFSClass) {
                return Collections.singleton(a);
            }
        }
        return null;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isVisibleFromOWLThing() {
        if (!this.isVisible()) {
            return false;
        }
        HashSet reached = new HashSet();
        return this.isVisibleFromRootCls(reached);
    }

    private boolean isVisibleFromRootCls(Set reached) {
        if (this.isVisible() && !reached.contains(this)) {
            reached.add(this);
            for (Cls superCls : this.getDirectSuperclasses()) {
                DefaultRDFSNamedClass rdfsSuperCls;
                if (superCls.equals(this.getKnowledgeBase().getRootCls())) {
                    return true;
                }
                if (!(superCls instanceof DefaultRDFSNamedClass) || !(rdfsSuperCls = (DefaultRDFSNamedClass)superCls).isVisibleFromRootCls(reached)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDeprecated() {
        RDFSNamedClass c = this.getOWLModel().getOWLDeprecatedClassClass();
        return this.getProtegeTypes().contains(c);
    }

    public void setDeprecated(boolean value) {
        if (this.isDeprecated() != value) {
            RDFSNamedClass c = this.getOWLModel().getRDFSNamedClass("owl:DeprecatedClass");
            if (value) {
                this.addProtegeType(c);
            } else {
                this.removeProtegeType(c);
            }
        }
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitRDFSNamedClass(this);
    }
}

