/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorHandler;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class SymbolEditorComponent
extends JComponent
implements SymbolEditor {
    private SymbolEditorHandler symbolEditorHandler;
    private boolean multiline;
    private SymbolErrorDisplay errorDisplay;
    private OWLModel model;
    private Exception parseException;

    public SymbolEditorComponent(OWLModel model, SymbolErrorDisplay errorDisplay, boolean multiline) {
        this.model = model;
        this.errorDisplay = errorDisplay;
        this.multiline = multiline;
    }

    public abstract JTextComponent getTextComponent();

    protected abstract void parseExpression() throws Exception;

    public void assignExpression() {
        try {
            this.parseExpression();
            if (this.getSymbolEditorHandler() != null) {
                this.getSymbolEditorHandler().stopEditing();
            }
        }
        catch (Exception e) {
            this.parseException = e;
            this.displayError();
        }
    }

    public void displayError() {
        if (this.parseException != null) {
            try {
                this.parseExpression();
            }
            catch (Exception e) {
                this.parseException = e;
            }
        }
        this.errorDisplay.displayError(this.parseException);
    }

    public void setSymbolEditorHandler(SymbolEditorHandler symbolEditorHandler) {
        this.symbolEditorHandler = symbolEditorHandler;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public SymbolEditorHandler getSymbolEditorHandler() {
        return this.symbolEditorHandler;
    }

    public SymbolErrorDisplay getErrorDisplay() {
        return this.errorDisplay;
    }

    public OWLModel getModel() {
        return this.model;
    }

    public void cancelEditing() {
        this.getSymbolEditorHandler().cancelEditing();
    }

    public void backspace() {
        int caretPos = this.getTextComponent().getCaretPosition();
        if (caretPos > 0) {
            Document doc = this.getTextComponent().getDocument();
            try {
                doc.remove(caretPos - 1, 1);
            }
            catch (BadLocationException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
        }
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    public void insertText(String text) {
        this.insertText(text, 0);
    }

    public void insertText(String text, int caretOffset) {
        JTextComponent textComponent = this.getTextComponent();
        try {
            Document doc = textComponent.getDocument();
            int caretPos = textComponent.getCaretPosition();
            doc.insertString(caretPos, text, null);
            textComponent.setCaretPosition(caretPos + caretOffset);
        }
        catch (BadLocationException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }
}

