/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.NodeUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestOrdering
extends TestCase {
    NodeValue nvInt2 = NodeValue.makeNodeInteger(2L);
    NodeValue nvInt3 = NodeValue.makeNodeInteger("3");
    NodeValue nvInt03 = NodeValue.makeNodeInteger("03");
    NodeValue nvStr3 = NodeValue.makeNodeString("3");
    NodeValue nvStr03 = NodeValue.makeNodeString("03");
    NodeValue nvInt9 = NodeValue.makeNodeInteger(9L);
    NodeValue nvPosInt9 = NodeValue.makeNode("9", XSDDatatype.XSDpositiveInteger);
    NodeValue nvInt10 = NodeValue.makeNodeInteger(10L);
    NodeValue nvDouble9 = NodeValue.makeNodeDouble(9.0);
    NodeValue nvFloat8 = NodeValue.makeNode("8.0", XSDDatatype.XSDfloat);
    NodeValue nvByte10 = NodeValue.makeNode("10", XSDDatatype.XSDbyte);
    Node nInt2 = this.nvInt2.getNode();
    Node nInt3 = this.nvInt3.getNode();
    Node nInt03 = this.nvInt03.getNode();
    Node nStr3 = this.nvStr3.getNode();
    Node nStr03 = this.nvStr03.getNode();
    Node nInt9 = this.nvInt9.getNode();
    Node nPosInt9 = this.nvPosInt9.getNode();
    Node nInt10 = this.nvInt10.getNode();
    Node nDouble9 = this.nvDouble9.getNode();
    Node nFloat8 = this.nvFloat8.getNode();
    Node nByte10 = this.nvByte10.getNode();

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(TestOrdering.class);
        testSuite.setName("TestOrdering");
        return testSuite;
    }

    public void testComp_2_3() {
        int n = NodeUtils.compareNodesByValue(this.nInt2, this.nInt3);
        TestOrdering.assertTrue((String)"2 should be value-less than 3", (-1 == n ? 1 : 0) != 0);
        int n2 = NodeUtils.compareNodesByKindTypeLexical(this.nInt2, this.nInt3);
        TestOrdering.assertTrue((String)"2 should be strict-less than 3", (-1 == n2 ? 1 : 0) != 0);
    }

    public void testComp_3_str3() {
        int n = NodeUtils.compareNodesByValue(this.nInt3, this.nStr3);
        int n2 = NodeUtils.compareNodesByKindTypeLexical(this.nInt3, this.nStr3);
        TestOrdering.assertTrue((String)"3 should be value-equals to \"3\"", (0 == n ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"3 should be strict-greater than to \"3\"", (n2 > 0 ? 1 : 0) != 0);
    }

    public void testComp_03_str3() {
        int n = NodeUtils.compareNodesByValue(this.nInt03, this.nStr3);
        int n2 = NodeUtils.compareNodesByKindTypeLexical(this.nInt03, this.nStr3);
        TestOrdering.assertTrue((String)"03 should be value-less than \"3\"", (n < 0 ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"03 should be strict-greater than to \"3\"", (n2 > 0 ? 1 : 0) != 0);
    }

    public void testComp_int_double_1() {
        int n = NodeUtils.compareNodesByValue(this.nInt10, this.nDouble9);
        int n2 = NodeUtils.compareNodesByKindTypeLexical(this.nInt10, this.nDouble9);
        TestOrdering.assertTrue((String)"Int 10 less than double 9", (n > 0 ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"Int 10 greater than double 9 in non-value compare", (n2 < 0 ? 1 : 0) != 0);
    }

    public void testComp_byte_double_1() {
        int n = NodeUtils.compareNodesByValue(this.nByte10, this.nDouble9);
        int n2 = NodeUtils.compareNodesByKindTypeLexical(this.nByte10, this.nDouble9);
        TestOrdering.assertTrue((String)"Byte 10 less than double 9", (n > 0 ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"Byte 10 greater than double 9 in non-value compare", (n2 < 0 ? 1 : 0) != 0);
    }

    public void testComp_int_float_1() {
        int n = NodeUtils.compareNodesByValue(this.nInt10, this.nFloat8);
        int n2 = NodeUtils.compareNodesByKindTypeLexical(this.nInt10, this.nFloat8);
        TestOrdering.assertTrue((String)"Int 10 less than float 8", (n > 0 ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"Int 10 greater than float 8 in non-value compare", (n2 < 0 ? 1 : 0) != 0);
    }

    public void testComp_int_posint_1() {
        int n = NodeUtils.compareNodesByValue(this.nInt9, this.nPosInt9);
        TestOrdering.assertTrue((String)"Int 9 not equals to positive integer 9", (n == 0 ? 1 : 0) != 0);
    }

    public void testComp_int_posint_2() {
        int n = NodeUtils.compareNodesByValue(this.nInt10, this.nPosInt9);
        TestOrdering.assertTrue((String)"Int 10 not greater than positive integer 9", (n > 0 ? 1 : 0) != 0);
    }
}

