/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.EditableJavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.project.OWLProject;
import java.io.File;

public class ProjectBasedJavaCodeGeneratorOptions
implements EditableJavaCodeGeneratorOptions {
    public static final String ABSTRACT_MODE = "JavaCodeAbstract";
    public static final String FACTORY_CLASS_NAME = "JavaCodeFactoryClassName";
    public static final String FILE_NAME = "JavaCodeFileName";
    public static final String PACKAGE = "JavaCodePackage";
    public static final String SET_MODE = "JavaCodeSet";
    private OWLProject project;

    public ProjectBasedJavaCodeGeneratorOptions(OWLModel owlModel) {
        this.project = owlModel.getOWLProject();
    }

    public boolean getAbstractMode() {
        Boolean b = this.project.getSettingsMap().getBoolean(ABSTRACT_MODE);
        if (b != null) {
            return b;
        }
        return false;
    }

    public String getFactoryClassName() {
        String value = this.project.getSettingsMap().getString(FACTORY_CLASS_NAME);
        if (value == null) {
            return "MyFactory";
        }
        return value;
    }

    public File getOutputFolder() {
        String fileName = this.project.getSettingsMap().getString(FILE_NAME);
        if (fileName == null) {
            return new File("");
        }
        return new File(fileName);
    }

    public String getPackage() {
        return this.project.getSettingsMap().getString(PACKAGE);
    }

    public boolean getSetMode() {
        Boolean b = this.project.getSettingsMap().getBoolean(SET_MODE);
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setAbstractMode(boolean value) {
        this.project.getSettingsMap().setBoolean(ABSTRACT_MODE, value);
    }

    public void setOutputFolder(File file) {
        if (file == null) {
            this.project.getSettingsMap().remove(FILE_NAME);
        } else {
            this.project.getSettingsMap().setString(FILE_NAME, file.getAbsolutePath());
        }
    }

    public void setFactoryClassName(String value) {
        if (value == null || value.length() == 0) {
            this.project.getSettingsMap().remove(FACTORY_CLASS_NAME);
        } else {
            this.project.getSettingsMap().setString(FACTORY_CLASS_NAME, value);
        }
    }

    public void setPackage(String value) {
        if (value == null || value.length() == 0) {
            this.project.getSettingsMap().remove(PACKAGE);
        } else {
            this.project.getSettingsMap().setString(PACKAGE, value);
        }
    }

    public void setSetMode(boolean value) {
        this.project.getSettingsMap().setBoolean(SET_MODE, value);
    }
}

