/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsLangEditor;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsValueEditor;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsValueRenderer;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class AnnotationsTable
extends TriplesTable {
    private static HashSet singleLineProperties = new HashSet();

    static {
        singleLineProperties.add("rdfs:seeAlso");
        singleLineProperties.add("rdfs:label");
    }

    public AnnotationsTable(Project project, AnnotationsTableModel model) {
        super(project, model, "annotation");
        TableColumn valueColumn = this.getColumnModel().getColumn(1);
        AnnotationsValueRenderer renderer = new AnnotationsValueRenderer();
        OWLModel owlModel = (OWLModel)project.getKnowledgeBase();
        valueColumn.setCellRenderer(renderer);
        valueColumn.setCellEditor(new AnnotationsValueEditor(owlModel, this));
        valueColumn.setPreferredWidth(800);
        TableColumn propertyColumn = this.getColumnModel().getColumn(0);
        propertyColumn.setCellRenderer(renderer);
        propertyColumn.setPreferredWidth(200);
        TableColumn langColumn = this.getColumnModel().getColumn(this.getColumnCount() - 1);
        langColumn.setCellRenderer(renderer);
        langColumn.setCellEditor(new AnnotationsLangEditor(owlModel, this));
        this.setRowHeight(new JTextField().getPreferredSize().height);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setShowGrid(true);
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    public static Collection getSingleLineProperties() {
        return Collections.unmodifiableCollection(singleLineProperties);
    }

    public static boolean isMultiLineProperty(RDFProperty property) {
        return !singleLineProperties.contains(property.getName());
    }
}

