/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.metadata.DateAnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.metadata.DateTimeAnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.metadata.TimeAnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public abstract class AbstractTriplesComponent
extends AbstractPropertyValuesComponent
implements Disposable {
    private Icon icon;
    private OWLModel owlModel;
    private static Set plugins = new HashSet();
    private TriplesTable table;
    private TriplesTableModel tableModel;
    private Action viewValueAction;

    public AbstractTriplesComponent(RDFProperty predicate) {
        this(predicate, "Triples", OWLIcons.getImageIcon("Triple"));
    }

    public AbstractTriplesComponent(RDFProperty predicate, String label, Icon icon) {
        super(predicate);
        this.icon = icon;
        AbstractTriplesComponent.addPlugin(new DateAnnotationsWidgetPlugin());
        AbstractTriplesComponent.addPlugin(new DateTimeAnnotationsWidgetPlugin());
        AbstractTriplesComponent.addPlugin(new TimeAnnotationsWidgetPlugin());
        this.owlModel = this.getOWLModel();
        this.viewValueAction = new AbstractAction("View selected value", OWLIcons.getViewIcon()){

            public void actionPerformed(ActionEvent e) {
                AbstractTriplesComponent.this.viewValue();
            }
        };
        this.viewValueAction.setEnabled(false);
        this.tableModel = this.createTableModel();
        this.table = this.createTable(this.owlModel.getProject());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractTriplesComponent.this.handleSelectionChanged();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AbstractTriplesComponent.this.handleTableDoubleClick();
                }
            }
        });
        this.addContainerListener(new ContainerAdapter(){

            public void componentRemoved(ContainerEvent e) {
                AbstractTriplesComponent.this.stopCellEditing();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        OWLLabeledComponent lc = new OWLLabeledComponent(label, scrollPane, true, true);
        if (icon != null) {
            lc.setHeaderIcon(icon);
        }
        WidgetUtilities.addViewButton(lc, this.viewValueAction);
        this.addButtons(lc);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
    }

    protected abstract void addButtons(LabeledComponent var1);

    public static void addPlugin(AnnotationsWidgetPlugin plugin) {
        for (AnnotationsWidgetPlugin p : plugins) {
            if (p.getClass() != plugin.getClass()) continue;
            return;
        }
        plugins.add(plugin);
    }

    protected TriplesTable createTable(Project project) {
        return new TriplesTable(project, this.tableModel, "property");
    }

    protected TriplesTableModel createTableModel() {
        return new TriplesTableModel(null);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public TriplesTable getTable() {
        return this.table;
    }

    public TriplesTableModel getTableModel() {
        return this.tableModel;
    }

    protected void handleSelectionChanged() {
        this.updateActions();
    }

    private void handleTableDoubleClick() {
        int selIndex = this.table.getSelectedRow();
        if (selIndex >= 0 && selIndex < this.tableModel.getRowCount() && this.viewValueAction.isEnabled()) {
            this.viewValue();
        }
    }

    public static Iterator plugins() {
        return plugins.iterator();
    }

    public static void removePlugin(AnnotationsWidgetPlugin plugin) {
        plugins.remove(plugin);
    }

    public void setSubject(RDFResource subject) {
        super.setSubject(subject);
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.setSubject(subject);
    }

    protected void updateActions() {
        RDFProperty property;
        int row = this.table.getSelectedRow();
        RDFProperty rDFProperty = property = row >= 0 ? this.tableModel.getPredicate(row) : null;
        if (row >= 0) {
            Object value = this.tableModel.getValue(row);
            this.viewValueAction.setEnabled(true);
        } else {
            this.viewValueAction.setEnabled(false);
        }
    }

    public void valuesChanged() {
        this.tableModel.updateValues();
    }

    private void viewValue() {
        int row = this.table.getSelectedRow();
        this.viewValue(row);
    }

    private void viewValue(int row) {
        Object value = this.tableModel.getValue(row);
        if (value instanceof RDFResource) {
            ProtegeUI.show((RDFResource)value);
        } else {
            RDFProperty property = this.tableModel.getPredicate(row);
            RDFResource subject = this.tableModel.getSubject();
            PropertyValueEditor editor = PropertyValueEditorManager.getEditor(subject, property, value);
            if (editor != null) {
                Object newValue = editor.editValue(this, subject, property, value);
                if (newValue != null) {
                    this.tableModel.setValue(newValue, row);
                    return;
                }
                return;
            }
            for (AnnotationsWidgetPlugin plugin : plugins) {
                if (!plugin.canEdit(subject, property, value)) continue;
                Object newValue = plugin.editValue(null, subject, property, value);
                if (newValue != null) {
                    this.tableModel.setValue(newValue, row);
                }
                return;
            }
            String name = property.getBrowserText();
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
            JTextArea textArea = new JTextArea(value.toString());
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEnabled(this.tableModel.isCellEditable(row, 1));
            JScrollPane comp = new JScrollPane(textArea);
            LabeledComponent lc = new LabeledComponent(name, (Component)comp);
            lc.setPreferredSize(new Dimension(400, 400));
            int r = ProtegeUI.getModalDialogFactory().showDialog(this, (Component)lc, "Edit annotation", 11);
            if (r == 1) {
                String newValue = textArea.getText();
                this.tableModel.setValue(newValue, row);
            }
        }
    }

    private boolean stopCellEditing() {
        try {
            int column = this.table.getEditingColumn();
            if (column > -1) {
                TableCellEditor cellEditor = this.table.getColumnModel().getColumn(column).getCellEditor();
                if (cellEditor == null) {
                    cellEditor = this.table.getDefaultEditor(this.table.getColumnClass(column));
                }
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

