/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.navigation;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistorySelectable;
import edu.stanford.smi.protegex.owl.ui.navigation.ProgrammaticSelectionEvent;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;

public class NavigationHistoryManager
extends DefaultListModel
implements ComboBoxModel,
Disposable {
    private ResourceSelectionAction backAction = new ResourceSelectionAction("Back", OWLIcons.getNavigateBackIcon()){

        public void actionPerformed(ActionEvent e) {
            NavigationHistoryManager.this.back();
        }

        public void resourceSelected(RDFResource resource) {
            while (!resource.equals(NavigationHistoryManager.this.getResource(NavigationHistoryManager.this.index))) {
                NavigationHistoryManager navigationHistoryManager = NavigationHistoryManager.this;
                navigationHistoryManager.index = navigationHistoryManager.index - 1;
            }
            NavigationHistoryManager.this.setSelectedResourceByCurrentIndex();
            NavigationHistoryManager.this.updateActionStatus();
        }

        public Collection getSelectableResources() {
            HashSet<RDFResource> set = new HashSet<RDFResource>();
            int i = NavigationHistoryManager.this.index - 1;
            while (i >= 0) {
                set.add(NavigationHistoryManager.this.getResource(i));
                --i;
            }
            ArrayList subList = new ArrayList(set);
            Collections.sort(subList);
            return subList;
        }

        public RDFResource pickResource() {
            return null;
        }
    };
    private ModelListener deleteListener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            if (NavigationHistoryManager.this.resourcesSet.contains(cls)) {
                NavigationHistoryManager.this.removeResource(cls);
            }
        }

        public void individualDeleted(RDFResource resource) {
            if (NavigationHistoryManager.this.resourcesSet.contains(resource)) {
                NavigationHistoryManager.this.removeResource(resource);
            }
        }

        public void propertyDeleted(RDFProperty property) {
            if (NavigationHistoryManager.this.resourcesSet.contains(property)) {
                NavigationHistoryManager.this.removeResource(property);
            }
        }
    };
    private ResourceSelectionAction forwardAction = new ResourceSelectionAction("Forward", OWLIcons.getNavigateForwardIcon()){

        public void actionPerformed(ActionEvent e) {
            NavigationHistoryManager.this.forward();
        }

        public void resourceSelected(RDFResource resource) {
            while (!resource.equals(NavigationHistoryManager.this.getResource(NavigationHistoryManager.this.index))) {
                NavigationHistoryManager navigationHistoryManager = NavigationHistoryManager.this;
                navigationHistoryManager.index = navigationHistoryManager.index + 1;
            }
            NavigationHistoryManager.this.setSelectedResourceByCurrentIndex();
            NavigationHistoryManager.this.updateActionStatus();
        }

        public Collection getSelectableResources() {
            HashSet<RDFResource> set = new HashSet<RDFResource>();
            int i = NavigationHistoryManager.this.index;
            while (i < NavigationHistoryManager.this.getSize()) {
                set.add(NavigationHistoryManager.this.getResource(i));
                ++i;
            }
            ArrayList subList = new ArrayList(set);
            Collections.sort(subList);
            return subList;
        }

        public RDFResource pickResource() {
            return null;
        }
    };
    private int index = -1;
    private Set listeners = new HashSet();
    private NavigationHistorySelectable navigationHistorySelectable;
    private OWLModel owlModel;
    private Set resourcesSet = new HashSet();
    private SelectionListener selectionListener = new SelectionListener(){

        public void selectionChanged(SelectionEvent event) {
            if (!(event instanceof ProgrammaticSelectionEvent)) {
                NavigationHistoryManager.this.handleSelectionChanged();
            }
        }
    };

    public NavigationHistoryManager(NavigationHistorySelectable nhc, OWLModel owlModel) {
        this.navigationHistorySelectable = nhc;
        this.owlModel = owlModel;
        this.owlModel.addModelListener(this.deleteListener);
        this.updateActionStatus();
        this.navigationHistorySelectable.addSelectionListener(this.selectionListener);
    }

    public void add(RDFResource resource) {
        ++this.index;
        this.add(this.index, resource);
        while (this.getSize() > this.index + 1) {
            this.removeResourceByIndex(this.index + 1);
        }
        if (!this.resourcesSet.contains(resource)) {
            this.resourcesSet.add(resource);
        }
        this.updateActionStatus();
    }

    public void addIndexListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void back() {
        if (this.index > 0) {
            --this.index;
            this.setSelectedResourceByCurrentIndex();
            this.updateActionStatus();
        }
    }

    public void dispose() {
        this.navigationHistorySelectable.removeSelectionListener(this.selectionListener);
        this.owlModel.removeModelListener(this.deleteListener);
    }

    public void forward() {
        if (this.index < this.getSize() - 1) {
            ++this.index;
            this.setSelectedResourceByCurrentIndex();
            this.updateActionStatus();
        }
    }

    public ResourceSelectionAction getBackAction() {
        return this.backAction;
    }

    public RDFResource getResource(int index) {
        return (RDFResource)this.getElementAt(index);
    }

    public ResourceSelectionAction getForwardAction() {
        return this.forwardAction;
    }

    public int getSelectedIndex() {
        return this.index;
    }

    private void handleSelectionChanged() {
        Object object;
        Collection selection = this.navigationHistorySelectable.getSelection();
        if (selection.size() == 1 && (object = selection.iterator().next()) instanceof RDFResource) {
            RDFResource resource = (RDFResource)object;
            this.add(resource);
            this.updateActionStatus();
        }
    }

    private void removeResource(RDFResource resource) {
        RDFResource r;
        this.resourcesSet.remove(resource);
        int i = this.getSize() - 1;
        while (i > this.index) {
            r = this.getResource(i);
            if (r.equals(resource)) {
                this.remove(i);
            }
            --i;
        }
        i = this.index;
        while (i >= 0) {
            r = this.getResource(i);
            if (r.equals(resource)) {
                this.remove(i);
                --this.index;
            }
            --i;
        }
    }

    private void removeResourceByIndex(int index) {
        RDFResource resource = this.getResource(index);
        this.remove(index);
        this.resourcesSet.remove(resource);
        if (this.contains(resource)) {
            this.resourcesSet.add(resource);
        }
    }

    private void setSelectedResourceByCurrentIndex() {
        RDFResource resource = this.getResource(this.index);
        this.navigationHistorySelectable.navigateToResource(resource);
    }

    private void updateActionStatus() {
        this.backAction.setEnabled(this.index > 0);
        this.forwardAction.setEnabled(this.index < this.getSize() - 1);
        for (ActionListener listener : new ArrayList(this.listeners)) {
            listener.actionPerformed(null);
        }
    }

    public Object getSelectedItem() {
        if (this.index >= 0 && this.index < this.getSize()) {
            return this.getResource(this.index);
        }
        return null;
    }

    public void setSelectedItem(Object anItem) {
        if (!anItem.equals(this.getResource(this.index))) {
            this.index = 0;
            int i = this.getSize() - 1;
            while (i >= 0) {
                RDFResource frame = this.getResource(i);
                if (frame.equals(anItem)) {
                    this.index = i;
                    this.setSelectedResourceByCurrentIndex();
                    break;
                }
                --i;
            }
            this.updateActionStatus();
        }
    }
}

