/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FindUsage {
    public static Collection getItems(RDFResource searchInstance) {
        OWLModel owlModel = searchInstance.getOWLModel();
        Set ignoreProperties = FindUsage.getIgnoreProperties(owlModel);
        Set anons = searchInstance.getReferringAnonymousClasses();
        ArrayList<FindUsageTableItem> items = new ArrayList<FindUsageTableItem>();
        Slot superClsesSlot = owlModel.getSlot(":DIRECT-SUPERCLASSES");
        RDFProperty disjointWithProperty = owlModel.getRDFProperty("owl:disjointWith");
        Slot rangeSlot = owlModel.getSlot(":SLOT-VALUE-TYPE");
        if (!owlModel.getOWLThingClass().equals(searchInstance)) {
            for (Reference ref : owlModel.getReferences(searchInstance, 10000)) {
                if (disjointWithProperty.equals(ref.getSlot())) {
                    items.add(new FindUsageTableItem(2, (RDFResource)ref.getFrame(), searchInstance));
                    continue;
                }
                if (!rangeSlot.equals(ref.getSlot())) continue;
                items.add(new FindUsageTableItem(3, (RDFResource)ref.getFrame(), searchInstance));
            }
        }
        HashSet<OWLAnonymousClass> used = new HashSet<OWLAnonymousClass>();
        for (OWLAnonymousClass cls : anons) {
            OWLAnonymousClass rootCls = cls.getExpressionRoot();
            if (searchInstance instanceof OWLNamedClass && ((OWLNamedClass)searchInstance).getEquivalentClasses().contains(rootCls) || used.contains(rootCls)) continue;
            used.add(rootCls);
            Collection refs = owlModel.getReferences(rootCls, 100000);
            for (Reference reference : refs) {
                if (!(reference.getFrame() instanceof RDFResource)) continue;
                RDFResource host = (RDFResource)reference.getFrame();
                if (superClsesSlot.equals(reference.getSlot())) {
                    if (host instanceof OWLNamedClass && ((OWLNamedClass)host).getPureSuperclasses().contains(rootCls)) {
                        items.add(new FindUsageTableItem(0, host, rootCls));
                        continue;
                    }
                    items.add(new FindUsageTableItem(1, host, rootCls));
                    continue;
                }
                if (disjointWithProperty.equals(reference.getSlot())) {
                    items.add(new FindUsageTableItem(2, host, rootCls));
                    continue;
                }
                if (!rangeSlot.equals(reference.getSlot())) continue;
                items.add(new FindUsageTableItem(3, host, rootCls));
            }
        }
        Collection refs = owlModel.getReferences(searchInstance, 1000);
        for (Reference ref : refs) {
            RDFResource host;
            RDFProperty property;
            if (!(ref.getSlot() instanceof RDFProperty) || !(ref.getFrame() instanceof RDFResource) || ignoreProperties.contains(property = (RDFProperty)ref.getSlot()) || (host = (RDFResource)ref.getFrame()).isAnonymous()) continue;
            items.add(new FindUsageTableItem(4, host, property));
        }
        return items;
    }

    private static Set getIgnoreProperties(OWLModel owlModel) {
        HashSet<RDFProperty> result = new HashSet<RDFProperty>();
        result.add(owlModel.getRDFTypeProperty());
        result.add(owlModel.getRDFSRangeProperty());
        result.add(owlModel.getRDFSDomainProperty());
        result.add(owlModel.getOWLDisjointWithProperty());
        result.add(owlModel.getRDFSSubClassOfProperty());
        result.add(owlModel.getOWLEquivalentClassProperty());
        return result;
    }
}

