/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SearchNamedClassPanel
extends JPanel {
    private OWLModel owlModel;
    private RDFSNamedClass rootClass;
    private JList propertyList;
    private JTextField textField;

    public SearchNamedClassPanel(RDFSNamedClass rootClass) {
        this.owlModel = rootClass.getOWLModel();
        this.rootClass = rootClass;
        ArrayList<RDFProperty> properties = new ArrayList<RDFProperty>();
        for (RDFProperty slot : this.owlModel.getRDFProperties()) {
            if (!(slot instanceof OWLDatatypeProperty) || slot.getValueType() != ValueType.STRING) continue;
            properties.add(slot);
        }
        Frame[] frames = properties.toArray(new Frame[0]);
        Arrays.sort(frames, new FrameComparator());
        this.propertyList = new JList<Frame>(frames);
        this.propertyList.setCellRenderer(new ResourceRenderer());
        this.propertyList.setSelectedIndex(0);
        this.textField = new JTextField();
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", (Component)new LabeledComponent("Available Properties", new JScrollPane(this.propertyList)));
        this.add("South", (Component)new LabeledComponent("Search Pattern", (Component)this.textField));
    }

    public List getResult() {
        RDFProperty property = (RDFProperty)this.propertyList.getSelectedValue();
        String matchString = this.textField.getText();
        Collection matches = this.owlModel.getMatchingResources(property, matchString, -1);
        ArrayList<Frame> result = new ArrayList<Frame>();
        for (Frame frame : matches) {
            if (!(frame instanceof RDFSNamedClass) || !((RDFSNamedClass)frame).isSubclassOf(this.rootClass)) continue;
            result.add(frame);
        }
        return result;
    }

    public static List showDialog(Component parent, RDFSNamedClass rootClass) {
        SearchNamedClassPanel panel = new SearchNamedClassPanel(rootClass);
        int result = ProtegeUI.getModalDialogFactory().showDialog(parent, panel, "Search subclasses of " + rootClass.getBrowserText(), 11, null, true);
        if (result == 1) {
            return panel.getResult();
        }
        return null;
    }
}

