/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.test.Rational;

class RationalType
extends BaseDatatype {
    public static final String theTypeURI = "urn:x-hp-dt:rational";
    public static final RDFDatatype theRationalType = new RationalType();

    private RationalType() {
        super(theTypeURI);
    }

    public String unparse(Object object) {
        Rational rational = (Rational)object;
        return Integer.toString(rational.getNumerator()) + "/" + rational.getDenominator();
    }

    public Object parse(String string) throws DatatypeFormatException {
        int n = string.indexOf("/");
        if (n == -1) {
            throw new DatatypeFormatException(string, theRationalType, "");
        }
        try {
            int n2 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1));
            return new Rational(n2, n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DatatypeFormatException(string, theRationalType, "");
        }
    }

    public boolean isEqual(LiteralLabel literalLabel, LiteralLabel literalLabel2) {
        return literalLabel.getDatatype() == literalLabel2.getDatatype() && literalLabel.getValue().equals(literalLabel2.getValue());
    }
}

