/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

/**
 * This class represents a service instance found during search.
 * 
 * @author tilmann
 */
public class ServiceInstanceInfo extends ServiceInstanceParameter {

	private String wsdlLocation;
	
	private String serviceName;
	
	private double relevance;

	/**
	 * @return the relevance
	 */
	public double getRelevance() {
		return relevance;
	}

	/**
	 * @param relevance the relevance to set
	 */
	public void setRelevance(double relevance) {
		this.relevance = relevance;
	}

	/**
	 * @return Returns the wsdlLocation.
	 */
	public String getWsdlLocation() {
		return wsdlLocation;
	}

	/**
	 * @param wsdlLocation
	 *            The wsdlLocation to set.
	 */
	public void setWsdlLocation(String wsdlLocation) {
		this.wsdlLocation = wsdlLocation;
	}

	@Override
	public String toString() {
		return super.toString() + "WsdlLocation: " + wsdlLocation + "\n";
	}

	@Override
	public ServiceInstanceInfo clone() {
		return (ServiceInstanceInfo) super.clone();
	}

	/**
	 * @return the serviceName
	 */
	public String getServiceName() {
		return serviceName;
	}

	/**
	 * @param serviceName the serviceName to set
	 */
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

}
