/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.TransferableCollection;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class TreeTarget
implements DropTargetListener {
    private int _dropSelectionRow;
    private Object _dropSelectionArea;
    private boolean _allowsBetweenDrops;
    private static boolean lastDropSucceeded;

    protected TreeTarget(boolean bl) {
        this._allowsBetweenDrops = bl;
    }

    private void clearDropSelection(JTree jTree) {
        jTree.putClientProperty(DefaultRenderer.DROP_TARGET, null);
        jTree.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, null);
        this._dropSelectionRow = -1;
        this._dropSelectionArea = null;
        jTree.repaint();
    }

    public abstract boolean doDrop(JTree var1, Object var2, int var3, Object var4);

    protected boolean doDrop(JTree jTree, Collection collection, int n, Object object) {
        boolean bl = true;
        for (Object e : collection) {
            bl = this.doDrop(jTree, e, this._dropSelectionRow, this._dropSelectionArea);
        }
        return bl;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.clearDropSelection(TreeTarget.getTree(dropTargetEvent));
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.setDropSelection(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        DataFlavor dataFlavor = TransferableCollection.getCollectionFlavor();
        JTree jTree = TreeTarget.getTree(dropTargetDropEvent);
        if (dropTargetDropEvent.isDataFlavorSupported(dataFlavor)) {
            try {
                int n = dropTargetDropEvent.getDropAction();
                this.setDropSelection(TreeTarget.getTree(dropTargetDropEvent), dropTargetDropEvent.getLocation());
                if (this._dropSelectionRow != -1) {
                    Collection collection = (Collection)dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
                    bl = this.doDrop(jTree, collection, this._dropSelectionRow, this._dropSelectionArea);
                }
                dropTargetDropEvent.acceptDrop(n);
            }
            catch (Exception exception) {
                Log.getLogger().warning(Log.toString(exception));
            }
        } else {
            dropTargetDropEvent.rejectDrop();
            Log.getLogger().warning("unsupported flavor: " + dropTargetDropEvent);
        }
        lastDropSucceeded = bl;
        dropTargetDropEvent.dropComplete(bl);
        this.clearDropSelection(jTree);
    }

    public static boolean getLastDropSucceeded() {
        return lastDropSucceeded;
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private static JTree getTree(DropTargetDragEvent dropTargetDragEvent) {
        return (JTree)dropTargetDragEvent.getDropTargetContext().getComponent();
    }

    private static JTree getTree(DropTargetEvent dropTargetEvent) {
        return (JTree)dropTargetEvent.getDropTargetContext().getComponent();
    }

    private void setDropSelection(DropTargetDragEvent dropTargetDragEvent) {
        this.setDropSelection(TreeTarget.getTree(dropTargetDragEvent), dropTargetDragEvent.getLocation());
    }

    private void setDropSelection(JTree jTree, Point point) {
        this._dropSelectionRow = jTree.getRowForLocation(point.x, point.y);
        if (this._dropSelectionRow == -1) {
            this.clearDropSelection(jTree);
        } else {
            Serializable serializable;
            if (this._allowsBetweenDrops) {
                serializable = jTree.getRowBounds(this._dropSelectionRow);
                if (point.y < ((Rectangle)serializable).y + ((Rectangle)serializable).height / 4) {
                    if (this._dropSelectionRow == 0) {
                        this._dropSelectionArea = DefaultRenderer.DROP_TARGET_AREA_ABOVE;
                    } else {
                        --this._dropSelectionRow;
                        this._dropSelectionArea = DefaultRenderer.DROP_TARGET_AREA_BELOW;
                    }
                } else {
                    this._dropSelectionArea = point.y < ((Rectangle)serializable).y + 3 * ((Rectangle)serializable).height / 4 ? DefaultRenderer.DROP_TARGET_AREA_ON : DefaultRenderer.DROP_TARGET_AREA_BELOW;
                }
            } else {
                this._dropSelectionArea = DefaultRenderer.DROP_TARGET_AREA_ON;
            }
            serializable = jTree.getPathForRow(this._dropSelectionRow);
            LazyTreeNode lazyTreeNode = (LazyTreeNode)((TreePath)serializable).getLastPathComponent();
            jTree.putClientProperty(DefaultRenderer.DROP_TARGET, lazyTreeNode);
            jTree.putClientProperty(DefaultRenderer.DROP_TARGET_AREA, this._dropSelectionArea);
            jTree.repaint();
            Thread.yield();
        }
    }
}

