/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DefaultRDFIndividualTestCase
extends AbstractJenaTestCase {
    public void testGetRDFProperties() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFIndividual individual = cls.createRDFIndividual("Individual");
        DefaultRDFIndividualTestCase.assertSize(1, individual.getRDFProperties());
        DefaultRDFIndividualTestCase.assertContains((Object)this.owlModel.getRDFTypeProperty(), individual.getRDFProperties());
    }

    public void testGetHasValuesOnTypes() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Subclass", superclass);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        RDFResource individual = subclass.createInstance("Instance");
        DefaultRDFIndividualTestCase.assertSize(0, individual.getHasValuesOnTypes(property));
        superclass.addSuperclass(this.owlModel.createOWLHasValue(property, this.owlThing));
        DefaultRDFIndividualTestCase.assertSize(1, individual.getHasValuesOnTypes(property));
        DefaultRDFIndividualTestCase.assertContains((Object)this.owlThing, individual.getHasValuesOnTypes(property));
    }

    public void testPropertyValue() {
        RDFSNamedClass c = this.owlModel.createRDFSNamedClass("Person");
        RDFProperty childrenProperty = this.owlModel.createRDFProperty("children");
        RDFProperty sonsProperty = this.owlModel.createRDFProperty("sons");
        sonsProperty.addSuperproperty(childrenProperty);
        RDFIndividual individual = (RDFIndividual)c.createInstance("instance");
        RDFIndividual daughter = (RDFIndividual)c.createInstance("daughter");
        RDFIndividual son = (RDFIndividual)c.createInstance("son");
        individual.addPropertyValue(childrenProperty, daughter);
        individual.addPropertyValue(sonsProperty, son);
        DefaultRDFIndividualTestCase.assertEquals((int)1, (int)individual.getPropertyValueCount(childrenProperty));
        DefaultRDFIndividualTestCase.assertEquals((int)1, (int)individual.getPropertyValueCount(sonsProperty));
        DefaultRDFIndividualTestCase.assertSize(1, individual.getPropertyValues(childrenProperty, false));
        DefaultRDFIndividualTestCase.assertEquals((Object)daughter, (Object)individual.getPropertyValue(childrenProperty, false));
        DefaultRDFIndividualTestCase.assertSize(1, individual.getPropertyValues(sonsProperty, false));
        DefaultRDFIndividualTestCase.assertEquals((Object)son, (Object)individual.getPropertyValue(sonsProperty, false));
        DefaultRDFIndividualTestCase.assertSize(2, individual.getPropertyValues(childrenProperty, true));
        DefaultRDFIndividualTestCase.assertContains((Object)son, individual.getPropertyValues(childrenProperty, true));
        DefaultRDFIndividualTestCase.assertContains((Object)daughter, individual.getPropertyValues(childrenProperty, true));
    }
}

