/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.ReturnBoolean;
import com.hp.hpl.jena.query.junit.TestExpr;

public class TestExprBoolean
extends TestExpr {
    boolean rightAnswer;

    public TestExprBoolean(String string, boolean bl) {
        this(string, bl, null, null, 100);
    }

    public TestExprBoolean(String string, int n) {
        this(string, true, null, null, n);
    }

    public TestExprBoolean(String string, boolean bl, int n) {
        this(string, bl, null, null, n);
    }

    public TestExprBoolean(String string, boolean bl, Binding binding) {
        this(string, bl, null, binding, 100);
    }

    public TestExprBoolean(String string, boolean bl, Binding binding, int n) {
        this(string, bl, null, binding, n);
    }

    public TestExprBoolean(String string, boolean bl, Query query2, Binding binding, int n) {
        super("Boolean test : " + string, string, query2, binding, n);
        this.rightAnswer = bl;
    }

    void checkExpr(Expr expr) {
        if (this.failureMode == 200) {
            return;
        }
        TestExprBoolean.assertTrue((String)("Expression is not ExprBoolean: " + expr.getClass().getName()), (expr instanceof ReturnBoolean || expr instanceof NodeValue && ((NodeValue)expr).isBoolean() ? 1 : 0) != 0);
    }

    void checkValue(Expr expr, NodeValue nodeValue) {
        if (!this.evalCorrect()) {
            TestExprBoolean.fail((String)("Parse " + this.exprString + " ==> " + expr + " :: Expected eval exception but got: " + nodeValue));
        }
        boolean bl = nodeValue.getBoolean();
        TestExprBoolean.assertEquals((String)("Parse " + this.exprString + " ==> " + expr + " "), (boolean)this.rightAnswer, (boolean)bl);
    }

    void checkException(Expr expr, Exception exception) {
        if (!this.failureCorrect()) {
            TestExprBoolean.fail((String)(this.exprString + " => " + expr + " :: Exception: " + exception));
        }
    }
}

