/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.jena.OWLCreateProjectPlugin;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchClassDefinitionResourceDisplayPlugin;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableClassDefinitionWidget;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OWLViewWizardPage
extends WizardPage {
    private Map button2Type;
    private OWLCreateProjectPlugin plugin;
    private static final String HELP_TEXT = "<P>On this page you can specify the initial user interface settings for the OWL Classes Tab. The preferred user interface depends on the language features and experience. You can change these settings later at any time, at the bottom of the tab.</P>";

    public OWLViewWizardPage(Wizard wizard, OWLCreateProjectPlugin plugin) {
        super("View Settings", wizard);
        this.plugin = plugin;
        this.button2Type = new HashMap();
        boolean selected = false;
        JPanel viewPanel = new JPanel();
        String defaultClassView = SwitchClassDefinitionResourceDisplayPlugin.getDefaultClassView();
        ButtonGroup group = new ButtonGroup();
        Iterator types = SwitchableClassDefinitionWidget.listSwitchableTypes();
        while (types.hasNext()) {
            SwitchableType type = (SwitchableType)types.next();
            JRadioButton button = new JRadioButton(type.getButtonText());
            this.button2Type.put(button, type);
            String name = type.getClass().getName();
            if (name.equals(defaultClassView)) {
                button.setSelected(true);
                plugin.setDefaultClassView(type.getClass());
                selected = true;
            }
            group.add(button);
            viewPanel.add(button);
        }
        if (!selected) {
            JRadioButton first = (JRadioButton)viewPanel.getComponent(0);
            first.setSelected(true);
        }
        viewPanel.setLayout(new GridLayout(this.button2Type.size(), 1));
        viewPanel.setBorder(BorderFactory.createTitledBorder("OWL Classes View"));
        this.setLayout(new BorderLayout());
        this.add("North", viewPanel);
        this.add("South", OWLUI.createHelpPanel(HELP_TEXT, "Do you prefer a less complex user interface?", 160));
    }

    public void onFinish() {
        for (JRadioButton button : this.button2Type.keySet()) {
            if (!button.isSelected()) continue;
            SwitchableType type = (SwitchableType)this.button2Type.get(button);
            this.plugin.setDefaultClassView(type.getClass());
        }
    }
}

