/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ProjectEventDispatcher;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.event.WidgetAdapter;
import edu.stanford.smi.protege.event.WidgetEvent;
import edu.stanford.smi.protege.model.BackwardsCompatibilityProjectFixups;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.FrameCountsImpl;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.PropertyMapUtil;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Tree;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.DefaultWidgetMapper;
import edu.stanford.smi.protege.widget.UglyClsWidget;
import edu.stanford.smi.protege.widget.Widget;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private static Logger log = Log.getLogger(Project.class);
    private static final String CLASS_PROJECT = "Project";
    private static final String SLOT_DEFAULT_INSTANCE_WIDGET_CLASS_NAME = "default_instance_widget_class_name";
    private static final String SLOT_CUSTOMIZED_INSTANCE_WIDGETS = "customized_instance_widgets";
    private static final String SLOT_BROWSER_SLOTS = "browser_slot_names";
    private static final String SLOT_TABS = "tabs";
    private static final String SLOT_INCLUDED_PROJECTS = "included_projects";
    private static final String SLOT_ALL_KNOWLEDGE_BASE_FACTORY_NAMES = "all_knowledge_base_factory_names";
    private static final String SLOT_SOURCES = "sources";
    private static final String SLOT_JAVA_PACKAGES = "java_packages";
    private static final String SLOT_HIDDEN_FRAMES = "hidden_classes";
    private static final String SLOT_JOURNALING_ENABLED = "journaling_enabled";
    private static final String SLOT_DEFAULT_CLS_METACLASS = "default_cls_metaclass";
    private static final String SLOT_DEFAULT_SLOT_METACLASS = "default_slot_metaclass";
    private static final String SLOT_DEFAULT_FACET_METACLASS = "default_facet_metaclass";
    private static final String SLOT_NEXT_FRAME_NUMBER = "next_frame_number";
    private static final String SLOT_IS_READONLY = "is_readonly";
    private static final String SLOT_PRETTY_PRINT_SLOT_WIDGET_LABELS = "pretty_print_slot_widget_labels";
    private static final String CLASS_OPTIONS = "Options";
    private static final String SLOT_OPTIONS = "options";
    private static final String SLOT_DISPLAY_HIDDEN_FRAMES = "display_hidden_classes";
    private static final String SLOT_DISPLAY_ABSTRACT_CLASS_ICON = "display_abstract_class_icon";
    private static final String SLOT_DISPLAY_MULTI_PARENT_CLASS_ICON = "display_multi_parent_class_icon";
    private static final String SLOT_DISPLAY_REMOVE_CONFIRMATION_DIALOG = "confirm_on_remove";
    private static final String SLOT_UPDATE_MODIFICATION_SLOTS = "update_modification_slots";
    private static final String SLOT_TABBED_INSTANCE_FORM_LAYOUT = "tabbed_instance_form_layout";
    private static final String CLASS_MAP = "Map";
    private static final String SLOT_PROPERTY_MAP = "property_map";
    private static final int WINDOW_OFFSET_PIXELS = 25;
    private URI _uri;
    private URI _loadingProjectURI;
    private KnowledgeBase _projectKB;
    private Instance _projectInstance;
    private KnowledgeBase _domainKB;
    private String _defaultClsWidgetClassName;
    private Map _activeClsWidgetDescriptors = new HashMap();
    private Map _cachedDesignTimeClsWidgets = new HashMap();
    private Map _frames = new HashMap();
    private Map _objects = new HashMap();
    private WidgetMapper _widgetMapper;
    private Tree projectURITree = new Tree();
    private URI activeRootURI;
    private Point _lastLocation;
    private ListenerCollection _listeners = new ListenerList(new ProjectEventDispatcher());
    private Boolean _displayHiddenClasses;
    private Boolean _displayAbstractClassIcon;
    private Boolean _displayMultiParentClassIcon;
    private Boolean _displayConfirmationOnRemove;
    private Boolean _isReadonly;
    private Boolean _updateModificationSlots;
    private Boolean prettyPrintSlotWidgetLabels;
    private Map _includedBrowserSlotPatterns = new HashMap();
    private Map _directBrowserSlotPatterns = new HashMap();
    private Set _hiddenFrames = new HashSet();
    private Set _includedHiddenFrames = new HashSet();
    private boolean _hasChanged;
    private Collection _tabWidgetDescriptors;
    private Map _clientInformation = new HashMap();
    private FrameCountsImpl _frameCounts = new FrameCountsImpl();
    private boolean isMultiUserServer;
    private Class _instanceDisplayClass;
    private WindowListener _closeListener = new WindowAdapter(){

        public void windowClosing(WindowEvent windowEvent) {
            JFrame jFrame = (JFrame)windowEvent.getWindow();
            jFrame.setVisible(false);
            Object v = Project.this._objects.remove(jFrame);
            Project.this._frames.remove(v);
            Project.this._objects.remove(jFrame);
            ComponentUtilities.dispose(jFrame);
            Application.repaint();
        }
    };
    private KnowledgeBaseListener _knowledgeBaseListener = new KnowledgeBaseAdapter(){

        public void clsDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("clsDeleted for project " + this + " event = " + knowledgeBaseEvent);
            }
            Cls cls = knowledgeBaseEvent.getCls();
            Project.this._activeClsWidgetDescriptors.remove(cls);
            ClsWidget clsWidget = (ClsWidget)Project.this._cachedDesignTimeClsWidgets.remove(cls);
            if (clsWidget != null) {
                ComponentUtilities.dispose((Component)((Object)clsWidget));
            }
            Project.this._directBrowserSlotPatterns.remove(cls);
            Project.this.removeDisplay(cls);
            Project.this._hiddenFrames.remove(cls);
        }

        public void frameNameChanged(KnowledgeBaseEvent knowledgeBaseEvent) {
            Frame frame = knowledgeBaseEvent.getFrame();
            WidgetDescriptor widgetDescriptor = (WidgetDescriptor)Project.this._activeClsWidgetDescriptors.get(frame);
            if (widgetDescriptor != null) {
                widgetDescriptor.setName(frame.getName());
            }
        }

        public void facetDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
            Frame frame = knowledgeBaseEvent.getFrame();
            Project.this.removeDisplay(frame);
            Project.this._hiddenFrames.remove(frame);
        }

        public void slotDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
            Slot slot = (Slot)knowledgeBaseEvent.getFrame();
            Project.this.removeDisplay(slot);
            Iterator iterator = Project.this._directBrowserSlotPatterns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                BrowserSlotPattern browserSlotPattern = (BrowserSlotPattern)entry.getValue();
                if (!browserSlotPattern.contains(slot)) continue;
                iterator.remove();
            }
            Project.this._hiddenFrames.remove(slot);
        }

        public void instanceDeleted(KnowledgeBaseEvent knowledgeBaseEvent) {
            super.instanceDeleted(knowledgeBaseEvent);
            Frame frame = knowledgeBaseEvent.getFrame();
            Project.this.removeDisplay(frame);
            Project.this._hiddenFrames.remove(frame);
        }
    };

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    protected Project(URI uRI, KnowledgeBaseFactory knowledgeBaseFactory, Collection collection, boolean bl) {
        this(uRI, knowledgeBaseFactory, collection, bl, false);
    }

    protected Project(URI uRI, KnowledgeBaseFactory knowledgeBaseFactory, Collection collection, boolean bl, boolean bl2) {
        this.isMultiUserServer = bl2;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Project " + uRI + " multiserver = " + bl2);
        }
        this.setProjectURI(uRI);
        this._projectKB = Project.loadProjectKB(uRI, knowledgeBaseFactory, collection);
        if (this._projectKB != null) {
            this._projectInstance = Project.getProjectInstance(this._projectKB);
        }
        if (this._projectInstance != null && bl) {
            boolean bl3 = uRI != null;
            this.createDomainKnowledgeBase(knowledgeBaseFactory, collection, bl3);
        }
        if (this._projectKB != null && collection.isEmpty()) {
            this.setupJournaling();
        }
        this.updateKBNames();
    }

    public Project(String string, Collection collection) {
        this(URIUtilities.createURI(string), collection);
    }

    private Project(URI uRI, Collection collection) {
        this(uRI, null, collection, true);
    }

    public void addJavaPackageName(String string) {
        this.addProjectSlotValue(SLOT_JAVA_PACKAGES, string);
        this._domainKB.addJavaLoadPackage(string);
    }

    public void addProjectListener(ProjectListener projectListener) {
        this._listeners.add(this, projectListener);
    }

    private void addProjectSlotValue(String string, Object object) {
        ModelUtilities.addOwnSlotValue(this._projectInstance, string, object);
    }

    public void clearCachedWidgets() {
        for (ClsWidget clsWidget : this._cachedDesignTimeClsWidgets.values()) {
            ComponentUtilities.dispose((Component)((Object)clsWidget));
        }
        this._cachedDesignTimeClsWidgets.clear();
    }

    public static Project createBuildProject(KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
        return new Project(null, knowledgeBaseFactory, collection, false);
    }

    public static Project createBuildProject(KnowledgeBase knowledgeBase, Collection collection) {
        Project project = new Project(null, null, collection, false);
        project._domainKB = knowledgeBase;
        knowledgeBase.setProject(project);
        return project;
    }

    private boolean createDomainKB(KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
        if (knowledgeBaseFactory == null) {
            knowledgeBaseFactory = this.getKnowledgeBaseFactory();
        }
        if (knowledgeBaseFactory == null) {
            String string = "Cannot find knowledgebase factory: " + this.getSources().getString("factory_class_name") + "\nPlease check that you have the required plug-in.";
            Log.getLogger().severe(string);
            collection.add(string);
            return false;
        }
        this._domainKB = knowledgeBaseFactory.createKnowledgeBase(collection);
        for (String string : this.getProjectSlotValues(SLOT_JAVA_PACKAGES)) {
            this._domainKB.addJavaLoadPackage(string);
        }
        this._domainKB.setProject(this);
        this._frameCounts.updateSystemFrameCounts(this._domainKB);
        this.setKnowledgeBaseFactory(knowledgeBaseFactory);
        return true;
    }

    public void createDomainKnowledgeBase(KnowledgeBaseFactory knowledgeBaseFactory, Collection collection, boolean bl) {
        if (!this.createDomainKB(knowledgeBaseFactory, collection)) {
            return;
        }
        if (bl) {
            MergingNarrowFrameStore mergingNarrowFrameStore = MergingNarrowFrameStore.get(this._domainKB);
            if (mergingNarrowFrameStore != null) {
                mergingNarrowFrameStore.setQueryAllFrameStores(true);
            }
            Collection collection2 = this.loadIncludedProjects(this.getProjectURI(), this._projectInstance, collection);
            this.loadDomainKB(collection2, collection);
            if (mergingNarrowFrameStore != null) {
                mergingNarrowFrameStore.setQueryAllFrameStores(false);
            }
        }
        this._domainKB.addKnowledgeBaseListener(this._knowledgeBaseListener);
        this.loadCachedKnowledgeBaseObjects(this._projectInstance);
        this._domainKB.setGenerateEventsEnabled(true);
        this._domainKB.setChanged(false);
        this._projectKB.setChanged(false);
    }

    protected JFrame createFrame(Cls cls, Slot slot) {
        InstanceDisplay instanceDisplay = this.createInstanceDisplay(this, false, false);
        instanceDisplay.setInstance(slot, cls);
        return this.createFrame(instanceDisplay, new FrameSlotCombination(cls, slot));
    }

    protected JFrame createFrame(Instance instance) {
        InstanceDisplay instanceDisplay = this.createInstanceDisplay(this, true, false);
        instanceDisplay.setInstance(instance);
        return this.createFrame(instanceDisplay, instance);
    }

    public void setInstanceDisplayClass(Class clazz) {
        this._instanceDisplayClass = clazz;
    }

    protected InstanceDisplay createInstanceDisplay(Project project, boolean bl, boolean bl2) {
        InstanceDisplay instanceDisplay = this._instanceDisplayClass != null ? Project.createInstanceDisplaySubclass(this._instanceDisplayClass, project, bl, bl2) : new InstanceDisplay(project, bl, bl2);
        return instanceDisplay;
    }

    private static InstanceDisplay createInstanceDisplaySubclass(Class clazz, Project project, boolean bl, boolean bl2) {
        InstanceDisplay instanceDisplay = null;
        Class[] classArray = new Class[]{Project.class, Boolean.TYPE, Boolean.TYPE};
        Object[] objectArray = new Object[]{project, bl, bl2};
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            instanceDisplay = (InstanceDisplay)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Log.getLogger().warning(exception.getMessage());
        }
        return instanceDisplay;
    }

    protected JFrame createFrame(InstanceDisplay instanceDisplay, Object object) {
        final JFrame jFrame = ComponentFactory.createFrame();
        jFrame.addWindowListener(this._closeListener);
        jFrame.getContentPane().add((Component)instanceDisplay, "Center");
        ComponentUtilities.pack(jFrame);
        instanceDisplay.setResizeVertically(true);
        ClsWidget clsWidget = instanceDisplay.getFirstClsWidget();
        jFrame.setTitle(clsWidget.getLabel());
        clsWidget.addWidgetListener(new WidgetAdapter(){

            public void labelChanged(WidgetEvent widgetEvent) {
                jFrame.setTitle(widgetEvent.getWidget().getLabel());
            }
        });
        this.setLocation(jFrame);
        jFrame.setVisible(true);
        this._frames.put(object, jFrame);
        this._objects.put(jFrame, object);
        return jFrame;
    }

    public static Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
        return new Project(null, knowledgeBaseFactory, collection, true);
    }

    private void createNewTabWidgetDescriptors(Collection collection) {
        for (String string : collection) {
            WidgetDescriptor widgetDescriptor = WidgetDescriptor.create(this._projectKB);
            widgetDescriptor.setWidgetClassName(string);
            widgetDescriptor.setVisible(false);
            this._tabWidgetDescriptors.add(widgetDescriptor);
        }
    }

    public ClsWidget createRuntimeClsWidget(Instance instance) {
        return this.createRuntimeClsWidget(instance, null);
    }

    public ClsWidget createRuntimeClsWidget(Instance instance, Cls cls) {
        return this.createRuntimeClsWidget(instance.getDirectType(), instance, cls);
    }

    public ClsWidget createRuntimeClsWidget(Cls cls, Instance instance, Cls cls2) {
        ClsWidget clsWidget;
        if (cls == null) {
            Log.getLogger().severe("no direct type: " + instance.getName());
            clsWidget = new UglyClsWidget();
        } else {
            ClsWidget clsWidget2 = this.getDesignTimeClsWidget(cls);
            WidgetDescriptor widgetDescriptor = clsWidget2.getDescriptor();
            clsWidget = WidgetUtilities.createClsWidget(widgetDescriptor, false, this, cls);
        }
        clsWidget.setInstance(instance);
        if (cls2 != null) {
            clsWidget.setAssociatedCls(cls2);
        }
        this.postRuntimeClsWidgetCreatedEvent(clsWidget);
        return clsWidget;
    }

    public Widget createRuntimeWidget(Instance instance) {
        return this.createRuntimeClsWidget(instance);
    }

    public WidgetDescriptor createWidgetDescriptor() {
        return WidgetDescriptor.create(this._projectKB);
    }

    public WidgetDescriptor createWidgetDescriptor(Cls cls, Slot slot, Facet facet) {
        return this._widgetMapper.createWidgetDescriptor(cls, slot, facet);
    }

    public void dispose() {
        this.postProjectEvent(3);
        this.clearWidgets();
        if (this._domainKB != null) {
            this._domainKB.dispose();
        }
        if (this._projectKB != null) {
            this._projectKB.dispose();
        }
        this._domainKB = null;
        this._projectKB = null;
        this._projectInstance = null;
        this._activeClsWidgetDescriptors = null;
        this._cachedDesignTimeClsWidgets = null;
        this._frames = null;
        this._objects = null;
    }

    private void clearWidgets() {
        if (this._cachedDesignTimeClsWidgets != null) {
            for (JComponent jComponent : this._cachedDesignTimeClsWidgets.values()) {
                ComponentUtilities.dispose(jComponent);
            }
            this._cachedDesignTimeClsWidgets.clear();
        }
    }

    private void flushProjectKBCache() {
        this.saveBrowserSlots();
        this.saveCustomizedWidgets();
        this.saveDefaultMetaclasses();
        this.saveHiddenFrameFlags();
        this.saveNextFrameNumber();
        this.saveClientInformation();
    }

    public Collection getAllKnowledgeBaseFactories() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : this.getProjectSlotValues(SLOT_ALL_KNOWLEDGE_BASE_FACTORY_NAMES)) {
            arrayList.add(SystemUtilities.newInstance(string));
        }
        return arrayList;
    }

    public Slot getBrowserSlot(Cls cls) {
        return Project.getPatternSlot(this.getBrowserSlotPattern(cls));
    }

    public Collection getBrowserSlots(Cls cls) {
        return this.getBrowserSlotPattern(cls).getSlots();
    }

    public Collection getClsesWithDirectBrowserSlots() {
        return this._directBrowserSlotPatterns.keySet();
    }

    public Collection getClsesWithCustomizedForms() {
        return this._activeClsWidgetDescriptors.keySet();
    }

    public Collection getHiddenFrames() {
        return new HashSet(this._hiddenFrames);
    }

    public BrowserSlotPattern getBrowserSlotPattern(Cls cls) {
        BrowserSlotPattern browserSlotPattern = this.getDirectBrowserSlotPattern(cls);
        if (browserSlotPattern == null) {
            browserSlotPattern = this.getInheritedBrowserSlotPattern(cls);
        }
        return browserSlotPattern;
    }

    public Slot getInheritedBrowserSlot(Cls cls) {
        return Project.getPatternSlot(this.getInheritedBrowserSlotPattern(cls));
    }

    private static Slot getPatternSlot(BrowserSlotPattern browserSlotPattern) {
        return browserSlotPattern == null ? null : browserSlotPattern.getFirstSlot();
    }

    public BrowserSlotPattern getInheritedBrowserSlotPattern(Cls cls) {
        BrowserSlotPattern browserSlotPattern = null;
        Iterator iterator = cls.getSuperclasses().iterator();
        while (iterator.hasNext() && browserSlotPattern == null) {
            Cls cls2 = (Cls)iterator.next();
            browserSlotPattern = this.getDirectBrowserSlotPattern(cls2);
        }
        return browserSlotPattern;
    }

    public PropertyList getClsWidgetPropertyList(Cls cls) {
        ClsWidget clsWidget = this.getDesignTimeClsWidget(cls);
        PropertyList propertyList = clsWidget.getDescriptor().getPropertyList();
        return propertyList;
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet) {
        return this._widgetMapper.getDefaultWidgetClassName(cls, slot, facet);
    }

    public ClsWidget getDesignTimeClsWidget(Cls cls) {
        ClsWidget clsWidget = (ClsWidget)this._cachedDesignTimeClsWidgets.get(cls);
        if (clsWidget == null) {
            WidgetDescriptor widgetDescriptor = this.getClsWidgetDescriptor(cls);
            clsWidget = WidgetUtilities.createClsWidget(widgetDescriptor, true, this, cls);
            this._cachedDesignTimeClsWidgets.put(cls, clsWidget);
        }
        return clsWidget;
    }

    public Slot getDirectBrowserSlot(Cls cls) {
        return Project.getPatternSlot(this.getDirectBrowserSlotPattern(cls));
    }

    public BrowserSlotPattern getDirectBrowserSlotPattern(Cls cls) {
        return (BrowserSlotPattern)this._directBrowserSlotPatterns.get(cls);
    }

    public boolean getDisplayAbstractClassIcon() {
        if (this._displayAbstractClassIcon == null) {
            this._displayAbstractClassIcon = this.loadOption(SLOT_DISPLAY_ABSTRACT_CLASS_ICON, true);
        }
        return this._displayAbstractClassIcon;
    }

    public boolean getDisplayConfirmationOnRemove() {
        if (this._displayConfirmationOnRemove == null) {
            this._displayConfirmationOnRemove = this.loadOption(SLOT_DISPLAY_REMOVE_CONFIRMATION_DIALOG, false);
        }
        return this._displayConfirmationOnRemove;
    }

    public boolean getDisplayHiddenClasses() {
        return this.getDisplayHiddenFrames();
    }

    public boolean getDisplayHiddenFrames() {
        if (this._displayHiddenClasses == null) {
            this._displayHiddenClasses = this.loadOption(SLOT_DISPLAY_HIDDEN_FRAMES, true);
        }
        return this._displayHiddenClasses;
    }

    public boolean getDisplayMultiParentClassIcon() {
        if (this._displayMultiParentClassIcon == null) {
            this._displayMultiParentClassIcon = this.loadOption(SLOT_DISPLAY_MULTI_PARENT_CLASS_ICON, true);
        }
        return this._displayMultiParentClassIcon;
    }

    private static void setIconImage(JFrame jFrame, Instance instance) {
        Icon icon = instance.getIcon();
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            Image image = imageIcon.getImage();
            jFrame.setIconImage(image);
        }
    }

    public Collection getIncludedProjects() {
        return this.projectURITree.getDescendents(this.projectURITree.getRoot());
    }

    public Tree getProjectTree() {
        return (Tree)this.projectURITree.clone();
    }

    public void setDirectIncludedProjectURIs(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URI uRI : collection) {
            URI uRI2 = URIUtilities.relativize(this._uri, uRI);
            arrayList.add(uRI2.toString());
        }
        this.setProjectSlotValues(SLOT_INCLUDED_PROJECTS, arrayList);
    }

    public Collection getDirectIncludedProjects() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URI uRI : this.getDirectIncludedProjectURIs()) {
            File file = new File(uRI);
            arrayList.add(file.getPath());
        }
        return arrayList;
    }

    public Collection<URI> getDirectIncludedProjectURIs() {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (String string : this.getProjectSlotValues(SLOT_INCLUDED_PROJECTS)) {
            URI uRI = null;
            uRI = URIUtilities.isURI(string) ? URIUtilities.createURI(string) : URIUtilities.resolve(this.getProjectURI(), string);
            arrayList.add(uRI);
        }
        return arrayList;
    }

    public KnowledgeBase getInternalProjectKnowledgeBase() {
        return this._projectKB;
    }

    public URI getJournalURI() {
        URI uRI = URIUtilities.replaceExtension(this._uri, ".pjrn");
        if (uRI == null) {
            File file = ApplicationProperties.getApplicationDirectory();
            File file2 = new File(file, "remote_project.pjrn");
            uRI = file2.toURI();
        }
        return uRI;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._domainKB;
    }

    public KnowledgeBaseFactory getKnowledgeBaseFactory() {
        String string = this.getSources().getString("factory_class_name");
        KnowledgeBaseFactory knowledgeBaseFactory = string == null ? new ClipsKnowledgeBaseFactory() : (KnowledgeBaseFactory)SystemUtilities.newInstance(string);
        return knowledgeBaseFactory;
    }

    public String getName() {
        return this.getProjectName();
    }

    public String getProjectName() {
        return URIUtilities.getBaseName(this._uri);
    }

    public Collection getOpenWindows() {
        return Collections.unmodifiableCollection(this._frames.values());
    }

    private boolean getOption(String string, boolean bl) {
        Boolean bl2 = (Boolean)Project.getOwnSlotValue(this.getOptionsInstance(), string);
        return bl2 == null ? bl : bl2;
    }

    private Instance getOptionsInstance() {
        Instance instance = (Instance)this.getProjectSlotValue(SLOT_OPTIONS);
        if (instance == null) {
            Cls cls = this._projectKB.getCls(CLASS_OPTIONS);
            instance = this._projectKB.createInstance(null, cls);
            this.setProjectSlotValue(SLOT_OPTIONS, instance);
        }
        return instance;
    }

    private static Object getOwnSlotValue(Frame frame, String string) {
        return ModelUtilities.getDirectOwnSlotValue(frame, string);
    }

    protected static Reader getProjectClsesReader() {
        Reader reader = Files.getSystemClsesReader();
        if (reader == null) {
            Log.getLogger().severe("Unable to read system ontology");
        }
        return reader;
    }

    public URI getProjectURI() {
        return this._uri;
    }

    public URI getProjectDirectoryURI() {
        return URIUtilities.getParentURI(this._uri);
    }

    public File getProjectDirectoryFile() {
        File file = this.getProjectFile();
        return file == null ? null : file.getParentFile();
    }

    public File getProjectFile() {
        return this._uri == null ? null : new File(this._uri);
    }

    public String getProjectFilePath() {
        File file = this.getProjectFile();
        return file == null ? null : file.getPath();
    }

    public Instance getProjectInstance() {
        return this._projectInstance;
    }

    protected static Instance getProjectInstance(KnowledgeBase knowledgeBase) {
        Instance instance = null;
        Cls cls = knowledgeBase.getCls(CLASS_PROJECT);
        if (cls == null) {
            Log.getLogger().severe("no project class");
        } else {
            Collection collection = cls.getDirectInstances();
            instance = (Instance)CollectionUtilities.getFirstItem(collection);
        }
        if (instance == null) {
            Log.getLogger().severe("no project instance");
        }
        return instance;
    }

    protected static Reader getProjectInstancesReader(URI uRI, KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
        String string;
        Reader reader = null;
        if (uRI != null && (reader = URIUtilities.createBufferedReader(uRI)) == null) {
            collection.add("Unable to load project: " + uRI);
        }
        if (reader == null && knowledgeBaseFactory != null && (string = knowledgeBaseFactory.getProjectFilePath()) != null && (reader = FileUtilities.getResourceReader(knowledgeBaseFactory.getClass(), string)) == null) {
            Log.getLogger().severe("Unable to read factory project: " + string);
        }
        if (reader == null && (reader = Files.getSystemInstancesReader()) == null) {
            Log.getLogger().severe("Unable to read system instances");
        }
        return reader;
    }

    private static Object getProjectSlotValue(Instance instance, String string) {
        return ModelUtilities.getDirectOwnSlotValue(instance, string);
    }

    private Object getProjectSlotValue(String string) {
        return Project.getProjectSlotValue(this._projectInstance, string);
    }

    private static Collection getProjectSlotValues(Instance instance, String string) {
        return ModelUtilities.getDirectOwnSlotValues(instance, string);
    }

    private Collection getProjectSlotValues(String string) {
        return Project.getProjectSlotValues(this._projectInstance, string);
    }

    private static PropertyList getPropertyList(Instance instance, String string) {
        PropertyList propertyList;
        Instance instance2 = (Instance)Project.getOwnSlotValue(instance, string);
        if (instance2 == null) {
            propertyList = PropertyList.create(instance.getKnowledgeBase());
            Project.setOwnSlotValue(instance, string, propertyList.getWrappedInstance());
        } else {
            propertyList = new PropertyList(instance2);
        }
        return propertyList;
    }

    private PropertyList getPropertyList(String string) {
        return Project.getPropertyList(this._projectInstance, string);
    }

    public PropertyList getSources() {
        return new PropertyList((Instance)this.getProjectSlotValue(SLOT_SOURCES));
    }

    private static PropertyList getSources(Instance instance) {
        return new PropertyList((Instance)Project.getProjectSlotValue(instance, SLOT_SOURCES));
    }

    public Collection getSuitableWidgetClassNames(Cls cls, Slot slot, Facet facet) {
        return this._widgetMapper.getSuitableWidgetClassNames(cls, slot, facet);
    }

    public WidgetDescriptor getTabWidgetDescriptor(String string) {
        WidgetDescriptor widgetDescriptor = null;
        for (WidgetDescriptor widgetDescriptor2 : this.getTabWidgetDescriptors()) {
            if (!widgetDescriptor2.getWidgetClassName().equals(string)) continue;
            widgetDescriptor = widgetDescriptor2;
            break;
        }
        return widgetDescriptor;
    }

    public Collection getTabWidgetDescriptors() {
        if (this._tabWidgetDescriptors == null) {
            HashSet hashSet = new HashSet(PluginUtilities.getAvailableTabWidgetClassNames());
            this._tabWidgetDescriptors = new ArrayList();
            for (Instance instance : this.getProjectSlotValues(SLOT_TABS)) {
                boolean bl;
                WidgetDescriptor widgetDescriptor = WidgetDescriptor.create(instance);
                String string = widgetDescriptor.getWidgetClassName();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Project found tab plugin called " + string);
                }
                if (PluginUtilities.isLoadableClass(string)) {
                    this._tabWidgetDescriptors.add(widgetDescriptor);
                }
                if ((bl = hashSet.remove(string)) || !log.isLoggable(Level.FINE)) continue;
                log.fine("tab " + string + " not in manifest");
            }
            this.createNewTabWidgetDescriptors(hashSet);
        }
        return this._tabWidgetDescriptors;
    }

    public boolean getUpdateModificationSlots() {
        if (this._updateModificationSlots == null) {
            this._updateModificationSlots = this.loadOption(SLOT_UPDATE_MODIFICATION_SLOTS, false);
        }
        return this._updateModificationSlots;
    }

    private boolean hasChanged() {
        return this._hasChanged;
    }

    public boolean hasCompleteSources() {
        boolean bl;
        KnowledgeBaseFactory knowledgeBaseFactory = this.getKnowledgeBaseFactory();
        boolean bl2 = bl = this._uri != null && knowledgeBaseFactory != null;
        if (bl) {
            bl = knowledgeBaseFactory.isComplete(this.getSources());
        }
        return bl;
    }

    public boolean hasCustomizedDescriptor(Cls cls) {
        WidgetDescriptor widgetDescriptor = (WidgetDescriptor)this._activeClsWidgetDescriptors.get(cls);
        if (widgetDescriptor != null && !widgetDescriptor.isDirectlyCustomizedByUser()) {
            widgetDescriptor = null;
        }
        return widgetDescriptor != null;
    }

    public boolean hasIncludedProjects() {
        return !this.getIncludedProjects().isEmpty();
    }

    private void includeDomainKB(Instance instance, String string, Collection collection, Collection collection2) {
        String string2 = Project.getSources(instance).getString("factory_class_name");
        if (string2 == null) {
            Log.getLogger().warning("Unable to load prj:" + string);
            return;
        }
        KnowledgeBaseFactory knowledgeBaseFactory = (KnowledgeBaseFactory)SystemUtilities.newInstance(string2);
        PropertyList propertyList = Project.getSources(instance);
        if (knowledgeBaseFactory instanceof KnowledgeBaseFactory2) {
            NarrowFrameStore narrowFrameStore = ((KnowledgeBaseFactory2)knowledgeBaseFactory).createNarrowFrameStore(string);
            MergingNarrowFrameStore mergingNarrowFrameStore = this.getMergingFrameStore();
            mergingNarrowFrameStore.addActiveFrameStore(narrowFrameStore, collection);
        }
        knowledgeBaseFactory.includeKnowledgeBase(this._domainKB, propertyList, collection2);
    }

    public void includeProject(String string, Collection collection) {
        this.includeProject(URIUtilities.createURI(string), collection);
    }

    public void includeProject(URI uRI, Collection collection) {
        this.includeProject(uRI, true, collection);
    }

    public void includeProject(URI uRI, boolean bl, Collection collection) {
        if (bl) {
            this.loadIncludedProject(this.getProjectURI(), uRI, collection);
        }
        this.recordIncludedProject(uRI);
    }

    public boolean isDirty() {
        return Project.hasChanged(this._domainKB) || Project.hasChanged(this._projectKB) || this.hasChanged();
    }

    private static boolean hasChanged(KnowledgeBase knowledgeBase) {
        return knowledgeBase != null && knowledgeBase.hasChanged();
    }

    public boolean isHidden(Frame frame) {
        return this._hiddenFrames.contains(frame);
    }

    private boolean isAlreadyIncluded(URI uRI) {
        return this.projectURITree.isReachable(uRI);
    }

    private boolean isIncludedBrowserSlotPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        return Project.equals(this._includedBrowserSlotPatterns.get(cls), browserSlotPattern);
    }

    public boolean isJournalingEnabled() {
        Boolean bl = (Boolean)this.getProjectSlotValue(SLOT_JOURNALING_ENABLED);
        return bl == null ? false : bl;
    }

    public boolean isReadonly() {
        if (this._isReadonly == null) {
            this._isReadonly = this.loadOption(SLOT_IS_READONLY, false);
        }
        return this._isReadonly;
    }

    public boolean isSuitableWidget(Cls cls, Slot slot, Facet facet, WidgetDescriptor widgetDescriptor) {
        return this._widgetMapper.isSuitableWidget(cls, slot, facet, widgetDescriptor);
    }

    public void loadBrowserSlots(Instance instance) {
        Object object;
        Object object2;
        Cls cls;
        Object object32;
        PropertyList propertyList = Project.getPropertyList(instance, SLOT_BROWSER_SLOTS);
        for (Object object32 : propertyList.getNames()) {
            if (object32 == null) {
                Log.getLogger().warning("null class name");
                continue;
            }
            cls = this._domainKB.getCls((String)object32);
            object2 = propertyList.getString((String)object32);
            object = BrowserSlotPattern.createFromSerialization(this._domainKB, (String)object2);
            if (cls != null && object != null) {
                this.recordDirectBrowserSlotPattern(cls, (BrowserSlotPattern)object);
                if (instance == this._projectInstance) continue;
                this._includedBrowserSlotPatterns.put(cls, object);
                continue;
            }
            propertyList.remove((String)object32);
        }
        object32 = this._domainKB.getSlot(":NAME");
        cls = this._domainKB.getCls(":META-CLASS");
        if (cls == null) {
            object2 = this._domainKB.getCls(":CLASS");
            this.recordDirectBrowserSlotPattern((Cls)object2, new BrowserSlotPattern((Slot)object32));
            object = this._domainKB.getCls(":SLOT");
            this.recordDirectBrowserSlotPattern((Cls)object, new BrowserSlotPattern((Slot)object32));
        } else {
            this.recordDirectBrowserSlotPattern(cls, new BrowserSlotPattern((Slot)object32));
        }
    }

    private void loadCachedKnowledgeBaseObjects(Instance instance) {
        this.loadClientInformation(instance);
        this.loadNextFrameNumber(instance);
        this.loadWidgetMapper(instance);
        this.loadWidgetDescriptors(instance);
        this.loadBrowserSlots(instance);
        this.loadDefaultMetaclasses(instance);
        this.loadHiddenFrameFlags(instance);
        this._defaultClsWidgetClassName = (String)Project.getProjectSlotValue(instance, SLOT_DEFAULT_INSTANCE_WIDGET_CLASS_NAME);
        this._domainKB.setModificationRecordUpdatingEnabled(this.getUpdateModificationSlots());
    }

    public void setDefaultClsWidgetClassName(String string) {
        this._defaultClsWidgetClassName = string;
        this.setProjectSlotValue(SLOT_DEFAULT_INSTANCE_WIDGET_CLASS_NAME, string);
    }

    private void loadDefaultMetaclasses(Instance instance) {
        Cls cls;
        Object object;
        Object object2;
        String string = (String)Project.getProjectSlotValue(instance, SLOT_DEFAULT_CLS_METACLASS);
        if (string != null && !string.equals(":STANDARD-CLASS") && (object2 = this._domainKB.getCls(string)) != null) {
            this._domainKB.setDefaultClsMetaCls((Cls)object2);
        }
        if ((object2 = (String)Project.getProjectSlotValue(instance, SLOT_DEFAULT_SLOT_METACLASS)) != null && !((String)object2).equals(":STANDARD-SLOT") && (object = this._domainKB.getCls((String)object2)) != null) {
            this._domainKB.setDefaultSlotMetaCls((Cls)object);
        }
        if ((object = (String)Project.getProjectSlotValue(instance, SLOT_DEFAULT_FACET_METACLASS)) != null && !((String)object).equals(":STANDARD-FACET") && (cls = this._domainKB.getCls((String)object)) != null) {
            this._domainKB.setDefaultFacetMetaCls(cls);
        }
    }

    private void loadDomainKB(Collection collection, Collection collection2) {
        KnowledgeBaseFactory knowledgeBaseFactory = this.getKnowledgeBaseFactory();
        if (knowledgeBaseFactory != null) {
            this._frameCounts.updateIncludedFrameCounts(this._domainKB);
            boolean bl = this._domainKB.setGenerateEventsEnabled(false);
            if (knowledgeBaseFactory instanceof KnowledgeBaseFactory2) {
                URI uRI = this.getProjectURI();
                String string = uRI == null ? "<new>" : uRI.toString();
                NarrowFrameStore narrowFrameStore = ((KnowledgeBaseFactory2)knowledgeBaseFactory).createNarrowFrameStore(string);
                MergingNarrowFrameStore mergingNarrowFrameStore = this.getMergingFrameStore();
                mergingNarrowFrameStore.addActiveFrameStore(narrowFrameStore, collection);
            }
            knowledgeBaseFactory.loadKnowledgeBase(this._domainKB, this.getSources(), collection2);
            this._domainKB.setGenerateEventsEnabled(bl);
        }
    }

    private void loadHiddenFrameFlags(Instance instance) {
        for (String string : Project.getProjectSlotValues(instance, SLOT_HIDDEN_FRAMES)) {
            Frame frame = this._domainKB.getFrame(string);
            if (frame == null) continue;
            this.recordHidden(frame, true);
            if (!this.isIncluded(instance)) continue;
            this._includedHiddenFrames.add(frame);
        }
    }

    private boolean isIncluded(Instance instance) {
        return this._projectInstance != instance;
    }

    public URI getLoadingURI() {
        return this._loadingProjectURI == null ? this.getProjectURI() : this._loadingProjectURI;
    }

    private void loadIncludedProject(URI uRI, URI uRI2, Collection collection) {
        KnowledgeBase knowledgeBase;
        uRI2 = URIUtilities.normalize(uRI2);
        boolean bl = this.isAlreadyIncluded(uRI2);
        this.projectURITree.addChild(uRI, uRI2);
        if (!bl && (knowledgeBase = Project.loadProjectKB(uRI2, null, collection)) != null) {
            URI uRI3 = this._loadingProjectURI;
            this._loadingProjectURI = uRI2;
            knowledgeBase.setName(URIUtilities.getName(uRI2));
            Instance instance = Project.getProjectInstance(knowledgeBase);
            Collection collection2 = this.loadIncludedProjects(uRI2, instance, collection);
            this.includeDomainKB(instance, uRI2.toString(), collection2, collection);
            this.loadCachedKnowledgeBaseObjects(instance);
            this._loadingProjectURI = uRI3;
        }
    }

    public Collection loadIncludedProjects(URI uRI, Instance instance, Collection collection) {
        LinkedHashSet<URI> linkedHashSet = new LinkedHashSet<URI>();
        for (String string : Project.getProjectSlotValues(instance, SLOT_INCLUDED_PROJECTS)) {
            URI uRI2 = this._uri == null ? URIUtilities.createURI(string) : (URIUtilities.isURI(string) ? URIUtilities.createURI(string) : URIUtilities.resolve(uRI, string));
            this.loadIncludedProject(uRI, uRI2, collection);
            linkedHashSet.add(uRI2);
        }
        return linkedHashSet;
    }

    private void loadNextFrameNumber(Instance instance) {
        Integer n = (Integer)this.getProjectSlotValue(SLOT_NEXT_FRAME_NUMBER);
        int n2 = n == null ? ApplicationProperties.getOldNextFrameNumber() : n;
        int n3 = Math.max(this._domainKB.getNextFrameNumber(), n2);
        this._domainKB.setNextFrameNumber(n3);
    }

    private Boolean loadOption(String string, boolean bl) {
        boolean bl2 = this.getOption(string, bl);
        return bl2;
    }

    public static Project loadProjectFromURI(URI uRI, Collection collection) {
        return new Project(uRI, null, collection, true);
    }

    public static Project loadProjectFromURI(URI uRI, Collection collection, boolean bl) {
        return new Project(uRI, null, collection, true, bl);
    }

    public static Project loadProjectFromFile(String string, Collection collection) {
        return Project.loadProjectFromURI(new File(string).toURI(), collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static KnowledgeBase loadProjectKB(URI uRI, KnowledgeBaseFactory knowledgeBaseFactory, Collection collection) {
        Reader reader;
        Reader reader2;
        KnowledgeBase knowledgeBase;
        block6: {
            knowledgeBase = null;
            reader2 = null;
            reader = null;
            try {
                reader2 = Project.getProjectClsesReader();
                reader = Project.getProjectInstancesReader(uRI, knowledgeBaseFactory, collection);
                if (reader == null) {
                    collection.add("Unable to open project: " + uRI);
                    break block6;
                }
                knowledgeBase = new ClipsKnowledgeBaseFactory().loadKnowledgeBase(reader2, reader, collection);
                if (collection.size() == 0) {
                    BackwardsCompatibilityProjectFixups.fix(knowledgeBase);
                }
                Project.removeUnreferencedInstances(knowledgeBase);
                knowledgeBase.setGenerateEventsEnabled(false);
                knowledgeBase.setDispatchEventsEnabled(false);
            }
            catch (Exception exception) {
                try {
                    Log.getLogger().log(Level.SEVERE, "Error loading project kb", exception);
                    collection.add(exception);
                }
                catch (Throwable throwable) {
                    FileUtilities.close(reader2);
                    FileUtilities.close(reader);
                    throw throwable;
                }
                FileUtilities.close(reader2);
                FileUtilities.close(reader);
            }
        }
        FileUtilities.close(reader2);
        FileUtilities.close(reader);
        return knowledgeBase;
    }

    private void loadClientInformation(Instance instance) {
        Instance instance2 = (Instance)Project.getOwnSlotValue(instance, SLOT_PROPERTY_MAP);
        this._clientInformation = instance2 == null ? new HashMap() : PropertyMapUtil.load(instance2, this._domainKB);
    }

    private void loadWidgetDescriptors(Instance instance) {
        for (Instance instance2 : new ArrayList(Project.getProjectSlotValues(instance, SLOT_CUSTOMIZED_INSTANCE_WIDGETS))) {
            WidgetDescriptor widgetDescriptor;
            if (this.isIncluded(instance)) {
                instance2 = (Instance)instance2.deepCopy(this._projectKB, null);
            }
            if ((widgetDescriptor = WidgetDescriptor.create(instance2)) == null) {
                Log.getLogger().severe("Invalid widget instance: " + instance2);
                this.removeProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, instance2);
                continue;
            }
            Cls cls = this._domainKB.getCls(widgetDescriptor.getName());
            if (cls == null) {
                Log.getLogger().warning("unknown class: " + widgetDescriptor.getName());
                this.removeProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, instance2);
                continue;
            }
            if (this.isIncluded(instance)) {
                widgetDescriptor.setIncluded(true);
            }
            widgetDescriptor.setDirectlyCustomizedByUser(true);
            WidgetDescriptor widgetDescriptor2 = (WidgetDescriptor)this._activeClsWidgetDescriptors.get(cls);
            if (widgetDescriptor2 != null && !widgetDescriptor2.isIncluded()) continue;
            this._activeClsWidgetDescriptors.put(cls, widgetDescriptor);
        }
    }

    private void loadWidgetMapper(Instance instance) {
        if (this._widgetMapper == null) {
            this._widgetMapper = new DefaultWidgetMapper(this._projectKB);
        }
    }

    public void setWidgetMapper(WidgetMapper widgetMapper) {
        this._widgetMapper = widgetMapper;
    }

    public WidgetMapper getWidgetMapper() {
        return this._widgetMapper;
    }

    private void makeTemporaryWidgetsIncluded(boolean bl) {
        for (WidgetDescriptor widgetDescriptor : this._activeClsWidgetDescriptors.values()) {
            if (!widgetDescriptor.isTemporary()) continue;
            widgetDescriptor.setIncluded(bl);
        }
    }

    private void mergeIncludedFrames() {
        for (Frame frame : this._domainKB.getFrames()) {
            if (frame.isSystem()) continue;
            frame.setIncluded(false);
        }
    }

    public void mergeIncludedProjects() {
        this.mergeIncludedFrames();
        this.removeIncludedProjectReferences();
    }

    private void postRuntimeClsWidgetCreatedEvent(ClsWidget clsWidget) {
        this.postProjectEvent(4, clsWidget);
    }

    public void postFormChangeEvent(Cls cls) {
        ClsWidget clsWidget = this.getDesignTimeClsWidget(cls);
        this.postProjectEvent(1, clsWidget);
    }

    public void postFormChangeEvent(WidgetDescriptor widgetDescriptor) {
        Cls cls = this.getKnowledgeBase().getCls(widgetDescriptor.getName());
        this.postFormChangeEvent(cls);
    }

    public void postProjectEvent(int n) {
        this.postProjectEvent(n, null);
    }

    public void postProjectEvent(int n, ClsWidget clsWidget) {
        this._listeners.postEvent(this, n, clsWidget);
    }

    private void recordDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        Assert.assertNotNull("class", cls);
        if (browserSlotPattern == null) {
            this._directBrowserSlotPatterns.remove(cls);
        } else {
            this._directBrowserSlotPatterns.put(cls, browserSlotPattern);
        }
    }

    private void recordHidden(Frame frame, boolean bl) {
        if (bl) {
            this._hiddenFrames.add(frame);
        } else if (this._includedHiddenFrames.contains(frame)) {
            Log.getLogger().warning("Cannot 'unhide' an included hidden frame");
        } else {
            this._hiddenFrames.remove(frame);
        }
    }

    private void recordIncludedProject(URI uRI) {
        if (this._uri != null) {
            uRI = URIUtilities.relativize(this._uri, uRI);
        }
        this.addProjectSlotValue(SLOT_INCLUDED_PROJECTS, uRI.toString());
    }

    private void removeDisplay(Frame frame) {
        JFrame jFrame = (JFrame)this._frames.get(frame);
        if (jFrame != null) {
            ComponentUtilities.closeWindow(jFrame);
        }
    }

    public void removeIncludedProjectReferences() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(this._includedBrowserSlotPatterns);
        hashMap.putAll(this._directBrowserSlotPatterns);
        this._directBrowserSlotPatterns = hashMap;
        this._includedBrowserSlotPatterns.clear();
        for (WidgetDescriptor widgetDescriptor : this._activeClsWidgetDescriptors.values()) {
            if (!widgetDescriptor.isIncluded()) continue;
            widgetDescriptor.setIncluded(false);
        }
        this.projectURITree = new Tree<URI>(this.getProjectURI());
        this.setProjectSlotValue(SLOT_INCLUDED_PROJECTS, null);
        this._hiddenFrames.addAll(this._includedHiddenFrames);
        this._includedHiddenFrames.clear();
    }

    public void removeJavaPackageName(String string) {
        this.removeProjectSlotValue(SLOT_JAVA_PACKAGES, string);
        this._domainKB.removeJavaLoadPackage(string);
    }

    public void removeProjectListener(ProjectListener projectListener) {
        this._listeners.remove(this, projectListener);
    }

    private void removeProjectSlotValue(String string, Object object) {
        ModelUtilities.removeOwnSlotValue(this._projectInstance, string, object);
    }

    protected static void removeUnreferencedInstances(KnowledgeBase knowledgeBase) {
        if (!Project.isNewProject(knowledgeBase)) {
            Instance instance = Project.getProjectInstance(knowledgeBase);
            Collection collection = CollectionUtilities.createCollection(instance);
            for (Instance instance2 : knowledgeBase.getUnreachableSimpleInstances(collection)) {
                if (!instance2.isEditable()) continue;
                knowledgeBase.deleteInstance(instance2);
            }
        }
    }

    public static boolean isNewProject(KnowledgeBase knowledgeBase) {
        return knowledgeBase.getBuildString() == null;
    }

    public void save(Collection collection) {
        this.saveDomainKB(collection);
        if (collection.isEmpty()) {
            this.flushProjectKBCache();
            this.makeTemporaryWidgetsIncluded(true);
            this.saveProjectKB(collection);
            this.makeTemporaryWidgetsIncluded(false);
        }
        if (collection.isEmpty()) {
            this.clearIsDirty();
            this.postProjectEvent(2);
        }
    }

    public void clearIsDirty() {
        this._projectKB.setChanged(false);
        this._domainKB.setChanged(false);
        this.setChanged(false);
    }

    private void saveBrowserSlots() {
        PropertyList propertyList = this.getPropertyList(SLOT_BROWSER_SLOTS);
        propertyList.clear();
        for (Map.Entry entry : this._directBrowserSlotPatterns.entrySet()) {
            BrowserSlotPattern browserSlotPattern;
            Cls cls = (Cls)entry.getKey();
            if (this.isIncludedBrowserSlotPattern(cls, browserSlotPattern = (BrowserSlotPattern)entry.getValue())) continue;
            propertyList.setString(cls.getName(), browserSlotPattern.getSerialization());
        }
    }

    private void saveCustomizedWidgets() {
        this.setProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, null);
        for (WidgetDescriptor widgetDescriptor : this._activeClsWidgetDescriptors.values()) {
            if (widgetDescriptor.isTemporary() || widgetDescriptor.isIncluded()) continue;
            this.addProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, widgetDescriptor.getInstance());
        }
    }

    private void saveDefaultMetaclasses() {
        this.setProjectSlotValue(SLOT_DEFAULT_CLS_METACLASS, Project.getName(this._domainKB.getDefaultClsMetaCls()));
        this.setProjectSlotValue(SLOT_DEFAULT_SLOT_METACLASS, Project.getName(this._domainKB.getDefaultSlotMetaCls()));
        this.setProjectSlotValue(SLOT_DEFAULT_FACET_METACLASS, Project.getName(this._domainKB.getDefaultFacetMetaCls()));
    }

    private static String getName(Cls cls) {
        return cls == null ? null : cls.getName();
    }

    private void saveDomainKB(Collection collection) {
        KnowledgeBaseFactory knowledgeBaseFactory = this.getKnowledgeBaseFactory();
        if (knowledgeBaseFactory != null) {
            knowledgeBaseFactory.saveKnowledgeBase(this._domainKB, this.getSources(), collection);
        }
    }

    private void saveHiddenFrameFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Frame frame : this._hiddenFrames) {
            if (this._includedHiddenFrames.contains(frame)) continue;
            String string = frame.getName();
            if (string == null) {
                Log.getLogger().warning("Ignoring nameless frame: " + frame);
                continue;
            }
            arrayList.add(string);
        }
        this.setProjectSlotValues(SLOT_HIDDEN_FRAMES, arrayList);
    }

    private void saveNextFrameNumber() {
        int n = this._domainKB.getNextFrameNumber();
        this.setProjectSlotValue(SLOT_NEXT_FRAME_NUMBER, new Integer(n));
    }

    private void saveProjectKB(Collection collection) {
        String string = new File(this._uri).toString();
        new ClipsKnowledgeBaseFactory().saveKnowledgeBase(this._projectKB, null, string, collection);
    }

    private void saveClientInformation() {
        if (!this._clientInformation.isEmpty()) {
            Instance instance = (Instance)Project.getOwnSlotValue(this._projectInstance, SLOT_PROPERTY_MAP);
            if (instance == null) {
                Cls cls = this._projectKB.getCls(CLASS_MAP);
                instance = this._projectKB.createInstance(null, cls);
                ModelUtilities.addOwnSlotValue(this._projectInstance, SLOT_PROPERTY_MAP, instance);
            }
            PropertyMapUtil.store(this._clientInformation, instance);
        }
    }

    private void saveTabWidgetInstances() {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (WidgetDescriptor widgetDescriptor : this._tabWidgetDescriptors) {
            String string = widgetDescriptor.getWidgetClassName();
            if (SystemUtilities.forName(string) == null) continue;
            arrayList.add(widgetDescriptor.getInstance());
        }
        this.setProjectSlotValues(SLOT_TABS, arrayList);
    }

    private void setChanged(boolean bl) {
        this._hasChanged = bl;
    }

    void setDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern browserSlotPattern) {
        this.recordDirectBrowserSlotPattern(cls, browserSlotPattern);
        this.setChanged(true);
    }

    public void setDisplayAbstractClassIcon(boolean bl) {
        this._displayAbstractClassIcon = bl;
        this.setOption(SLOT_DISPLAY_ABSTRACT_CLASS_ICON, bl);
    }

    public void setDisplayConfirmationOnRemove(boolean bl) {
        this._displayConfirmationOnRemove = bl;
        this.setOption(SLOT_DISPLAY_REMOVE_CONFIRMATION_DIALOG, bl);
    }

    public void setDisplayHiddenFrames(boolean bl) {
        this._displayHiddenClasses = bl;
        this.setOption(SLOT_DISPLAY_HIDDEN_FRAMES, bl);
    }

    public void setDisplayHiddenClasses(boolean bl) {
        this.setDisplayHiddenFrames(bl);
    }

    public void setDisplayMultiParentClassIcon(boolean bl) {
        this._displayMultiParentClassIcon = bl;
        this.setOption(SLOT_DISPLAY_MULTI_PARENT_CLASS_ICON, bl);
    }

    public void setHidden(Frame frame, boolean bl) {
        this.recordHidden(frame, bl);
        this.setChanged(true);
    }

    public void setIsReadonly(boolean bl) {
        this._isReadonly = bl;
        this.setOption(SLOT_IS_READONLY, bl);
    }

    public void setJournalingEnabled(boolean bl) {
        this.setProjectSlotValue(SLOT_JOURNALING_ENABLED, bl);
        if (bl) {
            this._domainKB.startJournaling(this.getJournalURI());
        } else {
            this._domainKB.stopJournaling();
        }
    }

    public void setKnowledgeBaseFactory(KnowledgeBaseFactory knowledgeBaseFactory) {
        Assert.assertNotNull("factory", knowledgeBaseFactory);
        this.getSources().setString("factory_class_name", knowledgeBaseFactory.getClass().getName());
    }

    private void setLocation(Window window) {
        if (this._lastLocation == null) {
            ComponentUtilities.center(window);
            this._lastLocation = window.getLocation();
        } else {
            this._lastLocation.x += 25;
            this._lastLocation.y += 25;
            Dimension dimension = window.getToolkit().getScreenSize();
            if (this._lastLocation.x + window.getWidth() > dimension.width || this._lastLocation.y + window.getHeight() > dimension.height) {
                this._lastLocation = new Point();
            }
            window.setLocation(this._lastLocation);
        }
    }

    private void setOption(String string, boolean bl) {
        Project.setOwnSlotValue(this.getOptionsInstance(), string, bl);
    }

    private static void setOwnSlotValue(Frame frame, String string, Object object) {
        ModelUtilities.setOwnSlotValue(frame, string, object);
    }

    public void setProjectFilePath(String string) {
        this.setProjectURI(URIUtilities.createURI(string));
    }

    public void setProjectURI(URI uRI) {
        if (this._uri != null) {
            this.updateDirectIncludedProjectURIs(uRI);
        }
        this._uri = URIUtilities.normalize(uRI);
        this.updateKBNames();
        this.updateJournaling();
        this.projectURITree.swapNode(this.projectURITree.getRoot(), uRI);
        if (uRI != null) {
            this.setActiveFrameStoreName(uRI);
        }
        this.activeRootURI = uRI;
    }

    private MergingNarrowFrameStore getMergingFrameStore() {
        return MergingNarrowFrameStore.get(this._domainKB);
    }

    private void setActiveFrameStoreName(URI uRI) {
        MergingNarrowFrameStore mergingNarrowFrameStore;
        if (uRI != null && (mergingNarrowFrameStore = this.getMergingFrameStore()) != null) {
            mergingNarrowFrameStore.getActiveFrameStore().setName(uRI.toString());
        }
    }

    private void setActiveFrameStore(URI uRI) {
        MergingNarrowFrameStore mergingNarrowFrameStore;
        if (uRI != null && (mergingNarrowFrameStore = this.getMergingFrameStore()) != null) {
            mergingNarrowFrameStore.setActiveFrameStore(uRI.toString());
        }
    }

    public URI getActiveRootURI() {
        return this.activeRootURI;
    }

    public void setActiveRootURI(URI uRI) {
        this.activeRootURI = uRI = URIUtilities.normalize(uRI);
        this.setActiveFrameStore(uRI);
        this._domainKB.flushCache();
    }

    private void updateDirectIncludedProjectURIs(URI uRI) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URI uRI2 : this.getDirectIncludedProjectURIs()) {
            URI uRI3 = URIUtilities.relativize(uRI, uRI2);
            arrayList.add(uRI3.toString());
        }
        this.setProjectSlotValues(SLOT_INCLUDED_PROJECTS, arrayList);
    }

    private void setProjectSlotValue(String string, Object object) {
        ModelUtilities.setOwnSlotValue(this._projectInstance, string, object);
    }

    private void setProjectSlotValues(String string, Collection collection) {
        ModelUtilities.setOwnSlotValues(this._projectInstance, string, collection);
    }

    public void setTabWidgetDescriptorOrder(Collection collection) {
        this._tabWidgetDescriptors = new ArrayList(collection);
        this.saveTabWidgetInstances();
    }

    public void setUpdateModificationSlots(boolean bl) {
        this._updateModificationSlots = bl;
        this.setOption(SLOT_UPDATE_MODIFICATION_SLOTS, bl);
        this._domainKB.setModificationRecordUpdatingEnabled(bl);
    }

    private void setupJournaling() {
        if (this.isJournalingEnabled()) {
            URI uRI = this.getJournalURI();
            this._domainKB.startJournaling(uRI);
        }
    }

    public JFrame show(Cls cls, Slot slot) {
        FrameSlotCombination frameSlotCombination = new FrameSlotCombination(cls, slot);
        JFrame jFrame = (JFrame)this._frames.get(frameSlotCombination);
        if (jFrame == null) {
            jFrame = this.createFrame(cls, slot);
            Project.setIconImage(jFrame, slot);
        } else {
            jFrame.toFront();
            jFrame.requestFocus();
        }
        return jFrame;
    }

    public JFrame show(Instance instance) {
        Assert.assertNotNull("instance", instance);
        JFrame jFrame = (JFrame)this._frames.get(instance);
        if (jFrame == null) {
            jFrame = this.createFrame(instance);
            Project.setIconImage(jFrame, instance);
        } else {
            jFrame.toFront();
            jFrame.requestFocus();
        }
        return jFrame;
    }

    public JFrame show(String string) {
        Assert.assertNotNull("instance name", string);
        Instance instance = this._domainKB.getInstance(string);
        return this.show(instance);
    }

    public JInternalFrame showInInternalFrame(Instance instance) {
        Assert.assertNotNull("instance", instance);
        InstanceDisplay instanceDisplay = this.createInstanceDisplay(this, false, false);
        instanceDisplay.setInstance(instance);
        instanceDisplay.setResizeVertically(true);
        ClsWidget clsWidget = instanceDisplay.getFirstClsWidget();
        String string = clsWidget.getLabel();
        JInternalFrame jInternalFrame = new JInternalFrame(string, true);
        jInternalFrame.getContentPane().setLayout(new BorderLayout());
        jInternalFrame.getContentPane().add(instanceDisplay);
        jInternalFrame.pack();
        return jInternalFrame;
    }

    public String toString() {
        return "Project(" + this.getProjectName() + ")";
    }

    private void updateJournaling() {
        if (this._projectKB != null && this.isJournalingEnabled()) {
            this._domainKB.stopJournaling();
            this._domainKB.startJournaling(this.getJournalURI());
        }
    }

    private void updateKBNames() {
        String string = this.getProjectName();
        if (string != null) {
            if (this._domainKB != null) {
                this._domainKB.setName(string);
            }
            if (this._projectKB != null) {
                this._projectKB.setName(string + "_ProjectKB");
            }
        }
    }

    private WidgetDescriptor getClsWidgetDescriptor(Cls cls) {
        WidgetDescriptor widgetDescriptor = (WidgetDescriptor)this._activeClsWidgetDescriptors.get(cls);
        if (widgetDescriptor == null) {
            widgetDescriptor = WidgetDescriptor.create(this._projectKB);
            widgetDescriptor.setWidgetClassName(this._defaultClsWidgetClassName);
            widgetDescriptor.setName(cls.getName());
            widgetDescriptor.setTemporary(true);
            this._activeClsWidgetDescriptors.put(cls, widgetDescriptor);
        }
        return widgetDescriptor;
    }

    public Object getClientInformation(Object object) {
        return this._clientInformation.get(object);
    }

    public void setClientInformation(Object object, Object object2) {
        if (object2 == null) {
            this._clientInformation.remove(object);
        } else {
            this._clientInformation.put(object, object2);
        }
    }

    public Collection getCurrentUsers() {
        return this._projectKB.getCurrentUsers();
    }

    public String getLocalUser() {
        return null;
    }

    protected void setKnowledgeBases(KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        this._domainKB = knowledgeBase;
        this._domainKB.addKnowledgeBaseListener(this._knowledgeBaseListener);
        this._domainKB.setProject(this);
        this._projectKB = knowledgeBase2;
        this._projectInstance = Project.getProjectInstance(this._projectKB);
        this.loadCachedKnowledgeBaseObjects(this._projectInstance);
    }

    public FrameCounts getFrameCounts() {
        this._frameCounts.updateDirectFrameCounts(this._domainKB);
        return this._frameCounts;
    }

    public boolean isMultiUserClient() {
        return false;
    }

    public boolean isMultiUserServer() {
        return this.isMultiUserServer;
    }

    public String getUserName() {
        return ApplicationProperties.getUserName();
    }

    public void setPrettyPrintSlotWidgetLabels(boolean bl) {
        this.prettyPrintSlotWidgetLabels = bl;
    }

    public boolean getPrettyPrintSlotWidgetLabels() {
        if (this.prettyPrintSlotWidgetLabels == null) {
            boolean bl = ApplicationProperties.getPrettyPrintSlotWidgetLabels();
            this.prettyPrintSlotWidgetLabels = this.loadOption(SLOT_PRETTY_PRINT_SLOT_WIDGET_LABELS, bl);
        }
        return this.prettyPrintSlotWidgetLabels;
    }

    public boolean getTabbedInstanceFormLayout() {
        return this.getOption(SLOT_TABBED_INSTANCE_FORM_LAYOUT, false);
    }

    public void setTabbedInstanceFormLayout(boolean bl) {
        this.setOption(SLOT_TABBED_INSTANCE_FORM_LAYOUT, bl);
    }

    static {
        SystemUtilities.initialize();
    }
}

