/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.parser.rdql.Node;
import com.hp.hpl.jena.query.parser.rdql.ParsedLiteral;
import com.hp.hpl.jena.query.parser.rdql.Q_Identifier;
import com.hp.hpl.jena.query.parser.rdql.Q_URI;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;

public class Q_TextLiteral
extends ParsedLiteral {
    Q_URI datatype = null;
    String langTag = null;
    String seen = null;

    Q_TextLiteral(int n) {
        super(n);
    }

    Q_TextLiteral(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void set(String string) {
        this.seen = string;
        string = string.substring(1, string.length() - 1);
        super._setString(Q_TextLiteral.unescape(string, '\\'));
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node = this.jjtGetChild(i);
            if (node instanceof Q_Identifier) {
                this.langTag = ((Q_Identifier)node).idName;
            }
            if (!(node instanceof Q_URI)) continue;
            this.datatype = (Q_URI)node;
        }
        if (this.langTag != null) {
            this.seen = this.seen + "@" + this.langTag;
        }
        if (this.datatype != null) {
            this.seen = this.seen + "^^" + this.datatype.asQuotedString();
        }
    }

    public void postParse2(Query query2) {
        super.postParse2(query2);
        String string = null;
        if (this.datatype != null) {
            this.datatype.postParse2(query2);
            string = this.datatype.getURI();
        }
        com.hp.hpl.jena.graph.Node node = null;
        if (string != null) {
            RDFDatatype rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string);
            node = com.hp.hpl.jena.graph.Node.createLiteral((String)super.getString(), null, (RDFDatatype)rDFDatatype);
        } else {
            node = com.hp.hpl.jena.graph.Node.createLiteral((String)super.getString(), (String)this.langTag, null);
        }
        super._setNode(node);
    }

    public String asQuotedString() {
        return this.seen;
    }

    static String unescape(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c || i >= string.length() - 1) continue;
            char c2 = string.charAt(i + 1);
            if (c2 == 'n') {
                c2 = '\n';
            }
            if (c2 == 't') {
                c2 = '\t';
            }
            if (c2 == 'r') {
                c2 = '\r';
            }
            if (c2 == 'b') {
                c2 = '\b';
            }
            string = string.substring(0, i) + c2 + string.substring(i + 2);
        }
        return string;
    }
}

