/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.emf.EditableEMFGeneratorOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EMFPanel
extends JPanel {
    private JFileChooser fileChooser = new JFileChooser(".");
    private EditableEMFGeneratorOptions options;
    private JCheckBox overwriteCheckBox;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;

    public EMFPanel(EditableEMFGeneratorOptions options) {
        this.options = options;
        this.packageTextField = new JTextField();
        if (options.getPackage() != null) {
            this.packageTextField.setText(options.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (options.getOutputFolder() != null) {
            this.rootFolderTextField.setText(options.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.overwriteCheckBox = new JCheckBox("Overwrite all files");
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent lc = new LabeledComponent("Root output folder", (Component)this.rootFolderTextField);
        lc.addHeaderButton((Action)new AbstractAction("Select folder...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent e) {
                EMFPanel.this.selectFolder();
            }
        });
        this.add((Component)lc);
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Java package", (Component)this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.overwriteCheckBox.setPreferredSize(new Dimension(400, 24));
        this.add(this.overwriteCheckBox);
    }

    public boolean isOverwriteMode() {
        return this.overwriteCheckBox.isSelected();
    }

    public void ok() {
        File newFile = null;
        String rootFolder = this.rootFolderTextField.getText().trim();
        if (rootFolder.length() > 0) {
            newFile = new File(rootFolder);
        }
        this.options.setOutputFolder(newFile);
        String pack = this.packageTextField.getText().trim();
        this.options.setPackage(pack.length() > 0 ? pack : null);
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }

    public void setOverwriteMode(boolean value) {
        this.overwriteCheckBox.setSelected(value);
    }
}

