/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprNode1;
import com.hp.hpl.jena.query.expr.ExprNode2;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.NodeVar;
import com.hp.hpl.jena.query.serializer.FmtExpr;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class FmtExprAbstract
extends FmtExpr {
    static final int INDENT = 2;
    static final boolean ONELINE = true;
    IndentedWriter out;
    SerializationContext context;

    public FmtExprAbstract(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        this.out = indentedWriter;
        this.context = serializationContext;
        if (this.context == null) {
            this.context = new SerializationContext(null, null, null);
        }
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Expr expr) {
        FmtExprAbstract fmtExprAbstract = new FmtExprAbstract(indentedWriter, serializationContext);
        fmtExprAbstract.startVisit();
        expr.visit(fmtExprAbstract);
        fmtExprAbstract.finishVisit();
    }

    public void startVisit() {
    }

    public void visit(ExprNode1 exprNode1) {
        this.out.print("(");
        this.out.print(exprNode1.getOpName());
        this.endLine();
        this.out.incIndent(2);
        exprNode1.getExpr().visit(this);
        this.out.decIndent(2);
        this.out.print(")");
    }

    public void visit(ExprNode2 exprNode2) {
        this.out.print("(");
        this.out.print(exprNode2.getOpName());
        this.endLine();
        this.out.incIndent(2);
        exprNode2.getLeft().visit(this);
        this.endLine();
        exprNode2.getRight().visit(this);
        this.out.decIndent(2);
        this.out.print(")");
    }

    public void visit(ExprNodeFunction exprNodeFunction) {
        Expr expr;
        this.out.print("(");
        this.out.print(exprNodeFunction.getPrintName(this.context.getQuery()));
        this.out.incIndent(2);
        int n = 1;
        while ((expr = exprNodeFunction.getArg(n)) != null) {
            this.out.print(' ');
            expr.visit(this);
            ++n;
        }
        this.out.print(")");
        this.out.decIndent(2);
    }

    public void visit(NodeValue nodeValue) {
        nodeValue.format(this.context.getQuery(), this.out);
    }

    public void visit(NodeVar nodeVar) {
        this.out.print("?");
        this.out.print(nodeVar.getName());
    }

    public void finishVisit() {
        this.out.flush();
    }

    private void endLine() {
        this.out.print(' ');
    }
}

