/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import com.hp.hpl.jena.query.parser.sparql.ParseException;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParser;
import com.hp.hpl.jena.query.parser.sparql.TokenMgrError;
import java.io.ByteArrayInputStream;

public class ParseUtils {
    public static Expr parseARQ(String string) {
        return ParseUtils.parseARQ(null, string);
    }

    public static Expr parseARQ(Query query2, String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            ARQParser aRQParser = new ARQParser(byteArrayInputStream);
            aRQParser.setQuery(query2);
            return aRQParser.Expression();
        }
        catch (com.hp.hpl.jena.query.parser.arq.ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (com.hp.hpl.jena.query.parser.arq.TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            throw new QueryException(throwable);
        }
    }

    public static Expr parseSPARQL(String string) {
        return ParseUtils.parseSPARQL(null, string);
    }

    public static Expr parseSPARQL(Query query2, String string) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            SPARQLParser sPARQLParser = new SPARQLParser(byteArrayInputStream);
            sPARQLParser.setQuery(query2);
            return sPARQLParser.Expression();
        }
        catch (ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            throw new QueryException(throwable);
        }
    }
}

