/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionEventDispatcher;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.util.Collection;
import javax.swing.JComponent;

public class SelectableContainer
extends JComponent
implements Selectable,
Disposable {
    private ListenerCollection _listeners = new ListenerList(new SelectionEventDispatcher());
    private Selectable _selectable;
    private SelectionListener _selectionListener = new SelectionListener(){

        public void selectionChanged(SelectionEvent selectionEvent) {
            SelectableContainer.this.onSelectionChange();
            SelectableContainer.this.notifySelectionListeners();
        }
    };

    public SelectableContainer() {
        this.setLayout(new BorderLayout());
    }

    public SelectableContainer(Selectable selectable) {
        this();
        this.addSelectable(selectable);
    }

    private void addSelectable(Selectable selectable) {
        this._selectable = selectable;
        if (this._selectable != null) {
            this._selectable.addSelectionListener(this._selectionListener);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this._listeners.add(this, selectionListener);
    }

    public void clearSelection() {
        this._selectable.clearSelection();
    }

    public void dispose() {
        this.removeSelectable();
    }

    public Selectable getSelectable() {
        return this._selectable;
    }

    public Collection getSelection() {
        return this._selectable.getSelection();
    }

    public Object getSoleSelection() {
        Object object = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            object = CollectionUtilities.getFirstItem(collection);
        }
        return object;
    }

    public void notifySelectionListeners() {
        this._listeners.postEvent(this, 1);
    }

    public void onSelectionChange() {
    }

    private void removeSelectable() {
        if (this._selectable != null) {
            this._selectable.removeSelectionListener(this._selectionListener);
        }
        this._selectable = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this._listeners.remove(this, selectionListener);
    }

    public boolean setNotificationsEnabled(boolean bl) {
        return this._listeners.setPostingEnabled(bl);
    }

    public void setSelectable(Selectable selectable) {
        this.removeSelectable();
        this.addSelectable(selectable);
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }
}

