/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.IntegerResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetSubsumptionRelationshipTask
extends AbstractReasonerTask
implements IntegerResultReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;
    private OWLClass cls1;
    private OWLClass cls2;
    private int result;

    public GetSubsumptionRelationshipTask(ProtegeOWLReasoner protegeOWLReasoner, OWLClass cls1, OWLClass cls2) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.cls1 = cls1;
        this.cls2 = cls2;
        this.result = 0;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        Document asksDoc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createSubsumesQuery(asksDoc, "q1Sub2", this.cls1, this.cls2);
        this.getTranslator().createSubsumesQuery(asksDoc, "q2Sub1", this.cls2, this.cls1);
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(asksDoc);
        Iterator it = this.getTranslator().getDIGQueryResponseIterator(this.protegeOWLReasoner.getKnowledgeBase(), responseDoc);
        boolean cls1SubsumesCls2 = false;
        boolean cls2SubsumedCls1 = false;
        while (it.hasNext()) {
            DIGQueryResponse queryResponse = (DIGQueryResponse)it.next();
            if (queryResponse.getID().equals("q1Sub2")) {
                cls1SubsumesCls2 = queryResponse.getBoolean();
                continue;
            }
            cls2SubsumedCls1 = queryResponse.getBoolean();
        }
        this.result = cls1SubsumesCls2 ? (cls2SubsumedCls1 ? 3 : 1) : (cls2SubsumedCls1 ? 2 : 0);
        this.setProgress(1);
        this.setTaskCompleted();
    }

    public int getResult() {
        return this.result;
    }
}

