/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFind
implements Find {
    private static final int MAX_MATCHES = -1;
    protected OWLModel owlModel;
    protected Map results = new HashMap();
    protected String string;
    protected int searchType;
    private List listeners;
    private boolean running = false;

    public BasicFind(OWLModel owlModel, int type) {
        this.owlModel = owlModel;
        this.searchType = type;
    }

    @Override
    public void startSearch(String s) {
        this.startSearch(s, this.searchType);
    }

    @Override
    public void startSearch(String s, int type) {
        this.notifySearchStarted();
        this.string = s;
        this.searchType = type;
        this.results.clear();
        if (this.string != null && this.string.length() > 0) {
            List searchProps = this.getSearchProperties();
            Iterator i = searchProps.iterator();
            while (i.hasNext()) {
                this.results.putAll(this.searchOnSlot((Slot)i.next(), this.string, null, this.searchType));
            }
            String lang = this.owlModel.getDefaultLanguage();
            if (lang != null) {
                for (Slot slot : searchProps) {
                    if (slot.equals(this.owlModel.getNameSlot())) continue;
                    this.results.putAll(this.searchOnSlot(slot, this.string, lang, this.searchType));
                }
            }
        }
        this.notifySearchComplete();
    }

    @Override
    public void cancelSearch() {
    }

    protected Map searchOnSlot(Slot searchProp, String searchStr, String lang, int searchType) {
        HashMap<RDFResource, FindResult> slotResults = new HashMap<RDFResource, FindResult>();
        Collection frames = null;
        String actualSearchString = searchStr;
        switch (searchType) {
            case 0: {
                actualSearchString = String.valueOf(actualSearchString) + "*";
            }
            case 3: {
                if (lang == null) break;
                actualSearchString = "~#" + lang + " " + actualSearchString;
                break;
            }
            case 1: {
                actualSearchString = String.valueOf(actualSearchString) + "*";
            }
            case 2: {
                actualSearchString = "*" + actualSearchString;
            }
        }
        frames = this.owlModel.getMatchingFrames(searchProp, null, false, actualSearchString, -1);
        if (frames != null) {
            for (Frame f : frames) {
                RDFResource res;
                FindResult item;
                if (!this.isValidFrameToSearch(f) || (item = FindResult.createFindResult(res = (RDFResource)f, searchProp, searchStr)) == null) continue;
                slotResults.put(res, item);
            }
        }
        return slotResults;
    }

    protected List getSearchProperties() {
        ArrayList<Slot> searchProps = new ArrayList<Slot>();
        Collection synonymProps = this.owlModel.getSearchSynonymProperties();
        searchProps.addAll(synonymProps);
        searchProps.add(this.owlModel.getNameSlot());
        Slot bs = this.owlModel.getOWLNamedClassClass().getBrowserSlotPattern().getFirstSlot();
        if (!bs.equals(this.owlModel.getNameSlot()) && !synonymProps.contains(bs)) {
            searchProps.add(bs);
        }
        return searchProps;
    }

    @Override
    public Map<RDFResource, FindResult> getResults() {
        return this.results;
    }

    @Override
    public Set getResultResources() {
        return this.results.keySet();
    }

    @Override
    public int getResultCount() {
        return this.results.size();
    }

    @Override
    public String getSummaryText() {
        if (this.running) {
            return "Searching for \"" + this.string + "\" : (" + this.results.size() + " matches)";
        }
        return "Results for \"" + this.string + "\" : (" + this.results.size() + " matches)";
    }

    @Override
    public String getLastSearch() {
        return this.string;
    }

    @Override
    public String getDescription() {
        return "Find Resource";
    }

    @Override
    public OWLModel getModel() {
        return this.owlModel;
    }

    @Override
    public int getNumSearchProperties() {
        return this.getSearchProperties().size();
    }

    protected boolean isValidFrameToSearch(Frame f) {
        Class<?> fclass = f.getClass();
        return OWLNamedClass.class.isAssignableFrom(fclass) || OWLProperty.class.isAssignableFrom(fclass) || OWLIndividual.class.isAssignableFrom(fclass);
    }

    @Override
    public int getSearchType() {
        return this.searchType;
    }

    protected void notifySearchStarted() {
        this.running = true;
        for (SearchListener l : this.listeners) {
            l.searchStartedEvent(this);
            l.searchEvent(this);
        }
        Thread.yield();
    }

    protected void notifyResultsUpdated() {
        for (SearchListener l : this.listeners) {
            l.resultsUpdatedEvent(this.results.size(), this);
            l.searchEvent(this);
        }
        Thread.yield();
    }

    protected void notifySearchComplete() {
        this.running = false;
        for (SearchListener l : this.listeners) {
            l.searchCompleteEvent(this.results.size(), this);
            l.searchEvent(this);
        }
        Thread.yield();
    }

    protected void notifySearchCancelled() {
        for (SearchListener l : this.listeners) {
            l.searchCancelledEvent(this);
            l.searchEvent(this);
        }
        this.running = false;
        Thread.yield();
    }

    @Override
    public void addResultListener(SearchListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    @Override
    public boolean removeResultListener(SearchListener l) {
        if (this.listeners != null) {
            return this.listeners.remove(l);
        }
        return false;
    }
}

