/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.digest;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.w3c.rdf.digest.AbstractDigest;
import org.w3c.rdf.digest.Digest;
import org.w3c.rdf.digest.DigestException;
import org.w3c.rdf.digest.GenericDigest;
import org.w3c.rdf.digest.MD5Digest;
import org.w3c.rdf.digest.SHA1Digest;

public class DigestUtil {
    public static Digest computeDigest(String string, String string2) throws NoSuchAlgorithmException {
        try {
            byte[] byArray = string2.getBytes("UTF8");
            return DigestUtil.computeDigest(string, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("DigestImpl: weird internal error: UTF-8 is not supported");
        }
    }

    public static Digest computeDigest(String string, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        try {
            return DigestUtil.createFromBytes(string, byArray2);
        }
        catch (DigestException digestException) {
            throw new RuntimeException("Bogus implementation of digest algorithm " + string + ": " + digestException.getMessage());
        }
    }

    public static Digest createFromBytes(String string, byte[] byArray) throws DigestException {
        if ("MD5".equals(string)) {
            if (byArray.length != 16) {
                throw new DigestException("MD5 digest must be 16 bytes long");
            }
            return new MD5Digest(byArray);
        }
        if ("SHA-1".equals(string)) {
            if (byArray.length != 20) {
                throw new DigestException("SHA-1 digest must be 20 bytes long");
            }
            return new SHA1Digest(byArray);
        }
        return new GenericDigest(string, byArray);
    }

    public static int digestBytes2HashCode(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    public static boolean equal(Digest digest, Digest digest2) {
        if (digest == digest2) {
            return true;
        }
        try {
            if (digest instanceof AbstractDigest && digest2 instanceof AbstractDigest) {
                return DigestUtil.equal(((AbstractDigest)digest).digest, ((AbstractDigest)digest2).digest);
            }
            if (digest.getDigestAlgorithm().equals(digest2.getDigestAlgorithm())) {
                return DigestUtil.equal(digest.getDigestBytes(), digest2.getDigestBytes());
            }
        }
        catch (DigestException digestException) {}
        return false;
    }

    public static boolean equal(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int getHashCode(Digest digest) throws DigestException {
        return DigestUtil.digestBytes2HashCode(digest.getDigestBytes());
    }

    public static String toHexString(Digest digest) throws DigestException {
        return DigestUtil.toHexString(digest.getDigestBytes());
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = (byArray[n] & 0xF0) >> 4;
            int n3 = byArray[n] & 0xF;
            stringBuffer.append((char)(n2 > 9 ? 97 + n2 - 10 : 48 + n2));
            stringBuffer.append((char)(n3 > 9 ? 97 + n3 - 10 : 48 + n3));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void xor(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[n2]);
            ++n2;
        }
    }

    public static void xor(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 + n) % n2;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[n3]);
            ++n3;
        }
    }
}

