/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.validator.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DefaultPropertyValueValidatorTestCase
extends AbstractJenaTestCase {
    private RDFSDatatypeFactory factory;

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = this.owlModel.getRDFSDatatypeFactory();
    }

    public void testIntegerRangeExclusive() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass subject = this.owlThing;
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSDatatype datatype = this.factory.createAnonymousDatatype(this.owlModel.getXSDint());
        this.factory.setMinExclusive(datatype, this.owlModel.createRDFSLiteral(new Integer(2)));
        this.factory.setMaxExclusive(datatype, this.owlModel.createRDFSLiteral(new Integer(4)));
        property.setRange(datatype);
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, new Integer(1)));
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, new Integer(2)));
        DefaultPropertyValueValidatorTestCase.assertTrue((boolean)subject.isValidPropertyValue(property, new Integer(3)));
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, new Integer(4)));
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, new Integer(5)));
    }

    public void testIntegerRangeInclusive() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass subject = this.owlThing;
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSDatatype datatype = this.factory.createAnonymousDatatype(this.owlModel.getXSDint());
        this.factory.setMinInclusive(datatype, this.owlModel.createRDFSLiteral(new Integer(2)));
        this.factory.setMaxInclusive(datatype, this.owlModel.createRDFSLiteral(new Integer(4)));
        property.setRange(datatype);
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, new Integer(1)));
        DefaultPropertyValueValidatorTestCase.assertTrue((boolean)subject.isValidPropertyValue(property, new Integer(2)));
        DefaultPropertyValueValidatorTestCase.assertTrue((boolean)subject.isValidPropertyValue(property, new Integer(4)));
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, new Integer(5)));
    }

    public void testStringLength() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass subject = this.owlThing;
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSDatatype datatype = this.factory.createAnonymousDatatype(this.owlModel.getXSDstring());
        this.factory.setLength(datatype, 4);
        property.setRange(datatype);
        DefaultPropertyValueValidatorTestCase.assertTrue((boolean)subject.isValidPropertyValue(property, "aldi"));
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, "holgi"));
    }

    public void testStringMinMaxLength() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass subject = this.owlThing;
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSDatatype datatype = this.factory.createAnonymousDatatype(this.owlModel.getXSDstring());
        this.factory.setMinLength(datatype, 2);
        this.factory.setMaxLength(datatype, 4);
        property.setRange(datatype);
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, "h"));
        DefaultPropertyValueValidatorTestCase.assertTrue((boolean)subject.isValidPropertyValue(property, "aldi"));
        DefaultPropertyValueValidatorTestCase.assertFalse((boolean)subject.isValidPropertyValue(property, "holgi"));
    }
}

