/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;

public class FGraph
implements Finder {
    protected Graph graph;

    public FGraph(Graph graph) {
        this.graph = graph;
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        if (this.graph == null) {
            return WrappedIterator.create(new NullIterator());
        }
        return this.graph.find(triplePattern.asTripleMatch());
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        if (this.graph == null) {
            return WrappedIterator.create(new NullIterator());
        }
        if (finder == null) {
            return this.graph.find(triplePattern.asTripleMatch());
        }
        return this.graph.find(triplePattern.asTripleMatch()).andThen(finder.find(triplePattern));
    }

    public Graph getGraph() {
        return this.graph;
    }

    public boolean contains(TriplePattern triplePattern) {
        return this.graph.contains(triplePattern.getSubject(), triplePattern.getPredicate(), triplePattern.getObject());
    }
}

