/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collections;

public class DependingDeleteTestCase
extends AbstractJenaTestCase {
    public void testDeleteHasRestrictionOnInstanceDelete() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLObjectProperty genderProperty = this.owlModel.createOWLObjectProperty("gender");
        OWLNamedClass genderCls = this.owlModel.createOWLNamedClass("Gender");
        RDFResource male = genderCls.createInstance("male");
        genderProperty.setUnionRangeClasses(Collections.singleton(genderCls));
        OWLNamedClass malePerson = this.owlModel.createOWLNamedClass("MalePerson");
        malePerson.addSuperclass(personCls);
        int oldCount = this.owlModel.getClsCount();
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(genderProperty, male);
        malePerson.addSuperclass(hasRestriction);
        male.delete();
        DependingDeleteTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteAllAndSomeRestrictionOnClsDelete() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass malePersonCls = this.owlModel.createOWLNamedClass("MalePerson");
        malePersonCls.addSuperclass(personCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        property.setUnionRangeClasses(Collections.singleton(personCls));
        property.addUnionDomainClass(personCls);
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, malePersonCls);
        personCls.addSuperclass(allRestriction);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(malePersonCls);
        OWLSomeValuesFrom someRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, complementCls);
        personCls.addSuperclass(someRestriction);
        int oldCount = this.owlModel.getClsCount();
        malePersonCls.delete();
        DependingDeleteTestCase.assertEquals((int)(oldCount - 4), (int)this.owlModel.getClsCount());
    }

    public void testDeleteRestrictionsOnSlotDelete() {
        OWLNamedClass personCls = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass malePersonCls = this.owlModel.createOWLNamedClass("MalePerson");
        malePersonCls.addSuperclass(personCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("children");
        property.setUnionRangeClasses(Collections.singleton(personCls));
        property.addUnionDomainClass(personCls);
        int oldCount = this.owlModel.getClsCount();
        OWLAllValuesFrom allRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, malePersonCls);
        personCls.addSuperclass(allRestriction);
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(malePersonCls);
        OWLSomeValuesFrom someRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, complementCls);
        personCls.addEquivalentClass(someRestriction);
        OWLMaxCardinality maxCardiRestriction = this.owlModel.createOWLMaxCardinality(property, 4);
        personCls.addDisjointClass(maxCardiRestriction);
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(property, "Tetzel");
        personCls.addDisjointClass(hasRestriction);
        property.delete();
        DependingDeleteTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteRestrictionOnSuperSlotDelete() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty superProperty = this.owlModel.createOWLObjectProperty("superProperty");
        OWLObjectProperty subProperty = this.owlModel.createOWLObjectProperty("subProperty");
        subProperty.addSuperproperty(superProperty);
        int clsCount = this.owlModel.getClsCount();
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(subProperty, 1));
        superProperty.delete();
        DependingDeleteTestCase.assertEquals((int)clsCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteSomeRestrictionOfInheritedCls() {
        OWLObjectProperty habitatSlot = this.owlModel.createOWLObjectProperty("hasHabitat");
        OWLNamedClass koalaCls = this.owlModel.createOWLNamedClass("Koala");
        int oldCount = this.owlModel.getClsCount();
        OWLNamedClass forestCls = this.owlModel.createOWLNamedClass("Forest");
        OWLNamedClass dryForestCls = this.owlModel.createOWLNamedSubclass("DryEucalyptForest", forestCls);
        koalaCls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)habitatSlot, dryForestCls));
        forestCls.delete();
        DependingDeleteTestCase.assertEquals((int)oldCount, (int)this.owlModel.getClsCount());
    }

    public void testDeleteAnonymousDatatypeInRestriction() {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        RDFSDatatype datatype = this.owlModel.createRDFSDatatype(this.owlModel.getNextAnonymousResourceName());
        OWLAllValuesFrom allValuesFrom = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, datatype);
        int oldCount = this.owlModel.getRDFSDatatypeClass().getInstances(true).size();
        allValuesFrom.delete();
        int newCount = this.owlModel.getRDFSDatatypeClass().getInstances(true).size();
        DependingDeleteTestCase.assertEquals((int)(oldCount - 1), (int)newCount);
    }

    public void testDeleteAnonymousDatatypeInRange() {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        RDFSDatatype datatype = this.owlModel.createRDFSDatatype(this.owlModel.getNextAnonymousResourceName());
        property.setRange(datatype);
        int oldCount = this.owlModel.getRDFSDatatypeClass().getInstances(true).size();
        property.delete();
        int newCount = this.owlModel.getRDFSDatatypeClass().getInstances(true).size();
        DependingDeleteTestCase.assertEquals((int)(oldCount - 1), (int)newCount);
    }
}

