/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleresource;

import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SetResourceAction
extends ResourceSelectionAction {
    private PropertyValuesComponent component;

    public SetResourceAction(PropertyValuesComponent component) {
        super("Select existing resource...", OWLIcons.getAddIcon("RDFIndividual"));
        this.component = component;
    }

    public Collection getEnumeratedValues(Collection unionRangeClasses) {
        HashSet results = new HashSet();
        for (RDFSClass rangeClass : unionRangeClasses) {
            if (!(rangeClass instanceof OWLEnumeratedClass)) continue;
            results.addAll(((OWLEnumeratedClass)rangeClass).getOneOf());
        }
        return results;
    }

    public Collection getSelectableResources() {
        RDFProperty predicate;
        RDFResource subject = this.component.getSubject();
        Set clses = this.getUnionRangeClasses(subject, predicate = this.component.getPredicate(), true);
        Collection enums = this.getEnumeratedValues(clses);
        if (enums.size() > 0) {
            return enums;
        }
        if (clses.contains(subject.getOWLModel().getOWLThingClass())) {
            return subject.getOWLModel().getUserDefinedRDFIndividuals(true);
        }
        HashSet instances = new HashSet();
        for (RDFSClass cls : clses) {
            instances.addAll(cls.getInstances(true));
        }
        return instances;
    }

    private Set getUnionRangeClasses(RDFResource subject, RDFProperty predicate, boolean includingEnumeratedClasses) {
        OWLModel owlModel = subject.getOWLModel();
        HashSet<RDFSClass> clses = new HashSet<RDFSClass>();
        for (RDFSClass type : subject.getRDFTypes()) {
            if (!(type instanceof RDFSNamedClass)) continue;
            RDFSNamedClass namedType = (RDFSNamedClass)type;
            Collection urcs = namedType.getUnionRangeClasses(predicate);
            for (RDFSClass rangeClass : urcs) {
                if (!(rangeClass instanceof RDFSNamedClass) && (!includingEnumeratedClasses || !(rangeClass instanceof OWLEnumeratedClass))) continue;
                clses.add(rangeClass);
            }
        }
        if (clses.isEmpty()) {
            clses.add(owlModel.getOWLThingClass());
        }
        return clses;
    }

    public RDFResource pickResource() {
        RDFResource subject = this.component.getSubject();
        RDFProperty predicate = this.component.getPredicate();
        OWLModel owlModel = predicate.getOWLModel();
        Set allClasses = this.getUnionRangeClasses(subject, predicate, true);
        Collection enums = this.getEnumeratedValues(allClasses);
        if (enums.isEmpty()) {
            Set clses = this.getUnionRangeClasses(subject, predicate, false);
            if (OWLUI.isExternalResourcesSupported(owlModel)) {
                owlModel.getRDFUntypedResourcesClass().setVisible(true);
                clses.add(owlModel.getRDFUntypedResourcesClass());
            }
            RDFResource resource = ProtegeUI.getSelectionDialogFactory().selectResourceByType((Component)((Object)this.component), owlModel, clses);
            owlModel.getRDFUntypedResourcesClass().setVisible(false);
            return resource;
        }
        return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection((Component)((Object)this.component), owlModel, enums, (String)this.getValue("Name"));
    }

    public void resourceSelected(RDFResource resource) {
        this.component.getSubject().setPropertyValue(this.component.getPredicate(), resource);
    }
}

