/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.DropDownOverlayIcon;
import edu.stanford.smi.protegex.owl.ui.triplestore.TripleStoreSelectionPanel;
import edu.stanford.smi.protegex.owl.ui.triplestore.TripleStoreTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class TripleStoreSelectionAction
extends AbstractAction {
    private JButton button;
    private JLabel label;
    private OWLModel owlModel;

    public TripleStoreSelectionAction(OWLModel owlModel) {
        super("Select active sub-ontology...", OWLIcons.getImageIcon("SelectActiveTripleStore"));
        this.owlModel = owlModel;
        this.label = new JLabel("                       ");
        this.updateLabel();
    }

    public void actionPerformed(ActionEvent e) {
        TripleStoreSelectionPanel.showDialog(this.owlModel);
        this.updateLabel();
    }

    public void activateButton(JButton button) {
        this.button = button;
        button.setToolTipText((String)this.getValue("Name"));
        button.setRolloverIcon(new DropDownOverlayIcon(button.getIcon(), button));
        button.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && TripleStoreSelectionAction.this.isEnabled()) {
                    TripleStoreSelectionAction.this.handleRightClick();
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && TripleStoreSelectionAction.this.isEnabled()) {
                    TripleStoreSelectionAction.this.handleRightClick();
                }
            }
        });
    }

    private void handleRightClick() {
        JPopupMenu menu = new JPopupMenu();
        TripleStoreTableModel tableModel = new TripleStoreTableModel(this.owlModel);
        TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
        TripleStore activeTripleStore = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        TripleStore topTripleStore = tsm.getTopTripleStore();
        DropDownAction action = new DropDownAction("<Main File>", topTripleStore);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setSelected(topTripleStore == activeTripleStore);
        menu.add(item);
        int i = 1;
        while (i < tableModel.getRowCount()) {
            TripleStore tripleStore = tableModel.getTripleStore(i);
            try {
                URI uri = new URI(tripleStore.getName());
                Repository rep = this.owlModel.getRepositoryManager().getRepository(uri);
                if (rep != null && rep.isWritable(uri)) {
                    DropDownAction action2 = new DropDownAction(uri.toString(), tripleStore);
                    JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(action2);
                    item2.setToolTipText(tripleStore.getName());
                    item2.setSelected(tripleStore == activeTripleStore);
                    menu.add(item2);
                }
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
            ++i;
        }
        menu.show(this.button, 0, this.button.getHeight());
    }

    public Component getLabelPanel() {
        return this.label;
    }

    private void updateLabel() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        OWLOntology ont = (OWLOntology)TripleStoreUtil.getFirstOntology(this.owlModel, ts);
        if (ont != null) {
            String file = ont.getURI();
            int index = file.lastIndexOf(47);
            if (index < 0) {
                index = file.lastIndexOf(92);
            }
            if (index >= 0) {
                file = file.substring(index + 1);
            }
            this.label.setText(file);
        } else {
            this.label.setText("");
        }
    }

    private class DropDownAction
    extends AbstractAction {
        private TripleStore tripleStore;

        public DropDownAction(String name, TripleStore tripleStore) {
            super(name);
            this.tripleStore = tripleStore;
        }

        public void actionPerformed(ActionEvent e) {
            TripleStoreUtil.switchTripleStore(TripleStoreSelectionAction.this.owlModel, this.tripleStore);
            TripleStoreSelectionAction.this.updateLabel();
        }
    }
}

