/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query.protege;

import java.io.IOException;
import java.util.List;

/**
 * ProfileIndividualLocators can be used to search an OWLModel for individuals
 * of ServiceProfile that adhere to a given set of search parameters.
 * 
 * @author tilmann
 */
public interface ProfileIndividualLocator {

	/**
	 * Get the maximum search level that can be used plus one.
	 * 
	 * @return the number of search levels available
	 */
	public int getAvailableSearchLevels();

	/**
	 * This method can be used to search for services profile individuals
	 * suitable to the previously set searchParameters. The resulting list may
	 * also contain individuals that do not perfectly match the parameters. This
	 * is indicated with a relevance below 1. How exact profile individuals are
	 * matched can be specified wiht the searchLevel parameter. Subsequent calls
	 * for a single search parameter must start with search level 0 and may
	 * increase searchlevel only by one each time up to the maximum that can be
	 * obtained by getAvailableSearchLevels.
	 * 
	 * @param searchLevel
	 *            the search level to be applied
	 * @return a list of search results
	 */
	public List<ProfileIndividualInfo> findProfileIndividuals(int searchLevel)
			throws IOException;

	/**
	 * Sets the search parameter for subsequent calls to findProfileIndividuals
	 * 
	 * @param searchParameter
	 *            the roles the individuals should have assigned
	 */
	public void setProfileIndividualParameter(
			ProfileIndividualParameter searchParameter);

	/**
	 * Get Conform Classes taken into account by the last search step executed.
	 * 
	 * @return a java bean containing conform classes
	 */
	public ParameterConformClasses getConformClasses();

}
