/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.ReturnBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class E_RegexJava
extends ExprNodeFunction
implements ReturnBoolean {
    private static final String name = "regex";
    Expr expr;
    String patternStr;
    String flags;
    int mask;
    Pattern pattern;

    public E_RegexJava(Expr expr, String string, String string2) {
        super(name);
        this.patternStr = string;
        this.expr = expr;
        this.flags = string2;
        this.mask = this.makeMask(this.flags);
        this.pattern = Pattern.compile(this.patternStr, this.mask);
    }

    public NodeValue eval(Binding binding) {
        NodeValue nodeValue = this.expr.eval(binding);
        if (!nodeValue.isString()) {
            throw new ExprEvalException("REGEXP: " + this.expr + " evaluates to " + nodeValue + ", which is not a string");
        }
        Matcher matcher = this.pattern.matcher(nodeValue.getString());
        if (matcher.matches()) {
            return NodeValue.TRUE;
        }
        return NodeValue.FALSE;
    }

    public void check() {
    }

    private int makeMask(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 1;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 's': {
                    n |= 0x10;
                    continue block6;
                }
                case 'x': {
                    n |= 0x20;
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regex modifiers: " + string.charAt(i));
                }
            }
        }
        return n;
    }

    public Expr getArg(int n) {
        if (n == 1) {
            return this.expr;
        }
        if (n == 2) {
            return NodeValue.makeString(this.patternStr);
        }
        if (n == 3 && this.flags != null) {
            return NodeValue.makeString(this.flags);
        }
        return null;
    }

    public int numArgs() {
        if (this.flags != null) {
            return 3;
        }
        return 2;
    }

    public String getPrintName(Query query2) {
        return name;
    }
}

