/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameHolder {
    private Map _frameIdToFrameMap = new HashMap();
    private FrameFactory _frameFactory;

    public FrameHolder(FrameFactory frameFactory) {
        this._frameFactory = frameFactory;
    }

    public Frame getFrame(FrameID frameID, Collection collection) {
        Frame frame = (Frame)this._frameIdToFrameMap.get(frameID);
        if (frame == null) {
            frame = this.createFrame(frameID, collection);
            this._frameIdToFrameMap.put(frameID, frame);
        }
        return frame;
    }

    private Frame createFrame(FrameID frameID, Collection collection) {
        Instance instance;
        Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
        if (cls == null || !cls.isMetaCls()) {
            instance = this._frameFactory.createSimpleInstance(frameID, collection);
        } else if (cls.isClsMetaCls()) {
            instance = this._frameFactory.createCls(frameID, collection);
        } else if (cls.isSlotMetaCls()) {
            instance = this._frameFactory.createSlot(frameID, collection);
        } else if (cls.isFacetMetaCls()) {
            instance = this._frameFactory.createFacet(frameID, collection);
        } else {
            throw new IllegalStateException("No metaclass found");
        }
        return instance;
    }
}

