/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collections;

public class DeleteListEntryTestCase
extends AbstractJenaTestCase {
    public void testDeleteEntries() {
        int oldListCount = this.owlModel.getRDFListClass().getInstanceCount(false);
        RDFList li = this.owlModel.createRDFList();
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setUnionRangeClasses(Collections.singleton(this.owlModel.getRDFListClass()));
        property.setDomain(cls);
        RDFResource instance = cls.createInstance("instance");
        instance.setPropertyValue(property, li);
        RDFResource a = cls.createInstance("a");
        RDFResource b = cls.createInstance("b");
        RDFResource c = cls.createInstance("c");
        li.append(a);
        li.append(b);
        li.append(c);
        DeleteListEntryTestCase.assertEquals((String)"rdf:List (a, b, c)", (String)li.getBrowserText());
        b.delete();
        DeleteListEntryTestCase.assertEquals((String)"rdf:List (a, c)", (String)li.getBrowserText());
        c.delete();
        DeleteListEntryTestCase.assertEquals((String)"rdf:List (a)", (String)li.getBrowserText());
        DeleteListEntryTestCase.assertEquals((Object)li, (Object)instance.getPropertyValue(property));
        a.delete();
        DeleteListEntryTestCase.assertNull((Object)instance.getPropertyValue(property));
        DeleteListEntryTestCase.assertEquals((int)oldListCount, (int)this.owlModel.getRDFListClass().getInstanceCount(false));
    }

    public void testDeleteFirstEntry() {
        RDFList li = this.owlModel.createRDFList();
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setUnionRangeClasses(Collections.singleton(this.owlModel.getRDFListClass()));
        slot.addUnionDomainClass(cls);
        RDFResource instance = cls.createInstance("instance");
        instance.setPropertyValue(slot, li);
        RDFResource a = cls.createInstance("a");
        RDFResource b = cls.createInstance("b");
        li.append(a);
        li.append(b);
        RDFList rest = li.getRest();
        DeleteListEntryTestCase.assertEquals((String)"rdf:List (a, b)", (String)li.getBrowserText());
        DeleteListEntryTestCase.assertEquals((Object)li, (Object)instance.getPropertyValue(slot));
        a.delete();
        DeleteListEntryTestCase.assertEquals((String)"rdf:List (b)", (String)rest.getBrowserText());
        DeleteListEntryTestCase.assertEquals((Object)rest, (Object)instance.getPropertyValue(slot));
    }

    public void testDeleteInstanceWithListAsValue() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setRange(this.owlModel.getRDFListClass());
        property.setDomain(cls);
        RDFResource a = cls.createInstance("a");
        RDFResource b = cls.createInstance("b");
        int frameCount = this.owlModel.getFrameCount();
        RDFResource instance = cls.createInstance("instance");
        RDFList li = this.owlModel.createRDFList();
        instance.setPropertyValue(property, li);
        li.append(a);
        li.append(b);
        instance.delete();
        DeleteListEntryTestCase.assertEquals((int)frameCount, (int)this.owlModel.getFrameCount());
    }
}

