/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLDLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class OWLTestLibrary {
    private static Map testMap = new HashMap();
    private static Set userDefinedClasses = new HashSet();

    public static void addOWLTestClass(Class clazz) {
        userDefinedClasses.add(clazz);
    }

    private static OWLTest createOWLTest(Class clazz) {
        try {
            return (OWLTest)clazz.newInstance();
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return null;
        }
    }

    public static OWLTest getOWLTest(Class clazz) {
        OWLTest test = (OWLTest)testMap.get(clazz);
        if (test == null) {
            test = OWLTestLibrary.createOWLTest(clazz);
            testMap.put(clazz, test);
        }
        return test;
    }

    public static Class[] getOWLTestClasses() {
        ArrayList clses = new ArrayList(PluginUtilities.getClassesWithAttribute((String)"OWLTest", (String)"True"));
        clses.addAll(userDefinedClasses);
        return clses.toArray(new Class[0]);
    }

    public static boolean isOWLDLTest(Class clazz) {
        OWLTest test = OWLTestLibrary.getOWLTest(clazz);
        return test instanceof OWLDLTest;
    }

    public static void repairRDFPropertyTests(RDFProperty property) {
        OWLModel owlModel = property.getOWLModel();
        OWLTest[] tests = owlModel.getOWLTests();
        int i = 0;
        while (i < tests.length) {
            OWLTest test = tests[i];
            if (test instanceof RDFPropertyTest && test instanceof AutoRepairableOWLTest) {
                RDFPropertyTest owlSlotTest = (RDFPropertyTest)test;
                OWLTestLibrary.repairOWLSlotTest(owlSlotTest, property);
            }
            ++i;
        }
    }

    private static void repairOWLSlotTest(RDFPropertyTest owlSlotTest, RDFProperty property) {
        List failures = owlSlotTest.test(property);
        for (OWLTestResult result : failures) {
            ((RepairableOWLTest)((Object)owlSlotTest)).repair(result);
        }
    }
}

