/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.CheckBoxWidget;
import edu.stanford.smi.protege.widget.ComboBoxWidget;
import edu.stanford.smi.protege.widget.FloatFieldWidget;
import edu.stanford.smi.protege.widget.FloatListWidget;
import edu.stanford.smi.protege.widget.IntegerFieldWidget;
import edu.stanford.smi.protege.widget.IntegerListWidget;
import edu.stanford.smi.protege.widget.StringListWidget;
import edu.stanford.smi.protege.widget.SymbolListWidget;
import edu.stanford.smi.protege.widget.TextAreaWidget;
import edu.stanford.smi.protege.widget.TextFieldWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.individuals.OWLIndividualsTab;
import edu.stanford.smi.protegex.owl.ui.widget.MultiLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiResourceWidget;
import edu.stanford.smi.protegex.owl.ui.widget.RDFListWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralAreaWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleResourceWidget;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class OWLBackwardsCompatibilityProjectFixups {
    private static void changeInstanceValue(KnowledgeBase kb, String className, String slotNameToCheck, String slotValue, String slotNameToChange, Object oldValue, Object newValue) {
        Cls cls = kb.getCls(className);
        Slot slotToCheck = kb.getSlot(slotNameToCheck);
        Slot slotToChange = kb.getSlot(slotNameToChange);
        for (Instance instance : cls.getInstances()) {
            if (!slotValue.equals(instance.getOwnSlotValue(slotToCheck)) || !oldValue.equals(instance.getOwnSlotValue(slotToChange))) continue;
            instance.setOwnSlotValue(slotToChange, newValue);
        }
    }

    public static void fix(OWLModel owlModel) {
        KnowledgeBase systemKB = owlModel.getProject().getInternalProjectKnowledgeBase();
        OWLBackwardsCompatibilityProjectFixups.updateStandardForms(systemKB);
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.cls.OWLClsesTab", OWLClassesTab.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.OWLIndividualsTab", OWLIndividualsTab.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.widget.OWLInstanceListWidget", MultiResourceWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.widget.OWLInstanceFieldWidget", SingleResourceWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.widget.ListInstanceWidget", RDFListWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.widget.LiteralFieldWidget", SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.widget.LiteralListWidget", MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, "edu.stanford.smi.protegex.owl.ui.widget.MultiLanguageStringValueWidget", MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, TextFieldWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, TextAreaWidget.class.getName(), SingleLiteralAreaWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, CheckBoxWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, ComboBoxWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, FloatFieldWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, FloatListWidget.class.getName(), MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, IntegerFieldWidget.class.getName(), SingleLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, IntegerListWidget.class.getName(), MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, StringListWidget.class.getName(), MultiLiteralWidget.class.getName());
        OWLBackwardsCompatibilityProjectFixups.renameWidget(systemKB, SymbolListWidget.class.getName(), MultiLiteralWidget.class.getName());
        String[] invisibles = new String[]{"owl:AnnotationProperty", "owl:DeprecatedClass", "owl:DeprecatedProperty", "owl:FunctionalProperty", "owl:InverseFunctionalProperty", "owl:SymmetricProperty", "owl:TransitiveProperty", "rdfs:Datatype", "rdf:Alt", "rdf:Bag", "rdf:Seq", "owl:AllDifferent", "owl:disjointWith", "owl:distinctMembers", "protege:ExternalResource"};
        int i = 0;
        while (i < invisibles.length) {
            String invisible = invisibles[i];
            RDFResource resource = owlModel.getRDFResource(invisible);
            resource.setVisible(false);
            ++i;
        }
    }

    private static Instance getClsWidgetInstance(String name, KnowledgeBase kb) {
        Instance result = null;
        List values = ModelUtilities.getDirectOwnSlotValues((Frame)OWLBackwardsCompatibilityProjectFixups.getProjectInstance(kb), (String)"customized_instance_widgets");
        for (Instance widgetInstance : values) {
            String widgetSlotName = (String)ModelUtilities.getDirectOwnSlotValue((Frame)widgetInstance, (String)"name");
            if (!name.equals(widgetSlotName)) continue;
            result = widgetInstance;
            break;
        }
        return result;
    }

    private static KnowledgeBaseFactory getFactory(KnowledgeBase kb) {
        KnowledgeBaseFactory result = null;
        Instance projectInstance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(kb);
        Instance sources = (Instance)ModelUtilities.getDirectOwnSlotValue((Frame)projectInstance, (String)"sources");
        for (Instance property : ModelUtilities.getDirectOwnSlotValues((Frame)sources, (String)"properties")) {
            String name = (String)ModelUtilities.getDirectOwnSlotValue((Frame)property, (String)"name");
            if (!name.equals("factory_class_name")) continue;
            String factoryName = (String)ModelUtilities.getDirectOwnSlotValue((Frame)property, (String)"string_value");
            result = (KnowledgeBaseFactory)SystemUtilities.newInstance((String)factoryName);
            break;
        }
        return result;
    }

    private static Instance getProjectInstance(KnowledgeBase kb) {
        Instance instance = kb.getInstance("PROJECT");
        Assert.assertNotNull((String)"instance", (Object)instance);
        return instance;
    }

    private static KnowledgeBase getTemplateKnowledgeBase(KnowledgeBase projectKB) {
        ArrayList errors = new ArrayList();
        Reader clsesReader = Files.getSystemClsesReader();
        KnowledgeBaseFactory factory = OWLBackwardsCompatibilityProjectFixups.getFactory(projectKB);
        String path = factory == null ? null : factory.getProjectFilePath();
        Reader instancesReader = path == null ? Files.getSystemInstancesReader() : FileUtilities.getResourceReader(factory.getClass(), (String)path);
        return new ClipsKnowledgeBaseFactory().loadKnowledgeBase(clsesReader, instancesReader, errors);
    }

    private static void renameWidget(KnowledgeBase kb, String oldWidgetName, String newWidgetName) {
        OWLBackwardsCompatibilityProjectFixups.changeInstanceValue(kb, "Widget", "widget_class_name", oldWidgetName, "widget_class_name", oldWidgetName, newWidgetName);
    }

    private static boolean replaceFormWidget(String name, KnowledgeBase projectKB, KnowledgeBase templateProjectKB) {
        Instance templateClsWidget = OWLBackwardsCompatibilityProjectFixups.getClsWidgetInstance(name, templateProjectKB);
        Instance projectClsWidget = OWLBackwardsCompatibilityProjectFixups.getClsWidgetInstance(name, projectKB);
        if (projectClsWidget == null) {
            Cls widgetCls = projectKB.getCls("Widget");
            projectClsWidget = projectKB.createInstance(null, widgetCls);
            ModelUtilities.setOwnSlotValue((Frame)projectClsWidget, (String)"name", (Object)name);
            Instance projectInstance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(projectKB);
            ModelUtilities.addOwnSlotValue((Frame)projectInstance, (String)"customized_instance_widgets", (Object)projectClsWidget);
        }
        Instance templatePropertyList = (Instance)ModelUtilities.getDirectOwnSlotValue((Frame)templateClsWidget, (String)"property_list");
        Instance newPropertyList = (Instance)templatePropertyList.deepCopy(projectKB, null);
        ModelUtilities.setOwnSlotValue((Frame)projectClsWidget, (String)"property_list", (Object)newPropertyList);
        return templateClsWidget != null;
    }

    private static void updateStandardForms(KnowledgeBase projectKB) {
        KnowledgeBase templateProjectKB = OWLBackwardsCompatibilityProjectFixups.getTemplateKnowledgeBase(projectKB);
        Instance templateProjectInstance = OWLBackwardsCompatibilityProjectFixups.getProjectInstance(templateProjectKB);
        for (Instance widgetInstance : ModelUtilities.getDirectOwnSlotValues((Frame)templateProjectInstance, (String)"customized_instance_widgets")) {
            String widgetClsName = (String)ModelUtilities.getDirectOwnSlotValue((Frame)widgetInstance, (String)"name");
            boolean bl = OWLBackwardsCompatibilityProjectFixups.replaceFormWidget(widgetClsName, projectKB, templateProjectKB);
        }
    }
}

