/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class PropertySuggestionPopup {
    private JList propertyList = new JList();
    private JWindow popupWindow;
    private ConditionsTable table;
    private JPopupMenu popupMenu;
    public static final int POPUP_WIDTH = 220;
    public static final String POPUP_TITLE = "Suggested properties";

    public PropertySuggestionPopup(Window owner, ConditionsTable table) {
        this.propertyList.setCellRenderer(new ResourceRenderer());
        this.propertyList.setRequestFocusEnabled(false);
        this.propertyList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PropertySuggestionPopup.this.insertPropertyName();
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                PropertySuggestionPopup.this.popupWindow.setVisible(false);
            }
        });
        this.popupWindow = new JWindow(owner);
        this.popupWindow.setFocusableWindowState(false);
        this.popupWindow.setFocusable(false);
        final LabeledComponent lc = new LabeledComponent(POPUP_TITLE, new JScrollPane(this.propertyList));
        lc.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        lc.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PropertySuggestionPopup.this.popupMenu.show((Component)lc, e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    PropertySuggestionPopup.this.popupMenu.show((Component)lc, e.getX(), e.getY());
                }
            }
        });
        this.popupWindow.setContentPane((Container)lc);
        this.table = table;
    }

    public void showPopup(OWLNamedClass cls) {
        Set properties = cls.getAssociatedProperties();
        if (properties.size() > 0) {
            this.propertyList.setListData(properties.toArray());
            this.popupWindow.setSize(220, this.table.getParent().getHeight());
            Point p = this.table.getLocation();
            SwingUtilities.convertPointToScreen(p, (Component)((Object)this.table));
            this.popupWindow.setLocation(p.x - this.popupWindow.getWidth() - 10, p.y);
            this.popupWindow.setVisible(true);
        }
    }

    public void hidePopup() {
        this.popupWindow.setVisible(false);
    }

    protected void insertPropertyName() {
        RDFProperty selProperty = (RDFProperty)this.propertyList.getSelectedValue();
        if (selProperty != null) {
            JTextComponent textComponent = this.table.getSymbolEditorComponent().getTextComponent();
            try {
                textComponent.getDocument().insertString(textComponent.getCaretPosition(), selProperty.getName(), null);
            }
            catch (BadLocationException e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
        }
    }
}

